/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.annotation;

import org.junit.Assert;
import org.junit.Test;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.ProcessorFactory;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.impl.SessionBind;
import tigase.xmpp.impl.annotation.TestAnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.TestAnnotatedXMPPProcessor2;

public class AnnotatedXMPPProcessorTest {
    @Test
    public void test1() {
        TestAnnotatedXMPPProcessor test1 = new TestAnnotatedXMPPProcessor();
        for (Object[] objectArray : test1.supElementNamePaths()) {
            Assert.assertArrayEquals((String)"Wrong element paths", (Object[])new String[]{"iq", "query"}, (Object[])objectArray);
        }
        Assert.assertArrayEquals((String)"Wrong xmlnss", (Object[])new String[]{"tigase:test1", "tigase:test2"}, (Object[])test1.supNamespaces());
        Assert.assertArrayEquals((String)"Wrong disco features", (Object[])new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:test1"}), new Element("feature", new String[]{"var"}, new String[]{"tigase:test2"})}, (Object[])test1.supDiscoFeatures(null));
        Assert.assertArrayEquals((String)"Wrong stream features", (Object[])new Element[]{new Element("bind", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})}, (Object[])test1.supStreamFeatures(null));
        Assert.assertTrue((String)"Stanza type not set as 'get'", (boolean)test1.supTypes().contains(StanzaType.get));
    }

    @Test
    public void test2() {
        TestAnnotatedXMPPProcessor2 test2 = new TestAnnotatedXMPPProcessor2();
        Assert.assertNull((String)"Wrong element paths, should not be inherited", (Object)test2.supElementNamePaths());
        Assert.assertNull((String)"Wrong xmlnss", (Object)test2.supNamespaces());
        Assert.assertNull((String)"Wrong disco features", (Object)test2.supDiscoFeatures(null));
        Assert.assertNull((String)"Wrong stream features", (Object)test2.supStreamFeatures(null));
    }

    @Test
    public void testSessionBind() {
        SessionBind sessionBind = new SessionBind();
        Assert.assertEquals((String)"Wrong processor id", (Object)"urn:ietf:params:xml:ns:xmpp-session", (Object)sessionBind.id());
        for (Object[] objectArray : sessionBind.supElementNamePaths()) {
            Assert.assertArrayEquals((String)"Wrong element paths", (Object[])new String[]{"iq", "session"}, (Object[])objectArray);
        }
        Assert.assertArrayEquals((String)"Wrong xmlnss", (Object[])new String[]{"urn:ietf:params:xml:ns:xmpp-session"}, (Object[])sessionBind.supNamespaces());
        Assert.assertArrayEquals((String)"Wrong disco features", (Object[])new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"})}, (Object[])sessionBind.supDiscoFeatures(null));
    }

    @Test
    public void testProcessorFactorySessionBind() throws TigaseStringprepException {
        XMPPProcessorIfc sessionBind = ProcessorFactory.getProcessor((String)"urn:ietf:params:xml:ns:xmpp-session");
        Assert.assertEquals((String)"Wrong processor id", (Object)"urn:ietf:params:xml:ns:xmpp-session", (Object)sessionBind.id());
        for (Object[] objectArray : sessionBind.supElementNamePaths()) {
            Assert.assertArrayEquals((String)"Wrong element paths", (Object[])new String[]{"iq", "session"}, (Object[])objectArray);
        }
        Assert.assertArrayEquals((String)"Wrong xmlnss", (Object[])new String[]{"urn:ietf:params:xml:ns:xmpp-session"}, (Object[])sessionBind.supNamespaces());
        Assert.assertArrayEquals((String)"Wrong disco features", (Object[])new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"})}, (Object[])sessionBind.supDiscoFeatures(null));
        Element iqEl = new Element("iq", new String[]{"type", "id"}, new String[]{"set", "test1"});
        iqEl.addChild((XMLNodeIfc)new Element("session", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"}));
        Packet iq = Packet.packetInstance((Element)iqEl);
        Assert.assertTrue((String)"Packet not handled!", (sessionBind.canHandle(iq, null) == Authorization.AUTHORIZED ? 1 : 0) != 0);
    }
}

