/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PacketTest {
    Packet packetInstance;

    @Before
    public void setUp() {
        JID from = JID.jidInstanceNS((String)"server");
        JID to = JID.jidInstanceNS((String)"user");
        Element property = new Element("property", new String[]{"name", "value", "xmlns"}, new String[]{"some name", "some value", "namespace"});
        Element iq = Command.createIqCommand((JID)from, (JID)to, (StanzaType)StanzaType.get, (String)"myId", (String)"node", (Command.DataType)Command.DataType.submit);
        iq.findChild(new String[]{"iq", "command", "x"}).addChild((XMLNodeIfc)property);
        this.packetInstance = Iq.packetInstance((Element)iq, (JID)from, (JID)to);
        this.packetInstance.getStanzaFrom().getDomain();
    }

    @Test
    public void testOkResult_String_int() {
        String includeXML = null;
        int depth = 5;
        Packet result = this.packetInstance.okResult(includeXML, depth);
        Element property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals((Object)"some name", (Object)property.getAttributeStaticStr("name"));
        Assert.assertEquals((Object)"some value", (Object)property.getAttributeStaticStr("value"));
        Assert.assertEquals((Object)"namespace", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
        depth = 0;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals(null, (Object)property);
        depth = 1;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x"});
        Assert.assertEquals(null, (Object)property);
        property = result.getElement().findChild(new String[]{"iq", "command"});
        Assert.assertEquals((Object)"command", (Object)property.getName());
        Assert.assertEquals((Object)"http://jabber.org/protocol/commands", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals((Object)"node", (Object)property.getAttributeStaticStr("node"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
    }

    @Test
    public void testOkResult_Element_int() {
        Element includeXML = null;
        int depth = 5;
        Packet result = this.packetInstance.okResult(includeXML, depth);
        Element property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals((Object)"some name", (Object)property.getAttributeStaticStr("name"));
        Assert.assertEquals((Object)"some value", (Object)property.getAttributeStaticStr("value"));
        Assert.assertEquals((Object)"namespace", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
        depth = 0;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals(null, (Object)property);
        depth = 1;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x"});
        Assert.assertEquals(null, (Object)property);
        property = result.getElement().findChild(new String[]{"iq", "command"});
        Assert.assertEquals((Object)"command", (Object)property.getName());
        Assert.assertEquals((Object)"http://jabber.org/protocol/commands", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals((Object)"node", (Object)property.getAttributeStaticStr("node"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
    }
}

