/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.impl;

import java.util.HashSet;
import java.util.concurrent.Executor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.impl.LocalEventBus;
import tigase.xml.Element;

public class LocalEventBusTest {
    @Test
    public void test01() {
        final HashSet results = new HashSet();
        LocalEventBus eb = new LocalEventBus();
        eb.setExecutor(new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
        eb.addHandler(null, null, new EventHandler(){

            public void onEvent(String name, String xmlns, Element event) {
                results.add("*.*_" + name + "." + xmlns);
            }
        });
        eb.addHandler(null, "b", new EventHandler(){

            public void onEvent(String name, String xmlns, Element event) {
                results.add("*.b_" + name + "." + xmlns);
            }
        });
        eb.addHandler("a", "b", new EventHandler(){

            public void onEvent(String name, String xmlns, Element event) {
                results.add("a.b_" + name + "." + xmlns);
            }
        });
        try {
            eb.addHandler("a", null, new EventHandler(){

                public void onEvent(String name, String xmlns, Element event) {
                    System.out.println("!!! ");
                    results.add("a.*_" + name + "." + xmlns);
                }
            });
            Assert.fail((String)"This registration should not be possible!");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Illegal handler registration. If name is specified, then xmlns must also be specified.", (Object)e.getMessage());
        }
        eb.fire(new Element("a", new String[]{"xmlns"}, new String[]{"b"}));
        eb.fire(new Element("c", new String[]{"xmlns"}, new String[]{"d"}));
        Assert.assertThat(results, (Matcher)CoreMatchers.hasItem((Object)"*.*_c.d"));
        Assert.assertThat(results, (Matcher)CoreMatchers.hasItem((Object)"*.*_a.b"));
        Assert.assertThat(results, (Matcher)CoreMatchers.hasItem((Object)"*.b_a.b"));
        Assert.assertThat(results, (Matcher)CoreMatchers.hasItem((Object)"a.b_a.b"));
    }
}

