/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPresenceUpdateProcessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;

public class MessageCarbons
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc,
XMPPPresenceUpdateProcessorIfc {
    private static final Logger log = Logger.getLogger(MessageCarbons.class.getCanonicalName());
    private static final String ID = "message-carbons";
    public static final String XMLNS = "urn:xmpp:carbons:2";
    private static final String[][] ELEMENTS = new String[][]{{"message"}, {"iq", "enable"}, {"iq", "disable"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:carbons:2", "urn:xmpp:carbons:2"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:carbons:2"})};
    private static final String ENABLED_KEY = "urn:xmpp:carbons:2-enabled";
    private static final String ENABLED_RESOURCES_KEY = "urn:xmpp:carbons:2-resources";
    private static final String ENABLE_ELEM_NAME = "enable";
    private static final String DISABLE_ELEM_NAME = "disable";
    private static final String[] MESSAGE_HINTS_NO_COPY = new String[]{"message", "no-copy"};
    private static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    private static final Function<String, Object> RESOURCES_MAP_FACTORY = k -> new ConcurrentHashMap();
    private Message messageProcessor = new Message();

    @Override
    public String id() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block22: {
            block20: {
                boolean enable;
                block23: {
                    Boolean oldValue;
                    block21: {
                        boolean disable;
                        if (session == null) {
                            return;
                        }
                        if (packet.getElemName() != "iq") break block20;
                        enable = packet.getElement().getChild(ENABLE_ELEM_NAME, XMLNS) != null;
                        boolean bl = disable = packet.getElement().getChild(DISABLE_ELEM_NAME, XMLNS) != null;
                        if ((!enable || !disable) && (enable || disable)) break block21;
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, false));
                        break block22;
                    }
                    JID sessionJid = session.getJID();
                    if (packet.getStanzaFrom() == null || sessionJid.equals(packet.getStanzaFrom()) || !session.isUserId(packet.getStanzaFrom().getBareJID()) || packet.getStanzaFrom().getResource() == null) break block23;
                    ConcurrentHashMap<JID, Boolean> resources = (ConcurrentHashMap<JID, Boolean>)session.getCommonSessionData(ENABLED_RESOURCES_KEY);
                    if (resources == null) {
                        XMPPSession xMPPSession = session.getParentSession();
                        synchronized (xMPPSession) {
                            resources = (Map)session.getCommonSessionData(ENABLED_RESOURCES_KEY);
                            if (resources == null) {
                                resources = new ConcurrentHashMap<JID, Boolean>();
                                session.putCommonSessionData(ENABLED_RESOURCES_KEY, resources);
                            }
                        }
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "received state notification from {0} with value = {1}", new Object[]{packet.getStanzaFrom(), enable});
                    }
                    if ((oldValue = resources.put(packet.getStanzaFrom(), enable)) != null) break block22;
                    for (XMPPResourceConnection conn : session.getActiveSessions()) {
                        MessageCarbons.notifyStateChanged(conn.getJID(), packet.getStanzaFrom(), MessageCarbons.isEnabled(conn), results);
                    }
                    break block22;
                }
                MessageCarbons.setEnabled(session, enable, results);
                results.offer(packet.okResult((Element)null, 0));
                break block22;
            }
            if (packet.getElemName() == "message" && packet.getType() == StanzaType.chat && packet.getStanzaTo() != null) {
                if (C2SDeliveryErrorProcessor.isDeliveryError(packet)) {
                    return;
                }
                Map resources = (Map)session.getCommonSessionData(ENABLED_RESOURCES_KEY);
                if (resources == null || resources.isEmpty()) {
                    return;
                }
                if (packet.getType() == StanzaType.chat) {
                    if (packet.getElement().getChild("received", XMLNS) != null || packet.getElement().getChild("sent", XMLNS) != null) {
                        return;
                    }
                    if (packet.getAttributeStaticStr(MESSAGE_HINTS_NO_COPY, "xmlns") == MESSAGE_HINTS_XMLNS) {
                        return;
                    }
                    Element privateEl = packet.getElement().getChild("private", XMLNS);
                    if (privateEl != null) {
                        packet.getElement().removeChild(privateEl);
                        return;
                    }
                    String type = session.isUserId(packet.getStanzaTo().getBareJID()) ? "received" : "sent";
                    JID srcJid = JID.jidInstance(session.getBareJID());
                    Set<JID> skipForkingTo = null;
                    if (session.isUserId(packet.getStanzaTo().getBareJID()) && packet.getStanzaTo().getResource() == null) {
                        skipForkingTo = this.messageProcessor.getJIDsForMessageDelivery(session);
                        for (JID jid : resources.keySet()) {
                            if (session.getParentSession().getResourceForJID(jid) != null) continue;
                            skipForkingTo.add(jid);
                        }
                    } else {
                        skipForkingTo = Collections.singleton(session.getJID());
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Sending message carbon copy, packet: {0}, resources {1}, skipForkingTo: {2}, session: {3}", new Object[]{packet, resources, skipForkingTo, session});
                    }
                    for (Map.Entry entry : resources.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        JID jid = (JID)entry.getKey();
                        if (skipForkingTo.contains(entry.getKey())) continue;
                        Packet msgClone = MessageCarbons.prepareCarbonCopy(packet, srcJid, jid, type);
                        results.offer(msgClone);
                    }
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private static Packet prepareCarbonCopy(Packet packet, JID srcJid, JID jid, String type) {
        Packet msgClone = tigase.server.Message.getMessage(srcJid, jid, packet.getType(), null, null, null, packet.getStanzaId());
        Element received = new Element(type);
        received.setXMLNS(XMLNS);
        msgClone.getElement().addChild(received);
        Element forwarded = new Element("forwarded");
        forwarded.setXMLNS("urn:xmpp:forward:0");
        received.addChild(forwarded);
        forwarded.addChild(packet.getElement().clone());
        return msgClone;
    }

    private static void setEnabled(XMPPResourceConnection session, boolean value, Queue<Packet> results) throws NotAuthorizedException {
        session.putSessionData(ENABLED_KEY, value);
        Map resources = (Map)session.getCommonSessionData(ENABLED_RESOURCES_KEY);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "session = {0} enabling urn:xmpp:carbons:2, resources to notify = {1}", new Object[]{session, resources == null ? "null" : Integer.valueOf(resources.size())});
        }
        if (resources != null) {
            JID fromJid = session.getJID();
            for (JID jid : resources.keySet()) {
                if (jid.equals(fromJid)) continue;
                MessageCarbons.notifyStateChanged(fromJid, jid, value, results);
            }
        }
    }

    private static boolean isEnabled(XMPPResourceConnection session) throws NotAuthorizedException {
        Boolean value = (Boolean)session.getSessionData(ENABLED_KEY);
        return value != null && value != false;
    }

    private static void notifyStateChanged(JID from, JID to, boolean value, Queue<Packet> results) {
        if (from.equals(to)) {
            return;
        }
        Element iq = new Element("iq", new String[]{"xmlns", "type"}, new String[]{"jabber:client", StanzaType.set.name()});
        Element enable = new Element(value ? ENABLE_ELEM_NAME : DISABLE_ELEM_NAME, new String[]{"xmlns"}, new String[]{XMLNS});
        iq.addChild(enable);
        Packet packet = Packet.packetInstance(iq, from, to);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "sending state notification = {0}", packet);
        }
        results.offer(packet);
    }

    @Override
    public void presenceUpdate(XMPPResourceConnection session, Packet packet, Queue<Packet> results) throws NotAuthorizedException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "session = {0} processing presence = {1}", new Object[]{session, packet.toString()});
        }
        ConcurrentHashMap resources = (ConcurrentHashMap)session.computeCommonSessionDataIfAbsent(ENABLED_RESOURCES_KEY, RESOURCES_MAP_FACTORY);
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            if (resources.putIfAbsent(packet.getStanzaFrom(), false) != null) {
                return;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "session = {0} adding resource = {1} to list of available resources", new Object[]{session, packet.getStanzaFrom()});
            }
            for (XMPPResourceConnection res : session.getActiveSessions()) {
                if (!res.isAuthorized()) continue;
                MessageCarbons.notifyStateChanged(res.getJID(), packet.getStanzaFrom(), MessageCarbons.isEnabled(res), results);
            }
        } else if (type == StanzaType.unavailable) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "session = {0} removing resource = {1} from list of available resources", new Object[]{session, packet.getStanzaFrom()});
            }
            resources.remove(packet.getStanzaFrom());
        }
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized() || results == null || results.size() == 0 || packet == null) {
            return;
        }
        if (packet.getElemName() != "message") {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Element messageEl;
            Element privateEl;
            Packet res = (Packet)it.next();
            if (res.getElemName() != "message") continue;
            if (this.isErrorDeliveringForkedMessage(packet, session)) {
                it.remove();
            }
            if ((privateEl = (messageEl = res.getElement()).getChild("private", XMLNS)) == null) continue;
            messageEl.removeChild(privateEl);
        }
    }

    private boolean isErrorDeliveringForkedMessage(Packet packet, XMPPResourceConnection session) {
        if (!session.isAuthorized() || packet.getStanzaTo() == null) {
            return false;
        }
        try {
            if (packet.getType() == StanzaType.error && packet.getStanzaTo().getResource() == null && session.isUserId(packet.getStanzaTo().getBareJID())) {
                Element messageEl = packet.getElement();
                Element sentEl = messageEl.getChild("sent", XMLNS);
                if (sentEl != null) {
                    return true;
                }
                Element receivedEl = messageEl.getChild("received", XMLNS);
                if (receivedEl != null) {
                    return true;
                }
            }
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        return false;
    }
}

