/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.SocketType;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;

public class WebSocketHixie76
implements WebSocketProtocolIfc {
    private static final Logger log = Logger.getLogger(WebSocketHixie76.class.getCanonicalName());
    public static final String ID = "hixie-76";
    private static final String RESPONSE_HEADER = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Methods: GET, POST, OPTIONS\r\nAccess-Control-Allow-Headers: Content-Type\r\nAccess-Control-Max-Age: 86400\r\n";
    private static final String HOST_KEY = "Host";
    private static final String ORIGIN_KEY = "Origin";
    private static final String WS_KEY1_KEY = "Sec-WebSocket-Key1";
    private static final String WS_KEY2_KEY = "Sec-WebSocket-Key2";
    private static final String WS_ORIGIN_KEY = "Sec-WebSocket-Origin";
    private static final String WS_LOCATION_KEY = "Sec-WebSocket-Location";
    private static final byte[] FRAME_HEADER = new byte[]{0};
    private static final byte[] FRAME_FOOTER = new byte[]{-1};

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean handshake(WebSocketXMPPIOService service, Map<String, String> headers, byte[] buf) throws NoSuchAlgorithmException, IOException {
        if (headers.containsKey("Sec-WebSocket-Version")) {
            return false;
        }
        byte[] secBufArr = new byte[16];
        Long secKey1 = this.decodeHyxie76SecKey(headers.get(WS_KEY1_KEY));
        Long secKey2 = this.decodeHyxie76SecKey(headers.get(WS_KEY2_KEY));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "WS-KEY1 = {0}", secKey1);
            log.log(Level.FINEST, "WS-KEY2 = {0}", secKey2);
        }
        this.uintToBytes(secBufArr, 0, secKey1);
        this.uintToBytes(secBufArr, 4, secKey2);
        if (buf[buf.length - 9] != 10) {
            throw new IOException("buf[len-9] != \\n!!");
        }
        for (int j = 8; j > 0; --j) {
            secBufArr[16 - j] = buf[buf.length - j];
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] resp = md.digest(secBufArr);
        StringBuilder response = new StringBuilder(RESPONSE_HEADER.length() * 2);
        response.append(RESPONSE_HEADER);
        response.append("Content-Length: ").append(resp.length).append("\r\n");
        response.append("Sec-WebSocket-Protocol").append(": ");
        if (headers.get("Sec-WebSocket-Protocol").contains("xmpp-framing")) {
            response.append("xmpp-framing");
        } else {
            response.append("xmpp");
        }
        response.append("\r\n");
        if (headers.containsKey(ORIGIN_KEY)) {
            response.append(WS_ORIGIN_KEY).append(": ").append(headers.get(ORIGIN_KEY)).append("\r\n");
        }
        boolean ssl = SocketType.ssl == (SocketType)((Object)service.getSessionData().get("socket"));
        int localPort = service.getLocalPort();
        String location = (ssl ? "wss://" : "ws://") + headers.get(HOST_KEY) + (ssl && localPort == 443 || !ssl && localPort == 80 || headers.get(HOST_KEY).contains(":") ? "" : ":" + localPort) + "/";
        response.append(WS_LOCATION_KEY).append(": ").append(location).append("\r\n");
        response.append("\r\n");
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "sending response = \n{0}", response.toString());
        }
        byte[] respBytes = response.toString().getBytes();
        ByteBuffer out = ByteBuffer.allocate(respBytes.length + 16);
        out.put(respBytes);
        out.put(resp);
        out.flip();
        service.writeBytes(out);
        return true;
    }

    @Override
    public ByteBuffer decodeFrame(WebSocketXMPPIOService service, ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no content remainging to process");
            }
            return null;
        }
        int position = buf.position();
        byte type = buf.get();
        log.finest("read type = " + type);
        if ((type & 0x80) != 128) {
            int idx = position + 1;
            int remaining = buf.remaining();
            log.finest("remaining = " + remaining + " on position " + position);
            while (remaining - (idx - position) >= 0) {
                log.finest("checking byte at " + idx + " = " + buf.get(idx));
                if (buf.get(idx) != -1) {
                    ++idx;
                    continue;
                }
                log.finest("found data of " + (idx - position - 1) + " bytes");
                byte[] data = new byte[idx - position - 1];
                buf.get(data);
                buf.position(buf.position() + 1);
                log.finest("read data = " + new String(data));
                return ByteBuffer.wrap(data);
            }
            buf.position(position);
            return null;
        }
        long len = 0L;
        byte b = 0;
        while (((b = buf.get()) & 0x80) == 128) {
            len = len * 128L + (long)(b & 0x7F);
        }
        if ((len = len * 128L + (long)(b & 0x7F)) == 0L) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("closing connection due to client request");
            }
            service.setState(WebSocketXMPPIOService.State.closed);
            return null;
        }
        if ((long)buf.remaining() < len) {
            buf.position(position);
            return null;
        }
        byte[] data = new byte[(int)len];
        buf.get(data);
        return ByteBuffer.wrap(data);
    }

    @Override
    public void encodeFrameAndWrite(WebSocketXMPPIOService service, ByteBuffer buf) throws IOException {
        service.writeBytes(ByteBuffer.wrap(FRAME_HEADER));
        service.writeBytes(buf);
        service.writeBytes(ByteBuffer.wrap(FRAME_FOOTER));
    }

    @Override
    public void closeConnection(WebSocketXMPPIOService service) {
        if (!service.isConnected()) {
            return;
        }
        service.setState(WebSocketXMPPIOService.State.closed);
        service.writeBytes(ByteBuffer.wrap(new byte[]{-1, 0}));
    }

    private void uintToBytes(byte[] arr, int offset, long val) {
        for (int i = 3; i >= 0; --i) {
            arr[offset + i] = (byte)(val % 256L);
            val /= 256L;
        }
    }

    private Long decodeHyxie76SecKey(String data) {
        long result = 0L;
        int spaces = 0;
        block13: for (char ch : data.trim().toCharArray()) {
            switch (ch) {
                case '0': {
                    result = result * 10L + 0L;
                    continue block13;
                }
                case '1': {
                    result = result * 10L + 1L;
                    continue block13;
                }
                case '2': {
                    result = result * 10L + 2L;
                    continue block13;
                }
                case '3': {
                    result = result * 10L + 3L;
                    continue block13;
                }
                case '4': {
                    result = result * 10L + 4L;
                    continue block13;
                }
                case '5': {
                    result = result * 10L + 5L;
                    continue block13;
                }
                case '6': {
                    result = result * 10L + 6L;
                    continue block13;
                }
                case '7': {
                    result = result * 10L + 7L;
                    continue block13;
                }
                case '8': {
                    result = result * 10L + 8L;
                    continue block13;
                }
                case '9': {
                    result = result * 10L + 9L;
                    continue block13;
                }
                case ' ': {
                    ++spaces;
                    continue block13;
                }
            }
        }
        return result / (long)spaces;
    }
}

