/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.action;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.server.amp.AmpFeatureIfc;
import tigase.server.amp.MsgRepository;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Broadcast
implements AmpFeatureIfc {
    private static final Logger log = Logger.getLogger(Broadcast.class.getName());
    private static final String name = "broadcast";
    private MsgRepository repo = null;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat formatter2;
    private ActionResultsHandlerIfc resultsHandler;

    public Broadcast() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preprocess(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "processing packet = {0}", packet.toString());
        }
        if (packet.getElemName() == "presence") {
            this.sendBroadcastMessage(packet.getStanzaFrom());
            return true;
        }
        Element broadcast = packet.getElement().getChild(name, "http://tigase.org/protocol/broadcast");
        if (broadcast == null) return false;
        if (packet.getAttributeStaticStr("from-conn-id") != null) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "processing broadcast packet = {0}", packet);
        }
        if (this.repo != null) {
            if (packet.getStanzaTo().getResource() == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "setting broadcast request for user {0}", packet.getStanzaTo());
                }
                Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
                Element rule = null;
                for (Element elem : amp.getChildren()) {
                    if (!"rule".equals(elem.getName()) || !"expire-at".equals(elem.getAttributeStaticStr("condition"))) continue;
                    rule = elem;
                    break;
                }
                if (rule == null) return false;
                String value = rule.getAttributeStaticStr("value");
                Date expire = null;
                try {
                    SimpleDateFormat simpleDateFormat;
                    if (value == null) return true;
                    if (value.contains(".")) {
                        simpleDateFormat = this.formatter;
                        synchronized (simpleDateFormat) {
                            expire = this.formatter.parse(value);
                        }
                    }
                    simpleDateFormat = this.formatter2;
                    synchronized (simpleDateFormat) {
                        expire = this.formatter2.parse(value);
                    }
                    packet.getElement().removeAttribute("to-conn-id");
                    packet.getElement().removeAttribute("to-res");
                    packet.getElement().removeAttribute("offline");
                    packet.getElement().removeAttribute("from-conn-id");
                    packet.getElement().removeAttribute("expired");
                    Element msg = packet.getElement().clone();
                    msg.removeAttribute("to");
                    String msgId = packet.getAttributeStaticStr("id");
                    MsgRepository.BroadcastMsg bmsg = this.repo.getBroadcastMsg(msgId);
                    boolean needToBroadcast = bmsg == null || !bmsg.needToSend(packet.getStanzaTo());
                    this.repo.updateBroadcastMessage(msgId, msg, expire, packet.getStanzaTo().getBareJID());
                    if (!needToBroadcast) return true;
                    Packet broadcastCmd = Command.BROADCAST_TO_ONLINE.getPacket(packet.getPacketTo(), JID.jidInstanceNS("sess-man", packet.getPacketTo().getDomain(), null), StanzaType.get, name);
                    Command.addFieldValue(broadcastCmd, "to", packet.getStanzaTo().toString());
                    msg = packet.getElement().clone();
                    msg.removeAttribute("to");
                    msg.setAttribute("xmlns", "http://tigase.org/protocol/broadcast");
                    broadcastCmd.getElement().addChild(msg);
                    this.resultsHandler.addOutPacket(broadcastCmd);
                    return true;
                }
                catch (ParseException ex) {
                    log.info("Incorrect expire-at condition value for rule: " + rule);
                }
                return true;
            }
            String msgId = packet.getAttributeStaticStr("id");
            MsgRepository.BroadcastMsg msg = this.repo.getBroadcastMsg(msgId);
            if (msg != null) {
                packet.getElement().removeChild(broadcast);
                msg.markAsSent(packet.getStanzaTo());
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "marking broadcast of message = {0} for user {1} as done, result = {2}", new Object[]{msgId, packet.getStanzaTo(), msg.needToSend(packet.getStanzaTo())});
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "not found broadcast request with id = {0} for user {1}, keys = {2}", new Object[]{msgId, packet.getStanzaTo(), this.repo.dumpBroadcastMessageKeys()});
            }
            if (packet.getPacketTo() == null) return true;
            if (packet.getPacketTo().getDomain().equals(packet.getPacketFrom().getDomain())) return false;
            return true;
        }
        log.log(Level.FINEST, "repository is NULL !!");
        return false;
    }

    public void sendBroadcastMessage(JID jid) {
        if (this.repo != null) {
            for (MsgRepository.BroadcastMsg o : this.repo.getBroadcastMessages()) {
                MsgRepository.BroadcastMsg msg = o;
                if (msg.getDelay(TimeUnit.MILLISECONDS) <= 0L || !msg.needToSend(jid)) continue;
                try {
                    this.sendBroadcastMessage(jid, msg);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.WARNING, "should not happen, contact developer", ex);
                }
            }
        }
    }

    public void sendBroadcastMessage(JID jid, MsgRepository.BroadcastMsg msg) throws TigaseStringprepException {
        Element msgEl = msg.msg.clone();
        msgEl.setAttribute("to", jid.toString());
        Packet p = Packet.packetInstance(msgEl);
        this.resultsHandler.addOutPacket(p);
    }

    @Override
    public String getName() {
        return name;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        HashMap<String, Object> defs = new HashMap<String, Object>();
        String db_uri = (String)params.get("--amp-repo-uri");
        String db_cls = (String)params.get("--amp-repo-class");
        if (db_uri == null) {
            db_uri = (String)params.get("--user-db-uri");
        }
        if (db_uri != null) {
            defs.put("amp-repo-uri", db_uri);
        }
        if (db_cls != null) {
            defs.put("amp-repo-class", db_cls);
        }
        return defs;
    }

    public void setProperties(Map<String, Object> props, ActionResultsHandlerIfc handler) {
        this.resultsHandler = handler;
        String db_uri = (String)props.get("amp-repo-uri");
        String db_cls = (String)props.get("amp-repo-class");
        if (db_uri != null) {
            try {
                this.repo = (MsgRepository)MsgRepository.getInstance(db_cls, db_uri);
                HashMap<String, String> db_props = new HashMap<String, String>(4);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (entry.getValue() == null) continue;
                    log.log(Level.CONFIG, "Reading properties: (" + entry.getKey() + ", " + entry.getValue() + ")");
                    if (entry.getValue() instanceof String[]) {
                        String[] val = (String[])entry.getValue();
                        db_props.put(entry.getKey(), Stream.of(val).collect(Collectors.joining(",")));
                        continue;
                    }
                    db_props.put(entry.getKey(), entry.getValue().toString());
                }
                this.repo.initRepository(db_uri, db_props);
                this.repo.loadMessagesToBroadcast();
            }
            catch (TigaseDBException ex) {
                this.repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
    }
}

