/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.Initializable;
import tigase.kernel.Inject;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorContext;
import tigase.monitor.MonitorTask;
import tigase.monitor.TimerTaskService;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.util.TimerTask;
import tigase.xml.Element;

public class MemoryMonitorTask
implements MonitorTask,
Initializable,
InfoTask {
    @Inject
    private MonitorContext context;
    private final Runtime runtime = Runtime.getRuntime();
    @Inject(bean="timerTaskService")
    private TimerTaskService timerTaskService;
    protected long usedMemory = -1L;
    private final TimerTask worker = new TimerTask(){

        @Override
        public void run() {
            MemoryMonitorTask.this.usedMemory = MemoryMonitorTask.this.runtime.totalMemory() - MemoryMonitorTask.this.runtime.freeMemory();
            if (MemoryMonitorTask.this.usedMemory / 1024L / 1024L > 133L) {
                Element m = new Element("message", new String[]{"to"}, new String[]{"alice@coffeebean.local"});
                m.addChild(new Element("body", "Uuuuu! Pamieci malo!!!! Uzyto " + MemoryMonitorTask.this.usedMemory / 1024L / 1024L + " MB"));
                try {
                    Packet p = Packet.packetInstance(m);
                    p.setXMLNS("jabber:client");
                    MemoryMonitorTask.this.context.getWriter().write(p);
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public MonitorContext getContext() {
        return this.context;
    }

    @Override
    public Form getTaskInfo() {
        Form f = new Form("result", "Memory Monitor Info ", null);
        f.addField(Field.fieldTextSingle("mem-usage", "" + this.usedMemory / 1024L / 1024L, "Memory usage [MB]"));
        return f;
    }

    public TimerTaskService getTimerTaskService() {
        return this.timerTaskService;
    }

    @Override
    public void initialize() {
        this.timerTaskService.addTimerTask(this.worker, 1000L, 1000L);
    }

    public void setContext(MonitorContext context) {
        this.context = context;
    }

    public void setTimerTaskService(TimerTaskService timerTaskService) {
        this.timerTaskService = timerTaskService;
    }
}

