/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import tigase.disteventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTask;
import tigase.util.DateTimeFormatter;
import tigase.util.LogFormatter;
import tigase.xml.Element;

@Bean(name="logger-task")
public class LoggerTask
extends AbstractConfigurableTask {
    protected static final DateTimeFormatter dtf = new DateTimeFormatter();
    private static final String LOGGER_MONITOR_EVENT_NAME = "LoggerMonitorEvent";
    @Inject
    protected MonitorComponent component;
    @Inject
    protected EventBus eventBus;
    private long lastWarningSent = 0L;
    private Level levelTreshold = Level.WARNING;
    private int loggerSize = 50;
    private long logWarings = 0L;
    private int maxLogBuffer = 1000000;
    private MemoryHandlerFlush memoryHandler = null;
    private MonitorHandler monitorHandler = null;

    @Override
    protected void disable() {
        this.removeHandler();
        super.disable();
    }

    @Override
    protected void enable() {
        this.registerHandler();
        super.enable();
    }

    @Override
    public Form getCurrentConfiguration() {
        Form f = super.getCurrentConfiguration();
        Field x = Field.fieldListSingle("levelTreshold", this.levelTreshold.getName(), "Log level threshold", new String[]{Level.SEVERE.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()}, new String[]{Level.SEVERE.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()});
        f.addField(x);
        return f;
    }

    public Level getLevelTreshold() {
        return this.levelTreshold;
    }

    private void registerHandler() {
        this.removeHandler();
        if (this.monitorHandler == null) {
            this.monitorHandler = new MonitorHandler();
            this.monitorHandler.setLevel(Level.ALL);
        }
        this.memoryHandler = new MemoryHandlerFlush(this.monitorHandler, this.loggerSize, this.levelTreshold);
        this.memoryHandler.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(this.memoryHandler);
    }

    private void removeHandler() {
        if (this.memoryHandler != null) {
            Logger.getLogger("").removeHandler(this.memoryHandler);
        }
    }

    public void sendWarningOut(String logBuff) {
        Element event = new Element(LOGGER_MONITOR_EVENT_NAME, new String[]{"xmlns"}, new String[]{"tigase:monitor:event"});
        event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
        event.addChild(new Element("timestamp", "" + dtf.formatDateTime(new Date())));
        event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
        event.addChild(new Element("log", logBuff));
        this.eventBus.fire(event);
    }

    public void setLevelTreshold(String levelTreshold) {
        boolean reregister = false;
        if (levelTreshold != null) {
            Level v = Level.parse(levelTreshold);
            reregister |= !v.equals(this.levelTreshold);
            this.levelTreshold = v;
        }
        if (reregister) {
            this.registerHandler();
        }
        System.out.println("HAAAAA " + this.levelTreshold);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field f = form.get("levelTreshold");
        if (f != null) {
            this.setLevelTreshold(f.getValue());
        }
        super.setNewConfiguration(form);
    }

    private class MonitorHandler
    extends Handler {
        private LogFormatter formatter = new LogFormatter();
        private LinkedList<String> logs = new LinkedList();

        private MonitorHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public synchronized void flush() {
            ++LoggerTask.this.logWarings;
            if (System.currentTimeMillis() - LoggerTask.this.lastWarningSent > 300000L) {
                String logBuff = this.logsToString();
                LoggerTask.this.sendWarningOut(logBuff);
                LoggerTask.this.lastWarningSent = System.currentTimeMillis();
            }
        }

        public synchronized String logsToString() {
            StringBuilder sb = new StringBuilder();
            String logEntry = null;
            while ((logEntry = this.logs.pollLast()) != null && sb.length() < LoggerTask.this.maxLogBuffer) {
                sb.insert(0, logEntry);
            }
            this.logs.clear();
            String result = sb.length() <= LoggerTask.this.maxLogBuffer ? sb.toString() : sb.substring(sb.length() - LoggerTask.this.maxLogBuffer);
            return result;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            String logEntry = this.formatter.format(record).replace('<', '[').replace('>', ']');
            this.logs.add(logEntry);
        }
    }

    private class MemoryHandlerFlush
    extends MemoryHandler {
        MonitorHandler monHandle;

        public MemoryHandlerFlush(MonitorHandler target, int size, Level pushLevel) {
            super(target, size, pushLevel);
            this.monHandle = null;
            this.monHandle = target;
        }

        @Override
        public void push() {
            super.push();
            this.flush();
        }

        public String pushToString() {
            super.push();
            return this.monHandle.logsToString();
        }
    }
}

