/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.HashSet;
import tigase.disteventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;

@Bean(name="load-checker-task")
public class LoadCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask {
    private static final DateTimeFormatter dtf = new DateTimeFormatter();
    public static final String MONITOR_EVENT_NAME = "LoadAverageMonitorEvent";
    private long averageLoadThreshold = 10L;
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @Inject
    private MonitorRuntime runtime;
    private final HashSet<String> triggeredEvents = new HashSet();

    public long getAverageLoadThreshold() {
        return this.averageLoadThreshold;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle("averageLoadThreshold", String.valueOf(this.averageLoadThreshold), "Alarm when AverageLoad is bigger than"));
        return form;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Load Information", "");
        result.addField(Field.fieldTextSingle("averageLoad", Double.toString(this.runtime.getLoadAverage()), "Load Average"));
        return result;
    }

    @Override
    protected void run() {
        double curAverageLoad = this.runtime.getLoadAverage();
        if (curAverageLoad >= (double)this.averageLoadThreshold) {
            Element event = new Element(MONITOR_EVENT_NAME, new String[]{"xmlns"}, new String[]{"tigase:monitor:event"});
            event.addChild(new Element("timestamp", "" + dtf.formatDateTime(new Date())));
            event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild(new Element("averageLoad", Double.toString(curAverageLoad)));
            event.addChild(new Element("message", "Average Load is higher than " + this.averageLoadThreshold + " and it is equals " + Double.toString(curAverageLoad)));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(MONITOR_EVENT_NAME);
        }
    }

    public void setAverageLoadThreshold(Long averageLoadThreshold) {
        this.averageLoadThreshold = averageLoadThreshold;
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field tmp = form.get("averageLoadThreshold");
        if (tmp != null) {
            this.averageLoadThreshold = Long.parseLong(tmp.getValue());
        }
        super.setNewConfiguration(form);
    }
}

