/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tigase.kernel.BeanConfig;
import tigase.kernel.Dependency;
import tigase.kernel.DependencyManager;
import tigase.kernel.Initializable;
import tigase.kernel.KernelException;
import tigase.kernel.UnregisterAware;

public class Kernel {
    private final Map<BeanConfig, Object> beanInstances = new HashMap<BeanConfig, Object>();
    private final DependencyManager dependencyManager = new DependencyManager();
    private boolean initialized = false;

    static String prepareAccessorMainPartName(String fieldName) {
        if (fieldName.length() == 1) {
            return fieldName.toUpperCase();
        }
        String r = Character.isUpperCase(fieldName.charAt(1)) ? fieldName.substring(0, 1) : fieldName.substring(0, 1).toUpperCase();
        r = r + fieldName.substring(1);
        return r;
    }

    private void configureBean(BeanConfig beanConfig, Object bean, Map<BeanConfig, Object> ... createdBeans) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Dependency de : beanConfig.getFieldDependencies().values()) {
            if ("ss".equals(de.getField().getName())) {
                System.out.println("! " + de.getField());
            }
            Object[] depBeans = this.getInstance(de, createdBeans);
            this.inject(depBeans, de, bean);
        }
    }

    private Object createNewInstance(BeanConfig beanConfig) {
        try {
            Class<?> clz = beanConfig.getClazz();
            return clz.newInstance();
        }
        catch (Exception e) {
            throw new KernelException("Can't create instance of bean '" + beanConfig.getBeanName() + "'", e);
        }
    }

    DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public <T> T getInstance(Class<T> beanClass) {
        List<BeanConfig> bcs;
        if (!this.initialized) {
            this.init();
        }
        if ((bcs = this.dependencyManager.getBeanConfigs(beanClass)).size() > 1) {
            throw new KernelException("Too many beans implemented given class.");
        }
        if (bcs.isEmpty()) {
            throw new KernelException("Can't find bean implementing given class.");
        }
        Object result = this.beanInstances.get(bcs.get(0));
        return (T)result;
    }

    private Object[] getInstance(Dependency dependency, Map<BeanConfig, Object> ... createdBeans) {
        BeanConfig[] bcs;
        ArrayList<Object> result = new ArrayList<Object>();
        for (BeanConfig bc : bcs = this.dependencyManager.getBeanConfig(dependency)) {
            for (Map<BeanConfig, Object> map : createdBeans) {
                if (!map.containsKey(bc)) continue;
                result.add(map.get(bc));
            }
        }
        if (result.size() > 1 && dependency.getType() != null) {
            Object[] z = (Object[])Array.newInstance(dependency.getType(), 1);
            return result.toArray(z);
        }
        return result.toArray();
    }

    public <T> T getInstance(String beanName) {
        BeanConfig bc;
        if (!this.initialized) {
            this.init();
        }
        if ((bc = this.dependencyManager.getBeanConfig(beanName)) == null) {
            throw new KernelException("Unknown bean '" + beanName + "'.");
        }
        Object result = this.beanInstances.get(bc);
        return (T)result;
    }

    public Collection<String> getNamesOf(Class<?> beanType) {
        ArrayList<String> result = new ArrayList<String>();
        List<BeanConfig> bcs = this.dependencyManager.getBeanConfigs(beanType);
        for (BeanConfig beanConfig : bcs) {
            result.add(beanConfig.getBeanName());
        }
        return Collections.unmodifiableCollection(result);
    }

    protected void init() {
        ArrayList<BeanConfig> bconfigs = new ArrayList<BeanConfig>(this.dependencyManager.getBeanConfigs());
        Iterator it = bconfigs.iterator();
        while (it.hasNext()) {
            BeanConfig c = (BeanConfig)it.next();
            if (!this.beanInstances.containsKey(c)) continue;
            it.remove();
        }
        this.init(bconfigs);
        this.initialized = true;
    }

    protected void init(Collection<BeanConfig> beanConfigs) {
        try {
            HashMap<BeanConfig, Object> beans = new HashMap<BeanConfig, Object>();
            for (BeanConfig beanConfig : beanConfigs) {
                beans.put(beanConfig, this.createNewInstance(beanConfig));
            }
            for (Map.Entry entry : beans.entrySet()) {
                this.configureBean((BeanConfig)entry.getKey(), entry.getValue(), beans, this.beanInstances);
            }
            this.beanInstances.putAll(beans);
            for (Map.Entry entry : beans.entrySet()) {
                if (!(entry.getValue() instanceof Initializable)) continue;
                ((Initializable)entry.getValue()).initialize();
            }
        }
        catch (Exception e) {
            throw new KernelException(e);
        }
    }

    private void inject(Object data, Dependency dependency, Object toBean) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (data == null) {
            Method setter = this.prepareSetterMethod(dependency.getField());
            setter.invoke(toBean, new Object[]{null});
        } else if (!Collection.class.isAssignableFrom(dependency.getField().getType())) {
            Object o;
            if (data != null && dependency.getField().getType().equals(data.getClass())) {
                o = data;
            } else {
                int l = Array.getLength(data);
                if (l > 1) {
                    throw new KernelException("Can't put many objects to single field");
                }
                o = l == 0 ? null : Array.get(data, 0);
            }
            Method setter = this.prepareSetterMethod(dependency.getField());
            setter.invoke(toBean, o);
        }
    }

    private Method prepareSetterMethod(Field f) {
        String sm;
        String t = Kernel.prepareAccessorMainPartName(f.getName());
        if (f.getType().isPrimitive() && f.getType().equals(Boolean.TYPE)) {
            sm = "set" + t;
            String gm = "is" + t;
        } else {
            sm = "set" + t;
            String gm = "get" + t;
        }
        try {
            Method m = f.getDeclaringClass().getMethod(sm, f.getType());
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new KernelException("Class " + f.getDeclaringClass().getName() + " has no setter of field " + f.getName(), e);
        }
    }

    public void registerBean(String beanName, Object bean) {
        BeanConfig bc = this.dependencyManager.registerBeanClass(beanName, bean.getClass());
        this.beanInstances.put(bc, bean);
    }

    public void registerBeanClass(String beanName, Class<?> beanClass) {
        BeanConfig bc = this.dependencyManager.registerBeanClass(beanName, beanClass);
        if (this.initialized) {
            this.init(Collections.singleton(bc));
        }
    }

    public void unregister(String beanName) {
        BeanConfig removingBC = this.dependencyManager.getBeanConfig(beanName);
        Object i = this.beanInstances.remove(removingBC);
        if (i instanceof UnregisterAware) {
            try {
                ((UnregisterAware)i).beforeUnregister();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            for (BeanConfig bc : this.dependencyManager.getBeanConfigs()) {
                Object ob = this.beanInstances.get(bc);
                for (Dependency d : bc.getFieldDependencies().values()) {
                    BeanConfig cbc;
                    BeanConfig[] cbcs = this.dependencyManager.getBeanConfig(d);
                    if (cbcs.length != 1 || (cbc = cbcs[0]) == null || !cbc.equals(removingBC)) continue;
                    this.inject(null, d, ob);
                }
            }
        }
        catch (Exception e) {
            throw new KernelException(e);
        }
    }
}

