/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Map;
import java.util.Set;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.disteventbus.component.ListenerScript;
import tigase.disteventbus.component.ListenerScriptRegistrar;
import tigase.form.Field;
import tigase.form.Form;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class RemoveListenerScriptCommand
implements AdHocCommand {
    private ListenerScriptRegistrar listenerScriptRegistrar;
    private Map<String, ListenerScript> listenersScripts;

    public RemoveListenerScriptCommand(Map<String, ListenerScript> listenersScripts, ListenerScriptRegistrar listenerScriptRegistrar) {
        this.listenersScripts = listenersScripts;
        this.listenerScriptRegistrar = listenerScriptRegistrar;
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("form", "Delete listener script", null);
                Set<String> scriptNames = this.listenersScripts.keySet();
                form.addField(Field.fieldListSingle("delete_script", "", "Script to delete", scriptNames.toArray(new String[0]), scriptNames.toArray(new String[0])));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    String scriptName = form.getAsString("delete_script");
                    this.listenerScriptRegistrar.delete(scriptName);
                    ListenerScript i = this.listenersScripts.remove(scriptName);
                    if (i != null) {
                        i.unregister();
                    } else {
                        throw new RuntimeException("Are you kidding me?");
                    }
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Remove listener script";
    }

    @Override
    public String getNode() {
        return "remove-listener-script";
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return true;
    }
}

