/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.FireEventException;
import tigase.disteventbus.component.NodeNameUtil;
import tigase.xml.Element;

public class LocalEventBus
implements EventBus {
    private static final String NULL_NAME = new String(new byte[]{0});
    private final Map<String, Map<String, List<EventHandler>>> handlers = this.createMainHandlersMap();
    private final List<LocalEventBusListener> internalListeners = new ArrayList<LocalEventBusListener>();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private boolean throwingExceptionOn = true;

    @Override
    public void addHandler(String name, String xmlns, EventHandler handler) {
        List<EventHandler> handlersList;
        String eventName = name == null ? NULL_NAME : name;
        Map<String, List<EventHandler>> namesHandlers = this.handlers.get(xmlns);
        if (namesHandlers == null) {
            namesHandlers = this.createNamesHandlerMap();
            this.handlers.put(xmlns, namesHandlers);
        }
        if ((handlersList = namesHandlers.get(eventName)) == null) {
            handlersList = this.createHandlersList();
            namesHandlers.put(eventName, handlersList);
        }
        handlersList.add(handler);
        this.fireOnAddHandler(name, xmlns, handler);
    }

    public void addListener(LocalEventBusListener listener) {
        this.internalListeners.add(listener);
    }

    protected List<EventHandler> createHandlersList() {
        return new ArrayList<EventHandler>();
    }

    protected Map<String, Map<String, List<EventHandler>>> createMainHandlersMap() {
        return new ConcurrentHashMap<String, Map<String, List<EventHandler>>>();
    }

    protected Map<String, List<EventHandler>> createNamesHandlerMap() {
        return new ConcurrentHashMap<String, List<EventHandler>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFire(String name, String xmlns, Element event) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>();
        Map<String, Map<String, List<EventHandler>>> map = this.handlers;
        synchronized (map) {
            handlers.addAll(this.getHandlersList(name, xmlns));
            handlers.addAll(this.getHandlersList(null, xmlns));
        }
        this.doFire(name, xmlns, event, handlers);
    }

    public void doFire(String name, String xmlns, Element event, ArrayList<EventHandler> handlersList) {
        HashSet<Throwable> causes = new HashSet<Throwable>();
        for (EventHandler eventHandler : handlersList) {
            try {
                eventHandler.onEvent(name, xmlns, event);
            }
            catch (Throwable e) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "", e);
                }
                causes.add(e);
            }
        }
        if (!causes.isEmpty() && this.throwingExceptionOn) {
            throw new FireEventException(causes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire(Element event) {
        String name = event.getName();
        String xmlns = event.getXMLNS();
        try {
            this.doFire(name, xmlns, event);
        }
        finally {
            this.fireOnFire(name, xmlns, event);
        }
    }

    private void fireOnAddHandler(String name, String xmlns, EventHandler handler) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onAddHandler(name, xmlns, handler);
        }
    }

    private void fireOnFire(String name, String xmlns, Element event) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onFire(name, xmlns, event);
        }
    }

    private void fireOnRemoveHandler(String name, String xmlns, EventHandler handler) {
        for (LocalEventBusListener listener : this.internalListeners) {
            listener.onRemoveHandler(name, xmlns, handler);
        }
    }

    public Set<EventName> getAllListenedEvents() {
        HashSet<EventName> result = new HashSet<EventName>();
        for (Map.Entry<String, Map<String, List<EventHandler>>> e : this.handlers.entrySet()) {
            String xmlns = e.getKey();
            for (String n : e.getValue().keySet()) {
                result.add(new EventName(n == NULL_NAME ? null : n, xmlns));
            }
        }
        return result;
    }

    protected Collection<EventHandler> getHandlersList(String name, String xmlns) {
        String eventName = name == null ? NULL_NAME : name;
        Map<String, List<EventHandler>> namesHandlers = this.handlers.get(xmlns);
        if (namesHandlers == null) {
            return Collections.emptyList();
        }
        List<EventHandler> handlersList = namesHandlers.get(eventName);
        if (handlersList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(handlersList);
    }

    @Override
    public void removeHandler(String name, String xmlns, EventHandler handler) {
        String eventName = name == null ? NULL_NAME : name;
        Map<String, List<EventHandler>> namesHandlers = this.handlers.get(xmlns);
        if (namesHandlers == null) {
            return;
        }
        List<EventHandler> handlersList = namesHandlers.get(eventName);
        if (handlersList == null) {
            return;
        }
        handlersList.remove(handler);
        if (handlersList.isEmpty()) {
            namesHandlers.remove(eventName);
        }
        if (namesHandlers.isEmpty()) {
            this.handlers.remove(xmlns);
        }
        this.fireOnRemoveHandler(name, xmlns, handler);
    }

    public void removeListener(LocalEventBusListener listener) {
        this.internalListeners.remove(listener);
    }

    public static interface LocalEventBusListener {
        public void onAddHandler(String var1, String var2, EventHandler var3);

        public void onFire(String var1, String var2, Element var3);

        public void onRemoveHandler(String var1, String var2, EventHandler var3);
    }

    public static class EventName {
        private final String name;
        private final String xmlns;

        EventName(String name, String xmlns) {
            this.name = name;
            this.xmlns = xmlns;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventName other = (EventName)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.xmlns == null ? other.xmlns != null : !this.xmlns.equals(other.xmlns));
        }

        public String getName() {
            return this.name;
        }

        public String getXmlns() {
            return this.xmlns;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.xmlns == null ? 0 : this.xmlns.hashCode());
            return result;
        }

        public String toString() {
            return NodeNameUtil.createNodeName(this.name, this.xmlns);
        }
    }
}

