/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigRepositoryIfc;
import tigase.conf.ConfigurationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.comp.RepositoryChangeListenerIfc;

public class ConfigurationCache
implements ConfigRepositoryIfc {
    public static final String CONFIG_DUMP_FILE_PROP_DEF = "etc/config-dump.properties";
    public static final String CONFIG_DUMP_FILE_PROP_KEY = "config-dump-file";
    private static final Logger log = Logger.getLogger(ConfigurationCache.class.getName());
    private Map<String, Set<ConfigItem>> config = new LinkedHashMap<String, Set<ConfigItem>>();
    private String configDumpFileName = "etc/config-dump.properties";
    private String hostname = null;
    private RepositoryChangeListenerIfc<ConfigItem> repoChangeList = null;

    @Override
    public void addRepoChangeListener(RepositoryChangeListenerIfc<ConfigItem> repoChangeListener) {
        this.repoChangeList = repoChangeListener;
    }

    @Override
    public void removeRepoChangeListener(RepositoryChangeListenerIfc<ConfigItem> repoChangeListener) {
        this.repoChangeList = null;
    }

    public void addItem(String compName, ConfigItem item) {
        Set<ConfigItem> confItems = this.config.get(compName);
        if (confItems == null) {
            confItems = new LinkedHashSet<ConfigItem>();
            this.config.put(compName, confItems);
        }
        boolean updated = confItems.remove(item);
        confItems.add(item);
        if (this.repoChangeList != null) {
            if (updated) {
                this.repoChangeList.itemUpdated(item);
            } else {
                this.repoChangeList.itemAdded(item);
            }
        }
    }

    @Override
    public void addItemNoStore(ConfigItem item) {
        this.addItem(item.getCompName(), item);
    }

    @Override
    public void addItem(ConfigItem item) throws TigaseDBException {
        this.addItemNoStore(item);
    }

    @Override
    public void addItem(String key, Object value) throws ConfigurationException {
        String keyName;
        String nodeName;
        String compName;
        int idx1 = key.indexOf("/");
        if (idx1 > 0) {
            compName = key.substring(0, idx1);
            int idx2 = key.lastIndexOf("/");
            nodeName = null;
            keyName = key.substring(idx2 + 1);
            if (idx1 != idx2) {
                nodeName = key.substring(idx1 + 1, idx2);
            }
        } else {
            throw new IllegalArgumentException("You have to provide a key with at least 'component_name/key_name': " + key);
        }
        ConfigItem item = this.getItemInstance();
        item.set(this.getDefHostname(), compName, nodeName, keyName, value);
        this.addItem(compName, item);
    }

    @Override
    public Collection<ConfigItem> allItems() throws TigaseDBException {
        ArrayList<ConfigItem> result = new ArrayList<ConfigItem>();
        for (Set<ConfigItem> items : this.config.values()) {
            result.addAll(items);
        }
        return result;
    }

    @Override
    public boolean contains(String key) {
        return this.getItem(key) != null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object get(String compName, String node, String key, Object def) {
        ConfigItem item = this.getItem(compName, node, key);
        if (item != null) {
            return item.getConfigVal();
        }
        return def;
    }

    @Override
    public String[] getCompNames() {
        return this.config.keySet().toArray(new String[this.config.size()]);
    }

    public String getDefHostname() {
        return this.hostname;
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        defs.put(CONFIG_DUMP_FILE_PROP_KEY, CONFIG_DUMP_FILE_PROP_DEF);
    }

    @Override
    public Map<String, Object> getInitProperties() {
        return null;
    }

    public ConfigItem getItem(String compName, String node, String key) {
        Set<ConfigItem> confItems = this.getItemsForComponent(compName);
        if (confItems != null) {
            for (ConfigItem item : confItems) {
                if (!item.isNodeKey(node, key)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public ConfigItem getItem(String key) {
        int idx1 = key.indexOf("/");
        if (idx1 > 0) {
            String compName = key.substring(0, idx1);
            int idx2 = key.lastIndexOf("/");
            String nodeName = null;
            String keyName = key.substring(idx2 + 1);
            if (idx1 != idx2) {
                nodeName = key.substring(idx1 + 1, idx2);
            }
            return this.getItem(compName, nodeName, keyName);
        }
        throw new IllegalArgumentException("You have to provide a key with at least 'component_name/key_name': " + key);
    }

    @Override
    public ConfigItem getItemInstance() {
        return new ConfigItem();
    }

    @Override
    public Set<ConfigItem> getItemsForComponent(String compName) {
        return this.config.get(compName);
    }

    @Override
    public String[] getKeys(String compName, String node) {
        LinkedHashSet<String> keysForNode = new LinkedHashSet<String>();
        Set<ConfigItem> confItems = this.config.get(compName);
        for (ConfigItem item : confItems) {
            if (!item.isNode(node)) continue;
            keysForNode.add(item.getKeyName());
        }
        if (keysForNode.size() > 0) {
            return keysForNode.toArray(new String[keysForNode.size()]);
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties(String compName) throws ConfigurationException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set<ConfigItem> confItems = this.getItemsForComponent(compName);
        if (confItems != null) {
            for (ConfigItem item : confItems) {
                String key = item.getConfigKey();
                Object value = item.getConfigVal();
                result.put(key, value);
            }
        }
        return result;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public Iterator<ConfigItem> iterator() {
        try {
            Collection<ConfigItem> items = this.allItems();
            return items != null ? items.iterator() : null;
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Problem accessing repository: ", ex);
            return null;
        }
    }

    @Override
    public void putProperties(String compName, Map<String, Object> props) throws ConfigurationException {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            ConfigItem item = new ConfigItem();
            item.setNodeKey(this.getDefHostname(), compName, entry.getKey(), entry.getValue());
            this.addItem(compName, item);
        }
    }

    @Override
    public void reload() throws TigaseDBException {
    }

    @Override
    public void remove(String compName, String node, String key) {
        ConfigItem item = this.getItem(compName, node, key);
        if (item != null) {
            this.removeItem(compName, item);
        }
    }

    public void removeItem(String compName, ConfigItem item) {
        Set<ConfigItem> confItems = this.config.get(compName);
        if (confItems != null) {
            confItems.remove(item);
        }
        if (this.repoChangeList != null) {
            this.repoChangeList.itemRemoved(item);
        }
    }

    @Override
    public void removeItem(String key) throws TigaseDBException {
        ConfigItem item = this.getItem(key);
        if (item != null) {
            this.removeItem(item.getCompName(), item);
        }
    }

    @Override
    public void set(String compName, String node, String key, Object value) {
        ConfigItem item = this.getItem(compName, node, key);
        if (item == null) {
            item = this.getItemInstance();
        }
        item.set(this.getDefHostname(), compName, node, key, value);
        this.addItem(compName, item);
    }

    @Override
    public void setDefHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.configDumpFileName = (String)properties.get(CONFIG_DUMP_FILE_PROP_KEY);
    }

    @Override
    public int size() {
        int result = 0;
        for (Set<ConfigItem> items : this.config.values()) {
            result += items.size();
        }
        return result;
    }

    @Override
    public void store() throws TigaseDBException {
        if (!this.isOff(this.configDumpFileName)) {
            log.log(Level.WARNING, "Dumping server configuration to: {0}", this.configDumpFileName);
            try {
                FileWriter fw = new FileWriter(this.configDumpFileName, false);
                for (Map.Entry<String, Set<ConfigItem>> entry : this.config.entrySet()) {
                    for (ConfigItem item : entry.getValue()) {
                        fw.write(item.toPropertyString());
                        fw.write("\n");
                    }
                }
                fw.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Cannot dump server configuration.", e);
            }
        } else {
            log.log(Level.WARNING, "Dumping server configuration is OFF: {0}", this.configDumpFileName);
        }
    }

    private boolean isOff(String str) {
        return str == null || str.trim().isEmpty() || str.equalsIgnoreCase("off") || str.equalsIgnoreCase("none") || str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no");
    }

    @Override
    public String validateItem(ConfigItem item) {
        return null;
    }

    @Override
    public void setAutoloadTimer(long delay) {
    }
}

