/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.EventHandler;
import tigase.server.ServiceChecker;
import tigase.server.XMPPServer;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;

public class ClientConnectionClustered
extends ClientConnectionManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(ClientConnectionClustered.class.getName());
    private SeeOtherHostIfc see_other_host_strategy = null;
    private List<BareJID> connectedNodes = new CopyOnWriteArrayList<BareJID>(){
        {
            this.add(ClientConnectionClustered.this.getDefHostName());
        }
    };
    private EventHandler clusterEventHandler = null;

    @Override
    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        List<JID> connectedNodes = this.getNodesConnectedWithLocal();
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(connectedNodes);
        }
    }

    @Override
    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        List<JID> connectedNodes = this.getNodesConnectedWithLocal();
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(connectedNodes);
        }
        final String hostname = jid.getDomain();
        this.doForAllServices(new ServiceChecker<XMPPIOService<Object>>(){

            @Override
            public void check(XMPPIOService<Object> service) {
                JID dataReceiver = service.getDataReceiver();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Checking service for dataReceiver: {0}", dataReceiver);
                }
                if (dataReceiver != null && dataReceiver.getDomain().equals(hostname)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Stopping service because corresponding cluster node stopped.");
                    }
                    service.stop();
                }
            }
        });
    }

    @Override
    public String getDiscoDescription() {
        return super.getDiscoDescription() + " clustered";
    }

    @Override
    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host clustered strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHostHashed";
        }
        this.see_other_host_strategy = super.getSeeOtherHostInstance(see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(this.getNodesConnectedWithLocal());
        }
        return this.see_other_host_strategy;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String delayPortListeningPorp = System.getProperty("client-port-delay-listening");
        if (delayPortListeningPorp != null) {
            props.put("port-delay-listening", Boolean.parseBoolean(delayPortListeningPorp));
        } else {
            props.put("port-delay-listening", true);
        }
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        ClusterConnectionManager clusterConnectionManager;
        Configurable component = (Configurable)XMPPServer.getConfigurator().getComponent("cl-comp");
        if (component != null && component instanceof ClusterConnectionManager && (clusterConnectionManager = (ClusterConnectionManager)component).isInitialClusterConnectedDone() && props.containsKey("port-delay-listening")) {
            props.put("port-delay-listening", false);
            log.log(Level.WARNING, "Skip delaying opening ports of component: {0} - clustering is already established", this.getName());
        }
        super.setProperties(props);
    }

    @Override
    public void start() {
        super.start();
        if (this.clusterEventHandler == null) {
            this.clusterEventHandler = new EventHandler(){

                @Override
                public void onEvent(String name, String xmlns, Element event) {
                    ClientConnectionClustered.this.connectWaitingTasks();
                    log.log(Level.WARNING, "Starting listening on ports of component: {0}", ClientConnectionClustered.this.getName());
                    EventBusFactory.getInstance().removeHandler("cluster-initiated", "cluster-initiated", this);
                }
            };
        }
        EventBusFactory.getInstance().addHandler("cluster-initiated", "cluster-initiated", this.clusterEventHandler);
    }

    @Override
    public void stop() {
        super.stop();
        EventBusFactory.getInstance().removeHandler("cluster-initiated", "cluster-initiated", this.clusterEventHandler);
        this.clusterEventHandler = null;
    }

    @Override
    public void initializationCompleted() {
        super.initializationCompleted();
        if (this.delayPortListening) {
            this.addTimerTask(new TimerTask(){

                @Override
                public void run() {
                    log.log(Level.FINE, "Cluster synchronization timed-out, starting pending connections for " + ClientConnectionClustered.this.getName());
                    ClientConnectionClustered.this.connectWaitingTasks();
                }
            }, this.connectionDelay * 30L);
        }
    }
}

