/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.jdbc.JDBCRepository;
import tigase.xmpp.BareJID;

public class JDBCRepositoryTest {
    UserRepository repo = null;
    boolean initialised = false;

    @Before
    public void setUp() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("data-repo-pool-size", "2");
        String repositoryURI = null;
        Assume.assumeNotNull((Object[])new Object[]{repositoryURI});
        this.repo = new JDBCRepository();
        try {
            this.repo.initRepository(repositoryURI, map);
            this.initialised = true;
        }
        catch (DBInitException ex) {
            Logger.getLogger(JDBCRepositoryTest.class.getName()).log(Level.SEVERE, "db initialisation failed", ex);
        }
        Assume.assumeTrue((boolean)this.initialised);
    }

    private void getData(BareJID user) {
        if (user == null) {
            user = BareJID.bareJIDInstanceNS((String)"user", (String)"domain");
        }
        System.out.println("retrieve: " + user + " / thread: " + Thread.currentThread().getName());
        try {
            this.repo.addUser(user);
        }
        catch (UserExistsException ex) {
            System.out.println("User exists, ignore: " + ex.getUserId());
        }
        catch (TigaseDBException ex) {
            Logger.getLogger(JDBCRepositoryTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Test
    public void testLongNode() throws InterruptedException, TigaseDBException {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user", (String)"domain");
        this.repo.setData(user, "node1/node2/node3", "key", "value");
        String node3val = this.repo.getData(user, "node1/node2/node3", "key");
        Assert.assertEquals((String)"String differ from expected!", (Object)"value", (Object)node3val);
        this.repo.removeSubnode(user, "node1");
        node3val = this.repo.getData(user, "node1/node2/node3", "key");
        Assert.assertNull((String)"Node not removed", (Object)node3val);
    }

    @Test
    public void testGetData() throws InterruptedException {
        System.out.println("repo: " + this.repo);
        if (this.repo != null) {
            LocalDateTime localNow = LocalDateTime.now();
            long initalDelay = 5L;
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
            int iter = 50;
            int threads = 10;
            for (int i = 0; i < 10; ++i) {
                scheduler.scheduleAtFixedRate(new RunnableImpl(50), initalDelay, 100L, TimeUnit.MILLISECONDS);
            }
            Thread.sleep(10000L);
        }
    }

    private class RunnableImpl
    implements Runnable {
        int count = 0;
        int max = 50;

        public RunnableImpl(int max) {
            this.max = max;
        }

        @Override
        public void run() {
            while (this.count < this.max) {
                ++this.count;
                BareJID user = BareJID.bareJIDInstanceNS((String)String.valueOf(new Date().getTime() / 10L), (String)"domain");
                JDBCRepositoryTest.this.getData(user);
            }
        }
    }
}

