/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.auth.mechanisms.SaslPLAIN;

public class SaslPLAINTest
extends TestCase {
    private SaslPLAIN sasl;

    @Before
    public void setUp() {
        HashMap props = new HashMap();
        CallbackHandler callbackHandler = new CallbackHandler(){
            private String username;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        this.username = ((NameCallback)callback).getDefaultName() + "@domain.com";
                        ((NameCallback)callback).setName(this.username);
                        continue;
                    }
                    if (callback instanceof VerifyPasswordCallback) {
                        ((VerifyPasswordCallback)callback).setVerified("juliet@domain.com:xsecret".equals(this.username + ":" + ((VerifyPasswordCallback)callback).getPassword()));
                        continue;
                    }
                    if (callback instanceof AuthorizeCallback) {
                        boolean a = ((AuthorizeCallback)callback).getAuthorizationID().equals(((AuthorizeCallback)callback).getAuthenticationID());
                        ((AuthorizeCallback)callback).setAuthorized(a);
                        if (!a) continue;
                        ((AuthorizeCallback)callback).setAuthorizedID(((AuthorizeCallback)callback).getAuthorizationID());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        this.sasl = new SaslPLAIN(props, callbackHandler);
    }

    @Test
    public void testEmptyPassword() {
        try {
            this.sasl.evaluateResponse("\u0000juliet\u0000".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"not-authorized", (String)e.getSaslErrorElementName());
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        catch (SaslException e) {
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testEmptyUsername() {
        try {
            this.sasl.evaluateResponse("\u0000\u0000qaz".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testEmptyUsernamePassword() {
        try {
            this.sasl.evaluateResponse("\u0000\u0000".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testInvalidAuthzId() {
        try {
            this.sasl.evaluateResponse("romeo\u0000juliet\u0000xsecret".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"invalid-authzid", (String)e.getSaslErrorElementName());
            SaslPLAINTest.assertEquals((String)"PLAIN: juliet is not authorized to act as romeo", (String)e.getMessage());
        }
        catch (SaslException e) {
            SaslPLAINTest.assertEquals((String)"PLAIN: juliet is not authorized to act as romeo", (String)e.getMessage());
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testInvalidPassword() {
        try {
            this.sasl.evaluateResponse("\u0000juliet\u0000ysecret".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"not-authorized", (String)e.getSaslErrorElementName());
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        catch (SaslException e) {
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testInvalidUsername() {
        try {
            this.sasl.evaluateResponse("\u0000romeo\u0000xsecret".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"not-authorized", (String)e.getSaslErrorElementName());
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        catch (SaslException e) {
            SaslPLAINTest.assertEquals((String)"Password not verified", (String)e.getMessage());
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testmalformedRequest1() {
        try {
            this.sasl.evaluateResponse("".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testmalformedRequest2() {
        try {
            this.sasl.evaluateResponse(null);
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testmalformedRequest3() {
        try {
            this.sasl.evaluateResponse("\u0000juliet\u0000xsecret\u0000".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testmalformedRequest4() {
        try {
            this.sasl.evaluateResponse("xyz".getBytes());
            SaslPLAINTest.fail((String)"Exception must be throwed");
        }
        catch (XmppSaslException e) {
            SaslPLAINTest.assertEquals((String)"malformed-request", (String)e.getSaslErrorElementName());
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslPLAINTest.assertFalse((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertNull((String)"Authorization ID must be null", (Object)this.sasl.getAuthorizationID());
    }

    @Test
    public void testSuccess() {
        try {
            this.sasl.evaluateResponse("\u0000juliet\u0000xsecret".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslPLAINTest.fail((String)e.getMessage());
        }
        SaslPLAINTest.assertTrue((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertEquals((String)"juliet@domain.com", (String)this.sasl.getAuthorizationID());
    }

    @Test
    public void testSuccessWithAuthzId() {
        try {
            this.sasl.evaluateResponse("juliet@domain.com\u0000juliet\u0000xsecret".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslPLAINTest.fail((String)e.getMessage());
        }
        SaslPLAINTest.assertTrue((boolean)this.sasl.isComplete());
        SaslPLAINTest.assertEquals((String)"juliet@domain.com", (String)this.sasl.getAuthorizationID());
    }

    @Test
    public void testSuccessWithAuthzId2() {
        HashMap props = new HashMap();
        CallbackHandler callbackHandler = new CallbackHandler(){
            private String username;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        this.username = ((NameCallback)callback).getDefaultName();
                        continue;
                    }
                    if (callback instanceof VerifyPasswordCallback) {
                        ((VerifyPasswordCallback)callback).setVerified("secondwitch:shakespeare".equals(this.username + ":" + ((VerifyPasswordCallback)callback).getPassword()));
                        continue;
                    }
                    if (callback instanceof AuthorizeCallback) {
                        boolean a = ((AuthorizeCallback)callback).getAuthorizationID().equals("romeo@example.net");
                        a = a && this.username.equals("secondwitch");
                        ((AuthorizeCallback)callback).setAuthorized(a);
                        if (!a) continue;
                        ((AuthorizeCallback)callback).setAuthorizedID(((AuthorizeCallback)callback).getAuthorizationID());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        SaslPLAIN sasl = new SaslPLAIN(props, callbackHandler);
        try {
            sasl.evaluateResponse("romeo@example.net\u0000secondwitch\u0000shakespeare".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslPLAINTest.fail((String)e.getMessage());
        }
        SaslPLAINTest.assertTrue((boolean)sasl.isComplete());
        SaslPLAINTest.assertEquals((String)"romeo@example.net", (String)sasl.getAuthorizationID());
    }
}

