/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.annotation.StreamFeature;
import tigase.xmpp.impl.annotation.StreamFeatures;

@Id(value="urn:ietf:params:xml:ns:xmpp-session")
@Handle(path={"iq", "session"}, xmlns="urn:ietf:params:xml:ns:xmpp-session")
@StreamFeatures(value={@StreamFeature(elem="session", xmlns="urn:ietf:params:xml:ns:xmpp-session")})
@DiscoFeatures(value={"urn:ietf:params:xml:ns:xmpp-session"})
public class SessionBind
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    private static final String SESSION_KEY = "Session-Set";
    protected static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-session";
    private static final Logger log = Logger.getLogger(SessionBind.class.getName());

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            return;
        }
        StanzaType type = packet.getType();
        switch (type) {
            case set: {
                session.putSessionData(SESSION_KEY, "true");
                results.offer(packet.okResult((String)null, 0));
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Session type is incorrect", false));
            }
        }
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && session.getSessionData(SESSION_KEY) == null && session.isAuthorized()) {
            return super.supStreamFeatures(session);
        }
        return null;
    }
}

