/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqPrivacy;

public class Privacy {
    public static final String ACTION = "action";
    public static final String ACTIVE = "active-list";
    public static final String DEFAULT = "default-list";
    public static final String ITEM = "item";
    public static final String LIST = "list";
    public static final String NAME = "name";
    public static final String ORDER = "order";
    public static final String PRIVACY = "privacy";
    public static final String PRIVACY_LIST = "privacy-list";
    public static final String STANZAS = "stanzas";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String PRIVACY_LIST_LOADED = "privacy-lists-loaded";
    private static Logger log = Logger.getLogger(Privacy.class.getName());

    public static void addList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Saving privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.setData(lNode, PRIVACY_LIST, list.toString());
    }

    public static void removeList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.removeData(lNode, PRIVACY_LIST);
        session.removeDataGroup(lNode);
    }

    public static Element getActiveList(XMPPResourceConnection session) throws NotAuthorizedException {
        return (Element)session.getSessionData(ACTIVE);
    }

    public static String getActiveListName(XMPPResourceConnection session) throws NotAuthorizedException {
        Element list = Privacy.getActiveList(session);
        if (list != null) {
            return list.getAttributeStaticStr(NAME);
        }
        return null;
    }

    public static Element getDefaultList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Element sessionDefaultList = (Element)session.getCommonSessionData(DEFAULT);
        if (session.getCommonSessionData(PRIVACY_LIST_LOADED) == null) {
            String defaultListName;
            if (sessionDefaultList == null && (defaultListName = Privacy.getDefaultListName(session)) != null && null != (sessionDefaultList = Privacy.getList(session, defaultListName))) {
                session.putCommonSessionData(DEFAULT, sessionDefaultList);
            }
            session.putCommonSessionData(PRIVACY_LIST_LOADED, PRIVACY_LIST_LOADED);
        }
        return sessionDefaultList;
    }

    public static String getDefaultListName(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getData(PRIVACY, DEFAULT, null);
    }

    public static Element getList(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode;
        String list_str;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loading privacy list: {0}", list);
        }
        if ((list_str = session.getData(lNode = Privacy.listNode(list), PRIVACY_LIST, null)) != null && !list_str.isEmpty()) {
            SimpleParser parser = SingletonFactory.getParserInstance();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse(domHandler, list_str.toCharArray(), 0, list_str.length());
            Queue<Element> elems = domHandler.getParsedElements();
            Element result = elems.poll();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Loaded privacy list: {0}", result);
            }
            return result;
        }
        return Privacy.getListOld(session, list);
    }

    public static Element getListOld(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode = Privacy.listNode(list);
        String[] items = session.getDataGroups(lNode);
        if (items != null && list != null) {
            Element eList = new Element(LIST, new String[]{NAME}, new String[]{list});
            for (String item : items) {
                String iNode = lNode + "/" + item;
                String type = session.getData(iNode, TYPE, null);
                String value = session.getData(iNode, VALUE, null);
                String action = session.getData(iNode, ACTION, null);
                String[] stanzas = session.getDataList(iNode, STANZAS);
                if (item == null || action == null) continue;
                Element eItem = new Element(ITEM, new String[]{ORDER, ACTION}, new String[]{item, action});
                if (type != null) {
                    eItem.addAttribute(TYPE, type);
                }
                if (value != null) {
                    eItem.addAttribute(VALUE, value);
                }
                if (stanzas != null) {
                    for (String stanza : stanzas) {
                        eItem.addChild(new Element(stanza));
                    }
                }
                eList.addChild(eItem);
            }
            return eList;
        }
        return null;
    }

    public static String[] getLists(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getDataGroups(PRIVACY);
    }

    public static String listNode(String list) {
        return "privacy/" + list;
    }

    public static void setActiveList(XMPPResourceConnection session, String lName) throws NotAuthorizedException, TigaseDBException {
        if (lName == null) {
            session.removeSessionData(ACTIVE);
        } else {
            Element list = Privacy.getList(session, lName);
            if (list != null) {
                session.putSessionData(ACTIVE, list);
            } else {
                log.log(Level.INFO, "Setting active list to null, do something better than that, perhaps notify user.");
            }
        }
    }

    public static void setDefaultList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (list != null && list.getAttributeStaticStr(NAME) != null) {
            session.setData(PRIVACY, DEFAULT, list.getAttributeStaticStr(NAME));
            session.putCommonSessionData(DEFAULT, list);
        } else {
            session.removeData(PRIVACY, DEFAULT);
            session.removeCommonSessionData(DEFAULT);
        }
    }

    public static List<String> getBlocked(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Element list = Privacy.getDefaultList(session);
        List<String> ulist = null;
        if (list != null) {
            ulist = list.mapChildren(item -> Privacy.isBlockItem(item), item -> item.getAttributeStaticStr(VALUE));
        }
        return ulist;
    }

    public static boolean block(XMPPResourceConnection session, String jid) throws NotAuthorizedException, TigaseDBException {
        List<Element> items;
        Element list;
        String name = Privacy.getDefaultListName(session);
        if (name == null) {
            name = "default";
        }
        if ((list = Privacy.getList(session, name)) != null && list.findChild(item -> jid.equals(item.getAttributeStaticStr(VALUE)) && Privacy.isBlockItem(item)) != null) {
            return false;
        }
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        list_new.addChild(new Element(ITEM, new String[]{TYPE, ACTION, VALUE, ORDER}, new String[]{"jid", "deny", jid, "0"}));
        if (list != null && (items = list.getChildren()) != null) {
            Collections.sort(items, JabberIqPrivacy.compar);
            for (int i = 0; i < items.size(); ++i) {
                items.get(i).setAttribute(ORDER, "" + (i + 1));
            }
            list_new.addChildren(items);
        }
        Privacy.updateList(session, name, list_new);
        return true;
    }

    public static boolean unblock(XMPPResourceConnection session, String jid) throws NotAuthorizedException, TigaseDBException {
        String name = Privacy.getDefaultListName(session);
        Element list = Privacy.getList(session, name);
        if (list == null) {
            return false;
        }
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        List<Element> items = list.findChildren(item -> !jid.equals(item.getAttributeStaticStr(VALUE)) || !Privacy.isBlockItem(item));
        if (items != null) {
            Collections.sort(items, JabberIqPrivacy.compar);
            for (int i = 0; i < items.size(); ++i) {
                items.get(i).setAttribute(ORDER, "" + (i + 1));
            }
            list_new.addChildren(items);
        }
        Privacy.updateList(session, name, list_new);
        return false;
    }

    public static List<String> unblockAll(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String name = Privacy.getDefaultListName(session);
        Element list = Privacy.getList(session, name);
        if (list == null) {
            return null;
        }
        List<String> ulist = list.mapChildren(item -> Privacy.isBlockItem(item), item -> item.getAttributeStaticStr(VALUE));
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        List<Element> items = list.findChildren(item -> !Privacy.isBlockItem(item));
        if (items != null) {
            Collections.sort(items, JabberIqPrivacy.compar);
            for (int i = 0; i < items.size(); ++i) {
                items.get(i).setAttribute(ORDER, "" + (i + 1));
            }
            list_new.addChildren(items);
        }
        Privacy.updateList(session, name, list_new);
        return ulist;
    }

    private static void updateList(XMPPResourceConnection session, String name, Element list_new) throws NotAuthorizedException, TigaseDBException {
        Privacy.addList(session, list_new);
        Privacy.setDefaultList(session, list_new);
        if (Privacy.getDefaultList(session) == null) {
            Privacy.setActiveList(session, name);
        } else if (name.equals(Privacy.getActiveListName(session))) {
            session.putCommonSessionData(ACTIVE, list_new);
            session.putSessionData(ACTIVE, list_new);
        }
    }

    private static boolean isBlockItem(Element item) {
        return "jid".equals(item.getAttributeStaticStr(TYPE)) && "deny".equals(item.getAttributeStaticStr(ACTION)) && item.getChildren() == null;
    }
}

