/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Collection;
import java.util.logging.Level;
import tigase.stats.StatisticType;

public class StatRecord<E extends Number> {
    private StatisticType type = StatisticType.OTHER;
    private Level level = Level.INFO;
    private long longValue = -1L;
    private int intValue = -1;
    private float floatValue = -1.0f;
    private Collection<E> collection = null;
    private boolean nonZero = false;
    private String description = null;
    private String value = null;
    private String component = null;

    public StatRecord(String comp, String description, String value, Level level) {
        this.description = description.intern();
        if (value != null) {
            this.value = value.intern();
            this.nonZero = !value.isEmpty();
        }
        this.level = level;
        this.component = comp.intern();
    }

    public StatRecord(String comp, String description, int value, Level level) {
        this(comp, description, "" + value, level);
        this.intValue = value;
        this.nonZero = value > 0;
    }

    public StatRecord(String comp, StatisticType type, long value, Level level) {
        this(comp, type.getDescription(), "" + value, level);
        this.type = type;
        this.longValue = value;
        this.nonZero = value > 0L;
    }

    public StatRecord(String comp, StatisticType type, int value, Level level) {
        this(comp, type.getDescription(), "" + value, level);
        this.type = type;
        this.intValue = value;
        this.nonZero = value > 0;
    }

    public StatRecord(String comp, String description, long value, Level level) {
        this(comp, description, "" + value, level);
        this.longValue = value;
        this.nonZero = value > 0L;
    }

    StatRecord(String comp, String description, float value, Level level) {
        this(comp, description, "" + value, level);
        this.floatValue = value;
        this.nonZero = value > 0.0f;
    }

    StatRecord(String comp, String description, Collection<E> value, Level level) {
        this(comp, description, value != null ? value.toString() : "", level);
        this.collection = value;
        this.nonZero = super.isCollectionNonZero(this.collection);
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public StatisticType getType() {
        return this.type;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getComponent() {
        return this.component;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public Collection<E> getCollection() {
        return this.collection;
    }

    boolean isNonZero() {
        return this.nonZero;
    }

    private boolean isCollectionNonZero(Collection<E> collection) {
        for (Number e : collection) {
            if (e.byteValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.component).append('/').append(this.description);
        sb.append('[');
        if (this.longValue > -1L) {
            sb.append('L');
        } else if (this.intValue > -1) {
            sb.append('I');
        } else if (this.floatValue > -1.0f) {
            sb.append('F');
        } else if (this.collection != null) {
            sb.append('C');
        } else {
            sb.append('S');
        }
        sb.append(']');
        sb.append(" = ").append(this.value);
        return sb.toString();
    }

    float getFloatValue() {
        return this.floatValue;
    }
}

