/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.logging.Level;
import tigase.stats.CounterValue;
import tigase.stats.StatisticsList;

public class Counter
extends CounterValue {
    private long last_hour_counter = 0L;
    private long last_minute_counter = 0L;
    private long last_second_counter = 0L;
    private long per_hour = 0L;
    private long per_minute = 0L;
    private long per_second = 0L;

    public Counter(String name, Level level) {
        super(name, level);
    }

    public synchronized void everyHour() {
        this.per_hour = this.counter - this.last_hour_counter;
        this.last_hour_counter = this.counter;
    }

    public synchronized void everyMinute() {
        this.per_minute = this.counter - this.last_minute_counter;
        this.last_minute_counter = this.counter;
    }

    public synchronized void everySecond() {
        this.per_second = this.counter - this.last_second_counter;
        this.last_second_counter = this.counter;
    }

    public long getPerHour() {
        return this.per_hour;
    }

    public long getPerMinute() {
        return this.per_minute;
    }

    public long getPerSecond() {
        return this.per_second;
    }

    public void getStatistics(String compName, StatisticsList list) {
        if (list.checkLevel(this.level)) {
            list.add(compName, this.name + " last hour", this.per_hour, this.level);
            list.add(compName, this.name + " last minute", this.per_minute, this.level);
            list.add(compName, this.name + " last second", this.per_second, this.level);
        }
    }
}

