/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.cert.CertificateUtil;
import tigase.conf.ConfigurationException;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SConnectionSelector;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SProcessor;
import tigase.server.xmppserver.proc.Dialback;
import tigase.server.xmppserver.proc.PacketChecker;
import tigase.server.xmppserver.proc.StartTLS;
import tigase.server.xmppserver.proc.StartZlib;
import tigase.server.xmppserver.proc.StreamError;
import tigase.server.xmppserver.proc.StreamFeatures;
import tigase.server.xmppserver.proc.StreamOpen;
import tigase.stats.StatisticsList;
import tigase.util.TimerTask;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class S2SConnectionManager
extends ConnectionManager<S2SIOService>
implements S2SConnectionHandlerIfc<S2SIOService> {
    public static final String CID_CONNECTIONS_BIND = "cidConnections";
    public static final String CID_CONNECTIONS_TASKS_THREADS_KEY = "cid-connections-tasks-threads";
    public static final String MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY = "max-inactivity-time";
    public static final String MAX_INCOMING_CONNECTIONS_PROP_KEY = "max-in-conns";
    public static final int MAX_INCOMING_CONNECTIONS_PROP_VAL = 4;
    public static final String MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY = "max-out-per-ip-conns";
    public static final int MAX_OUT_PER_IP_CONNECTIONS_PROP_VAL = 1;
    public static final String MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY = "max-out-total-conns";
    public static final int MAX_OUT_TOTAL_CONNECTIONS_PROP_VAL = 1;
    public static final String MAX_PACKET_WAITING_TIME_PROP_KEY = "max-packet-waiting-time";
    public static final String S2S_CONNECTION_SELECTOR_PROP_KEY = "s2s-conn-selector";
    public static final String S2S_CONNECTION_SELECTOR_PROP_VAL = "tigase.server.xmppserver.S2SRandomSelector";
    public static final String S2S_DOMAIN_MAPPING_PROP_KEY = "s2s-domain-mapping";
    public static final String S2S_DOMAIN_MAPPING_PROP_VAL = "";
    public static final String S2S_HT_TRAFFIC_THROTTLING_PROP_VAL = "xmpp:15k:0:disc,bin:120m:0:disc";
    protected static final String DB_RESULT_EL_NAME = "db:result";
    protected static final String DB_VERIFY_EL_NAME = "db:verify";
    private static final Logger log = Logger.getLogger(S2SConnectionManager.class.getName());
    private static final String PROCESSORS_CONF_PROP_KEY = "processors-conf";
    private static final String XMLNS_CLIENT_VAL = "jabber:client";
    private static final String XMLNS_SERVER_VAL = "jabber:server";
    public static final long MAX_PACKET_WAITING_TIME_PROP_VAL = 420000L;
    public static final long MAX_CONNECTION_INACTIVITY_TIME_PROP_VAL = 900000L;
    public static final int CID_CONNECTIONS_TASKS_THREADS_VAL = Runtime.getRuntime().availableProcessors();
    private S2SConnectionSelector connSelector = null;
    private long maxPacketWaitingTime = 420000L;
    private int maxOUTTotalConnections = 1;
    private int maxOUTPerIPConnections = 1;
    private int maxINConnections = 4;
    private long maxInactivityTime = 900000L;
    protected Map<CID, CIDConnections> cidConnections = new ConcurrentHashMap<CID, CIDConnections>(10000);
    private DomainServerNameMapper domainServerNameMapper = new DomainServerNameMapper();
    private Map<String, S2SProcessor> processorsMap = new LinkedHashMap<String, S2SProcessor>(10);
    private List<S2SProcessor> processors = Collections.emptyList();
    private Map<String, S2SProcessor> filters = new LinkedHashMap<String, S2SProcessor>(10);

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    public void addTimerTask(TimerTask task, long delay, TimeUnit unit) {
        super.addTimerTask(task, delay, unit);
    }

    @Override
    @Deprecated
    public void addTimerTask(java.util.TimerTask task, long delay, TimeUnit unit) {
        super.addTimerTask(task, delay, unit);
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return true;
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().getDomain().hashCode();
        }
        return 1;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(CID_CONNECTIONS_BIND, (Object)this.cidConnections);
    }

    @Override
    public void initNewConnection(Map<String, Object> port_props) {
        this.addWaitingTask(port_props);
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getDomain().trim().isEmpty()) {
            log.log(Level.WARNING, "Missing ''to'' attribute, ignoring packet...{0}\n This most likely happens due to missconfiguration of components domain names.", packet);
            return;
        }
        if (packet.getStanzaFrom() == null || packet.getStanzaFrom().getDomain().trim().isEmpty()) {
            log.log(Level.WARNING, "Missing ''from'' attribute, ignoring packet...{0}", packet);
            return;
        }
        String to_hostname = packet.getStanzaTo().getDomain();
        try {
            String from_hostname = packet.getStanzaFrom().getDomain();
            CID cid = new CID(from_hostname, to_hostname);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Connection ID is: {0}", cid);
            }
            try {
                CIDConnections cid_conns = this.getCIDConnections(cid, true);
                Packet server_packet = packet.copyElementOnly();
                server_packet.getElement().removeAttribute("xmlns");
                cid_conns.sendPacket(server_packet);
            }
            catch (NotLocalhostException e) {
                this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "S2S - Incorrect source address - none of any local virtual hosts or components.", true));
            }
            catch (LocalhostException e) {
                this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "S2S - Incorrect destinationaddress - one of local virtual hosts or components.", true));
            }
        }
        catch (PacketErrorTypeException e) {
            log.log(Level.WARNING, "Packet processing exception: {0}", e);
        }
    }

    @Override
    public Queue<Packet> processSocketData(S2SIOService serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
        while ((p = packets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0}", p);
            }
            if (p.getXMLNS() == null) {
                p.setXMLNS(XMLNS_SERVER_VAL);
            }
            boolean processed = false;
            for (S2SProcessor proc : this.processors) {
                processed |= proc.process(p, serv, results);
                this.writePacketsToSocket(serv, results);
            }
            if (!processed) {
                for (S2SProcessor filter : this.filters.values()) {
                    processed |= filter.process(p, serv, results);
                    this.writePacketsToSocket(serv, results);
                }
            }
            if (processed) continue;
            if (p.getXMLNS() == XMLNS_SERVER_VAL || p.getXMLNS() == null) {
                p.setXMLNS(XMLNS_CLIENT_VAL);
            }
            try {
                if (this.isLocalDomainOrComponent(p.getStanzaTo().getDomain())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Adding packet out: {1}", new Object[]{serv, p});
                    }
                    p.setPermissions(Permissions.REMOTE);
                    this.addOutPacket(p);
                    continue;
                }
                try {
                    serv.addPacketToSend(Authorization.NOT_ACCEPTABLE.getResponseMessage(p, "Not a local virtual domain or component", true));
                }
                catch (PacketErrorTypeException packetErrorTypeException) {
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Unexpected exception for packet: " + p, e);
            }
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
        this.addPacket(packet);
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
        CID cid = (CID)port_props.get("cid");
        if (cid == null) {
            log.log(Level.WARNING, "Protocol error cid not set for outgoing connection: {0}", port_props);
            return;
        }
        CIDConnections cid_conns = this.getCIDConnections(cid);
        if (cid_conns == null) {
            log.log(Level.WARNING, "Protocol error cid_conns not found for outgoing connection: {0}", port_props);
            return;
        }
        cid_conns.reconnectionFailed(port_props);
    }

    @Override
    public int schedulerThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public boolean sendVerifyResult(String elem_name, CID connCid, CID keyCid, Boolean valid, String key_sessionId, String serv_sessionId, String cdata, boolean handshakingOnly) {
        return this.sendVerifyResult(elem_name, connCid, keyCid, valid, key_sessionId, serv_sessionId, cdata, handshakingOnly, null);
    }

    @Override
    public boolean sendVerifyResult(String elem_name, CID connCid, CID keyCid, Boolean valid, String key_sessionId, String serv_sessionId, String cdata, boolean handshakingOnly, Element errorElem) {
        CIDConnections cid_conns = this.getCIDConnections(connCid);
        if (cid_conns != null) {
            StanzaType type = null;
            if (valid != null) {
                type = valid != false ? StanzaType.valid : StanzaType.invalid;
            }
            if (errorElem != null) {
                type = StanzaType.error;
            }
            Packet verify_valid = this.getValidResponse(elem_name, keyCid, key_sessionId, type, cdata);
            if (errorElem != null) {
                verify_valid.getElement().addChild(errorElem);
            }
            if (handshakingOnly) {
                cid_conns.sendHandshakingOnly(verify_valid);
                return true;
            }
            return cid_conns.sendControlPacket(serv_sessionId, verify_valid);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can't find CID connections for cid: {0}, can't send verify response.", keyCid);
        }
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
        super.serviceStarted(serv);
        log.log(Level.FINEST, "s2s connection opened: {0}", serv);
        for (S2SProcessor proc : this.processors) {
            proc.serviceStarted(serv);
        }
    }

    @Override
    public boolean serviceStopped(S2SIOService serv) {
        boolean result = super.serviceStopped(serv);
        if (result) {
            for (S2SProcessor proc : this.processors) {
                proc.serviceStopped(serv);
            }
        }
        return result;
    }

    @Override
    public void tlsHandshakeCompleted(S2SIOService serv) {
        for (S2SProcessor proc : this.processors) {
            proc.serviceStarted(serv);
        }
    }

    @Override
    public void writeRawData(S2SIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(S2SIOService serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Stream closed.", new Object[]{serv});
        }
        for (S2SProcessor proc : this.processors) {
            proc.streamClosed(serv);
        }
    }

    @Override
    public String xmppStreamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Stream opened: {1}", new Object[]{serv, attribs});
        }
        StringBuilder sb = new StringBuilder(256);
        for (S2SProcessor proc : this.processors) {
            String res = proc.streamOpened(serv, attribs);
            if (res == null) continue;
            sb.append(res);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Sending stream open: {1}", new Object[]{serv, sb});
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Override
    public CIDConnections getCIDConnections(CID cid, boolean createNew) throws NotLocalhostException, LocalhostException {
        CIDConnections result = this.getCIDConnections(cid);
        if (result == null && createNew && cid != null) {
            result = this.createNewCIDConnections(cid);
        }
        return result;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(MAX_PACKET_WAITING_TIME_PROP_KEY, 420L);
        props.put(MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY, 900L);
        props.put(MAX_INCOMING_CONNECTIONS_PROP_KEY, 4);
        props.put(MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY, 1);
        props.put(MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY, 1);
        props.put(S2S_CONNECTION_SELECTOR_PROP_KEY, S2S_CONNECTION_SELECTOR_PROP_VAL);
        props.put(CID_CONNECTIONS_TASKS_THREADS_KEY, CID_CONNECTIONS_TASKS_THREADS_VAL);
        props.put(S2S_DOMAIN_MAPPING_PROP_KEY, S2S_DOMAIN_MAPPING_PROP_VAL);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "s2s";
    }

    @Override
    public String getDiscoDescription() {
        return "S2S connection manager";
    }

    @Override
    public String getSecretForDomain(String domain) throws NotLocalhostException {
        VHostItem item = this.vHostManager.getVHostItem(domain);
        if (item == null && this.isLocalDomainOrComponent(domain)) {
            int idx = domain.indexOf(46);
            if (idx > 0) {
                String basedomain = domain.substring(idx + 1);
                item = this.vHostManager.getVHostItem(basedomain);
            }
            if (item == null) {
                item = this.vHostManager.getVHostItem(this.vHostManager.getDefVHostItem().toString());
            }
        }
        if (item == null) {
            throw new NotLocalhostException("This is not a valid localhost: " + domain);
        }
        return item.getS2sSecret();
    }

    @Override
    public String getServerNameForDomain(String domain) {
        return this.domainServerNameMapper.getServerNameForDomain(domain);
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "CIDs number", this.cidConnections.size(), Level.INFO);
        if (list.checkLevel(Level.FINEST)) {
            long total_outgoing = 0L;
            long total_outgoing_tls = 0L;
            long total_outgoing_handshaking = 0L;
            long total_incoming = 0L;
            long total_incoming_tls = 0L;
            long total_dbKeys = 0L;
            long total_waiting = 0L;
            long total_waiting_control = 0L;
            for (Map.Entry<CID, CIDConnections> cid_conn : this.cidConnections.entrySet()) {
                int outgoing = cid_conn.getValue().getOutgoingCount();
                int outgoing_tls = cid_conn.getValue().getOutgoingTLSCount();
                int outgoing_handshaking = cid_conn.getValue().getOutgoingHandshakingCount();
                int incoming = cid_conn.getValue().getIncomingCount();
                int incoming_tls = cid_conn.getValue().getIncomingTLSCount();
                int dbKeys = cid_conn.getValue().getDBKeysCount();
                int waiting = cid_conn.getValue().getWaitingCount();
                int waiting_control = cid_conn.getValue().getWaitingControlCount();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "CID: {0}, OUT: {1}, OUT_HAND: {2}, IN: {3}, dbKeys: {4}, waiting: {5}, waiting_control: {6}", new Object[]{cid_conn.getKey(), outgoing, outgoing_handshaking, incoming, dbKeys, waiting, waiting_control});
                }
                total_outgoing += (long)outgoing;
                total_outgoing_tls += (long)outgoing_tls;
                total_outgoing_handshaking += (long)outgoing_handshaking;
                total_incoming += (long)incoming;
                total_incoming_tls += (long)incoming_tls;
                total_dbKeys += (long)dbKeys;
                total_waiting += (long)waiting;
                total_waiting_control += (long)waiting_control;
            }
            list.add(this.getName(), "Total outgoing", total_outgoing, Level.FINEST);
            list.add(this.getName(), "Total outgoing TLS", total_outgoing_tls, Level.FINEST);
            list.add(this.getName(), "Total outgoing handshaking", total_outgoing_handshaking, Level.FINEST);
            list.add(this.getName(), "Total incoming", total_incoming, Level.FINEST);
            list.add(this.getName(), "Total incoming TLS", total_incoming_tls, Level.FINEST);
            list.add(this.getName(), "Total DB keys", total_dbKeys, Level.FINEST);
            list.add(this.getName(), "Total waiting", total_waiting, Level.FINEST);
            list.add(this.getName(), "Total control waiting", total_waiting_control, Level.FINEST);
        }
    }

    @Override
    public List<Element> getStreamFeatures(S2SIOService serv) {
        ArrayList<Element> results = new ArrayList<Element>(10);
        for (S2SProcessor proc : this.processors) {
            proc.streamFeatures(serv, results);
        }
        return results;
    }

    @Override
    public boolean isTlsRequired(String domain) {
        VHostItem item = this.vHostManager.getVHostItemDomainOrComponent(domain);
        return item != null && item.isTlsRequired();
    }

    @Override
    public boolean isTlsWantClientAuthEnabled() {
        return true;
    }

    @Override
    public boolean isTlsNeedClientAuthEnabled() {
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.containsKey(CID_CONNECTIONS_TASKS_THREADS_KEY)) {
            CIDConnections.setOutgoingOpenThreadsSize((Integer)props.get(CID_CONNECTIONS_TASKS_THREADS_KEY));
        }
        if (props.size() == 1) {
            return;
        }
        this.processorsMap.clear();
        this.processorsMap.put(Dialback.class.getSimpleName(), new Dialback());
        this.processorsMap.put(StartTLS.class.getSimpleName(), new StartTLS());
        this.processorsMap.put(StartZlib.class.getSimpleName(), new StartZlib());
        this.processorsMap.put(StreamError.class.getSimpleName(), new StreamError());
        this.processorsMap.put(StreamFeatures.class.getSimpleName(), new StreamFeatures());
        this.processorsMap.put(StreamOpen.class.getSimpleName(), new StreamOpen());
        for (S2SProcessor s2SProcessor : this.processorsMap.values()) {
            ConcurrentHashMap<String, Object> proc_props = new ConcurrentHashMap<String, Object>(4);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                Object[] ids;
                String[] nodes;
                if (!entry.getKey().startsWith(PROCESSORS_CONF_PROP_KEY) || (nodes = entry.getKey().split("/")).length <= 2 || Arrays.binarySearch(ids = nodes[1].split(","), s2SProcessor.getClass().getSimpleName()) < 0) continue;
                proc_props.put(nodes[2], entry.getValue());
            }
            s2SProcessor.init(this, proc_props);
        }
        ArrayList<S2SProcessor> tmp_processors = new ArrayList<S2SProcessor>(this.processorsMap.values());
        Collections.sort(tmp_processors);
        this.processors = Collections.unmodifiableList(tmp_processors);
        this.filters.clear();
        this.filters.put(PacketChecker.class.getSimpleName(), new PacketChecker());
        for (S2SProcessor filter : this.filters.values()) {
            ConcurrentHashMap<String, Object> proc_props = new ConcurrentHashMap<String, Object>(4);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                Object[] ids;
                String[] nodes;
                if (!entry.getKey().startsWith(PROCESSORS_CONF_PROP_KEY) || (nodes = entry.getKey().split("/")).length <= 2 || Arrays.binarySearch(ids = nodes[1].split(","), filter.getClass().getSimpleName()) < 0) continue;
                proc_props.put(nodes[2], entry.getValue());
            }
            filter.init(this, proc_props);
        }
        this.maxPacketWaitingTime = (Long)props.get(MAX_PACKET_WAITING_TIME_PROP_KEY) * 1000L;
        this.maxInactivityTime = (Long)props.get(MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY) * 1000L;
        this.maxOUTTotalConnections = (Integer)props.get(MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY);
        this.maxOUTPerIPConnections = (Integer)props.get(MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY);
        this.maxINConnections = (Integer)props.get(MAX_INCOMING_CONNECTIONS_PROP_KEY);
        String string = (String)props.get(S2S_CONNECTION_SELECTOR_PROP_KEY);
        try {
            this.connSelector = (S2SConnectionSelector)Class.forName(string).newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Incorrect s2s connection selector class provided: {0}", string);
            log.log(Level.SEVERE, "Selector initialization exception: ", e);
        }
        String tmp = (String)props.get(S2S_DOMAIN_MAPPING_PROP_KEY);
        DomainServerNameMapper tmp_domainServerNameMapper = new DomainServerNameMapper();
        if (tmp != null) {
            for (String part : tmp.split(",")) {
                String[] kv = part.split("=");
                if (kv.length < 2) continue;
                tmp_domainServerNameMapper.addEntry(kv[0], kv[1]);
            }
        }
        this.domainServerNameMapper = tmp_domainServerNameMapper;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5269};
    }

    @Override
    protected String getDefTrafficThrottling() {
        String result = "xmpp:2500:0:disc,bin:20m:0:disc";
        if (this.isHighThroughput()) {
            result = S2S_HT_TRAFFIC_THROTTLING_PROP_VAL;
        }
        return result;
    }

    @Override
    protected long getMaxInactiveTime() {
        return this.maxInactivityTime;
    }

    @Override
    protected S2SIOService getXMPPIOServiceInstance() {
        return new S2SIOService();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    protected CIDConnections createNewCIDConnections(CID cid) throws NotLocalhostException, LocalhostException {
        if (!this.isLocalDomainOrComponent(cid.getLocalHost())) {
            throw new NotLocalhostException("This is not a valid localhost: " + cid.getLocalHost());
        }
        if (this.isLocalDomainOrComponent(cid.getRemoteHost())) {
            throw new LocalhostException("This is not a valid remotehost: " + cid.getRemoteHost());
        }
        CIDConnections cid_conns = new CIDConnections(cid, this, this.connSelector, this.maxINConnections, this.maxOUTTotalConnections, this.maxOUTPerIPConnections, this.maxPacketWaitingTime);
        this.cidConnections.put(cid, cid_conns);
        return cid_conns;
    }

    private CIDConnections getCIDConnections(CID cid) {
        if (cid == null) {
            return null;
        }
        return this.cidConnections.get(cid);
    }

    private Packet getValidResponse(String elem_name, CID cid, String id, StanzaType type, String cdata) {
        Element elem = new Element(elem_name);
        if (cdata != null) {
            elem.setCData(cdata);
        }
        if (type != null) {
            elem.addAttribute("type", type.name());
        }
        if (id != null) {
            elem.addAttribute("id", id);
        }
        Packet result = Packet.packetInstance(elem, JID.jidInstanceNS(cid.getLocalHost()), JID.jidInstanceNS(cid.getRemoteHost()));
        return result;
    }

    protected static class DomainServerNameMapper {
        private List<Entry> entries = new ArrayList<Entry>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addEntry(String pattern, String serverName) {
            DomainServerNameMapper domainServerNameMapper = this;
            synchronized (domainServerNameMapper) {
                ArrayList<Entry> entries = new ArrayList<Entry>(this.entries);
                Entry e = new Entry(pattern, serverName);
                entries.add(e);
                Collections.sort(entries);
                this.entries = entries;
            }
        }

        public String getServerNameForDomain(String domain) {
            for (Entry e : this.entries) {
                if (!e.matches(domain)) continue;
                return e.getServerName();
            }
            return domain;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName()).append("[");
            boolean first = true;
            for (Entry e : this.entries) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(e.pattern);
                sb.append("=");
                sb.append(e.serverName);
                first = false;
            }
            sb.append("]");
            return sb.toString();
        }

        private class Entry
        implements Comparable<Entry> {
            private final String pattern;
            private final String serverName;

            public Entry(String pattern, String serverName) {
                this.pattern = pattern.toLowerCase();
                this.serverName = serverName;
            }

            public String getServerName() {
                return this.serverName;
            }

            public boolean matches(String domain) {
                if ("*".equals(this.pattern)) {
                    return true;
                }
                return CertificateUtil.match(domain, this.pattern);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Entry) {
                    return this.pattern.equals(((Entry)obj).pattern);
                }
                return false;
            }

            public int hashCode() {
                return this.pattern.hashCode();
            }

            @Override
            public int compareTo(Entry o) {
                int val;
                if (o.pattern.contains("*")) {
                    if (!this.pattern.contains("*")) {
                        return -1;
                    }
                } else if (this.pattern.contains("*")) {
                    return 1;
                }
                if ((val = (this.pattern.split(".").length - o.pattern.split(".").length) * -1) != 0) {
                    return val;
                }
                return o.pattern.length() - this.pattern.length();
            }
        }
    }
}

