/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.server.xmppclient.SeeOtherHostDualIP;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
class SeeOtherHostDualIPSQLRepository
implements SeeOtherHostDualIP.DualIPRepository {
    public static final String CLUSTER_NODES_TABLE = "cluster_nodes";
    public static final String DB_GET_ALL_DATA_DB_QUERY_KEY = "cm-see-other-host/get-all-data-query";
    public static final String GET_ALL_QUERY_TIMEOUT_QUERY_KEY = "cm-see-other-host/get-all-query-timeout";
    private static final String DEF_DB_GET_ALL_DATA_QUERY = "select * from cluster_nodes";
    private static final int DEF_QUERY_TIME_OUT = 10;
    private String get_all_data_query = "select * from cluster_nodes";
    private int query_timeout = 10;
    private DataRepository data_repo = null;
    private static final Logger log = Logger.getLogger(SeeOtherHostDualIPSQLRepository.class.getName());

    SeeOtherHostDualIPSQLRepository() {
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        if (params.containsKey("--cm-see-other-host/get-all-data-query")) {
            this.get_all_data_query = (String)params.get("--cm-see-other-host/get-all-data-query");
        }
        defs.put(DB_GET_ALL_DATA_DB_QUERY_KEY, this.get_all_data_query);
        if (params.containsKey("--cm-see-other-host/get-all-query-timeout")) {
            this.query_timeout = Integer.parseInt((String)params.get("--cm-see-other-host/get-all-query-timeout"));
        }
        defs.put(GET_ALL_QUERY_TIMEOUT_QUERY_KEY, this.query_timeout);
    }

    @Override
    public void initRepository(String conn_str, Map<String, String> map) throws DBInitException {
        try {
            log.log(Level.INFO, "Initializing dbAccess for db connection url: {0}", conn_str);
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
            this.checkDB();
            this.data_repo.initPreparedStatement(this.get_all_data_query, this.get_all_data_query);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
            throw new DBInitException("Repository initialization failed", ex);
        }
    }

    private void checkDB() throws SQLException {
        if (!this.data_repo.checkTable(CLUSTER_NODES_TABLE)) {
            throw new SQLException("Nodes redirection table doesn't exits!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, BareJID> queryAllDB() throws SQLException {
        ConcurrentSkipListMap<BareJID, BareJID> result = new ConcurrentSkipListMap<BareJID, BareJID>();
        if (this.data_repo == null) {
            return null;
        }
        PreparedStatement get_all = this.data_repo.getPreparedStatement(null, this.get_all_data_query);
        get_all.setQueryTimeout(10);
        ResultSet rs = null;
        PreparedStatement preparedStatement = get_all;
        synchronized (preparedStatement) {
            try {
                rs = get_all.executeQuery();
                while (rs.next()) {
                    String user_jid = rs.getString("hostname");
                    String node_jid = rs.getString("secondary");
                    try {
                        BareJID hostname_hid = BareJID.bareJIDInstance(user_jid);
                        BareJID secondary = BareJID.bareJIDInstance(node_jid);
                        result.put(hostname_hid, secondary);
                    }
                    catch (TigaseStringprepException ex) {
                        log.warning("Invalid host or secondary hostname JID: " + user_jid + ", " + node_jid);
                    }
                }
            }
            finally {
                this.data_repo.release(null, rs);
            }
        }
        log.info("Loaded " + result.size() + " redirect definitions from database.");
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(DB_GET_ALL_DATA_DB_QUERY_KEY) && !props.get(DB_GET_ALL_DATA_DB_QUERY_KEY).toString().trim().isEmpty()) {
            this.get_all_data_query = props.get(DB_GET_ALL_DATA_DB_QUERY_KEY).toString().trim();
        }
        props.put(DB_GET_ALL_DATA_DB_QUERY_KEY, this.get_all_data_query);
        if (props.containsKey(GET_ALL_QUERY_TIMEOUT_QUERY_KEY) && !props.get(GET_ALL_QUERY_TIMEOUT_QUERY_KEY).toString().trim().isEmpty()) {
            this.query_timeout = Integer.parseInt(props.get(GET_ALL_QUERY_TIMEOUT_QUERY_KEY).toString().trim());
        }
        props.put(GET_ALL_QUERY_TIMEOUT_QUERY_KEY, this.query_timeout);
    }
}

