/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.action;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepositoryImpl;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.server.Packet;
import tigase.server.amp.ActionAbstract;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.server.amp.MsgRepository;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;

public class Store
extends ActionAbstract {
    private static final Logger log = Logger.getLogger(Store.class.getName());
    private static final String name = "store";
    private Thread expiredProcessor = null;
    private MsgRepositoryIfc repo = null;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat formatter2;
    private NonAuthUserRepositoryImpl nonAuthUserRepo;

    public Store() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Packet packet, Element rule) {
        if (this.repo != null) {
            String stamp;
            Date expired;
            block20: {
                expired = null;
                stamp = null;
                if (packet.getAttributeStaticStr("expired") == null) {
                    if (rule == null) {
                        rule = this.getExpireAtRule(packet);
                    }
                } else {
                    this.removeExpireAtRule(packet);
                    rule = null;
                }
                if (rule != null) {
                    try {
                        SimpleDateFormat simpleDateFormat;
                        String value = rule.getAttributeStaticStr("value");
                        if (value == null) break block20;
                        if (value.contains(".")) {
                            simpleDateFormat = this.formatter;
                            synchronized (simpleDateFormat) {
                                expired = this.formatter.parse(value);
                                break block20;
                            }
                        }
                        simpleDateFormat = this.formatter2;
                        synchronized (simpleDateFormat) {
                            expired = this.formatter2.parse(value);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.INFO, "Incorrect expire-at value: " + rule.getAttributeStaticStr("value"), e);
                        expired = null;
                    }
                }
            }
            SimpleDateFormat e = this.formatter;
            synchronized (e) {
                stamp = this.formatter.format(new Date());
            }
            this.removeTigasePayload(packet);
            try {
                Element elem = packet.getElement();
                if (elem.getChild("delay", "urn:xmpp:delay") == null) {
                    Element x = new Element("delay", "Offline Storage", new String[]{"from", "stamp", "xmlns"}, new String[]{packet.getStanzaTo().getDomain(), stamp, "urn:xmpp:delay"});
                    elem.addChild(x);
                }
                this.repo.storeMessage(packet.getStanzaFrom(), packet.getStanzaTo(), expired, elem, this.nonAuthUserRepo);
            }
            catch (UserNotFoundException ex) {
                log.info("User not found for offline message: " + packet);
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String db_uri = (String)params.get("--amp-repo-uri");
        String db_cls = (String)params.get("--amp-repo-class");
        if (db_uri == null) {
            db_uri = (String)params.get("--user-db-uri");
        }
        if (db_uri != null) {
            defs.put("amp-repo-uri", db_uri);
        }
        if (db_cls != null) {
            defs.put("amp-repo-class", db_cls);
        }
        return defs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setProperties(Map<String, Object> props, ActionResultsHandlerIfc handler) {
        super.setProperties(props, handler);
        UserRepository user_repository = (UserRepository)props.get("shared-user-repo");
        this.nonAuthUserRepo = new NonAuthUserRepositoryImpl(user_repository, null, true);
        String db_uri = (String)props.get("amp-repo-uri");
        String db_cls = (String)props.get("amp-repo-class");
        if (db_uri != null) {
            try {
                this.repo = MsgRepository.getInstance(db_cls, db_uri);
                HashMap<String, String> db_props = new HashMap<String, String>(4);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (entry.getValue() == null) continue;
                    log.log(Level.CONFIG, "Reading properties: (" + entry.getKey() + ", " + entry.getValue() + ")");
                    if (entry.getValue() instanceof String[]) {
                        String[] val = (String[])entry.getValue();
                        db_props.put(entry.getKey(), Stream.of(val).collect(Collectors.joining(",")));
                        continue;
                    }
                    db_props.put(entry.getKey(), entry.getValue().toString());
                }
                this.repo.initRepository(db_uri, db_props);
            }
            catch (TigaseDBException ex) {
                this.repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
        if (this.repo != null && this.expiredProcessor == null) {
            this.expiredProcessor = new Thread("expired-processor"){

                @Override
                public void run() {
                    while (true) {
                        Element elem;
                        if ((elem = Store.this.repo.getMessageExpired(0L, true)) == null) {
                            continue;
                        }
                        elem.addAttribute("offline", "1");
                        elem.addAttribute("expired", "1");
                        try {
                            Store.this.resultsHandler.addOutPacket(Packet.packetInstance(elem));
                            continue;
                        }
                        catch (TigaseStringprepException ex) {
                            log.info("Stringprep error for offline message loaded from DB: " + elem);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.expiredProcessor.setDaemon(true);
            this.expiredProcessor.start();
        }
    }

    private Element getExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List<Element> rules = amp.getChildren();
        Element rule = null;
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                rule = r;
                break;
            }
        }
        return rule;
    }

    private void removeExpireAtRule(Packet packet) {
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        List<Element> rules = amp.getChildren();
        if (rules != null && rules.size() > 0) {
            for (Element r : rules) {
                String cond = r.getAttributeStaticStr("condition");
                if (cond == null || !cond.equals("expire-at")) continue;
                amp.removeChild(r);
                break;
            }
        }
        if ((rules = amp.getChildren()) == null || rules.size() == 0) {
            packet.getElement().removeChild(amp);
        }
    }
}

