/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigurationException;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.amp.ActionAbstract;
import tigase.server.amp.ActionIfc;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.server.amp.ConditionIfc;
import tigase.server.amp.action.Alert;
import tigase.server.amp.action.Broadcast;
import tigase.server.amp.action.Drop;
import tigase.server.amp.action.Error;
import tigase.server.amp.action.Notify;
import tigase.server.amp.action.Store;
import tigase.server.amp.cond.Deliver;
import tigase.server.amp.cond.ExpireAt;
import tigase.server.amp.cond.MatchResource;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class AmpComponent
extends AbstractMessageReceiver
implements ActionResultsHandlerIfc {
    private static final String AMP_NODE = "http://jabber.org/protocol/amp";
    private static final Logger log = Logger.getLogger(AmpComponent.class.getName());
    private static final String AMP_XMLNS = "http://jabber.org/protocol/amp";
    private static final Element top_feature = new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"});
    private Map<String, ActionIfc> actions = new ConcurrentSkipListMap<String, ActionIfc>();
    private Map<String, ConditionIfc> conditions = new ConcurrentSkipListMap<String, ConditionIfc>();
    protected final Broadcast broadcast = new Broadcast();

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    public boolean addOutPackets(Queue<Packet> packets) {
        return super.addOutPackets(packets);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        ActionAbstract action = new Drop();
        this.actions.put(action.getName(), action);
        action = new Error();
        this.actions.put(action.getName(), action);
        action = new Notify();
        this.actions.put(action.getName(), action);
        action = new tigase.server.amp.action.Deliver();
        this.actions.put(action.getName(), action);
        action = new Store();
        this.actions.put(action.getName(), action);
        action = new Alert();
        this.actions.put(action.getName(), action);
        ConditionIfc condition = new Deliver();
        this.conditions.put(condition.getName(), condition);
        condition = new ExpireAt();
        this.conditions.put(condition.getName(), condition);
        condition = new MatchResource();
        this.conditions.put(condition.getName(), condition);
        for (ActionIfc a : this.actions.values()) {
            Map<String, Object> d = a.getDefaults(params);
            if (d == null) continue;
            defs.putAll(d);
        }
        Map<String, Object> d = this.broadcast.getDefaults(params);
        if (d != null) {
            defs.putAll(d);
        }
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return "generic";
    }

    @Override
    public String getDiscoDescription() {
        return "IM AMP Support";
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        Element query = super.getDiscoInfo(node, jid, from);
        if (jid != null && (this.getName().equals(jid.getLocalpart()) || this.isLocalDomain(jid.toString())) && "http://jabber.org/protocol/amp".equals(node)) {
            if (query == null) {
                query = new Element("query");
                query.setXMLNS("http://jabber.org/protocol/disco#info");
            }
            query.addChild(new Element("identity", new String[]{"name", "category", "type"}, new String[]{this.getDiscoDescription(), "im", this.getDiscoCategoryType()}));
            query.addChild(top_feature);
            for (ActionIfc action : this.actions.values()) {
                query.addChild(new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp?action=" + action.getName()}));
            }
            for (ConditionIfc cond : this.conditions.values()) {
                query.addChild(new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp?condition=" + cond.getName()}));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Found disco info: " + (query != null ? query.toString() : null));
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("My packet: " + packet);
        }
        if (this.broadcast.preprocess(packet)) {
            return;
        }
        ActionIfc def = null;
        def = packet.getAttributeStaticStr("offline") == null ? this.actions.get("deliver") : this.actions.get("store");
        boolean exec_def = true;
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        if (amp == null) {
            log.warning("Not an AMP packet! " + packet);
            return;
        }
        List<Element> rules = amp.getChildren();
        if (rules != null && rules.size() > 0) {
            for (Element rule : rules) {
                if (!this.matchCondition(packet, rule)) continue;
                exec_def = this.executeAction(packet, rule);
                break;
            }
        } else {
            log.warning("AMP packet but empty rule-set! " + packet);
            return;
        }
        if (exec_def) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Executing default action: " + def.getName());
            }
            def.execute(packet, null);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        for (ActionIfc a : this.actions.values()) {
            a.setProperties(props, this);
        }
        this.broadcast.setProperties(props, this);
    }

    private boolean executeAction(Packet packet, Element rule) {
        String act = rule.getAttributeStaticStr("action");
        if (act != null) {
            ActionIfc action = this.actions.get(act);
            if (action != null) {
                boolean result = action.execute(packet, rule);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Matched action: " + action.getName() + ", result: " + result);
                }
                return result;
            }
            log.fine("No action found for act: " + act);
        } else {
            log.fine("No actionset for rule: " + rule);
        }
        return true;
    }

    private boolean matchCondition(Packet packet, Element rule) {
        String cond = rule.getAttributeStaticStr("condition");
        if (cond != null) {
            ConditionIfc condition = this.conditions.get(cond);
            if (condition != null) {
                boolean result = condition.match(packet, rule);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Matched condition: " + condition.getName() + ", result: " + result);
                }
                return result;
            }
            log.fine("No condition found for cond: " + cond);
        } else {
            log.fine("No condition set for rule: " + rule);
        }
        return false;
    }
}

