/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.bridge.SLF4JBridgeHandler;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.osgi.ModulesManager;
import tigase.osgi.ModulesManagerImpl;
import tigase.osgi.util.ClassUtil;
import tigase.server.XMPPServer;
import tigase.xmpp.XMPPImplIfc;

public class Activator
implements BundleActivator {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private static Bundle bundle = null;

    public void start(BundleContext bc) throws Exception {
        try {
            bundle = bc.getBundle();
            if (!SLF4JBridgeHandler.isInstalled()) {
                SLF4JBridgeHandler.install();
            }
            XMPPServer.setOSGi(true);
            try {
                Set<Class<XMPPImplIfc>> procs = ClassUtil.getClassesImplementing(XMPPImplIfc.class);
                ArrayList elems = new ArrayList(32);
                for (Class<XMPPImplIfc> cproc : procs) {
                    if (!Modifier.isPublic(cproc.getModifiers()) || cproc == null) continue;
                    ModulesManagerImpl.getInstance().registerPluginClass(cproc);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Plugin loading excepton", e);
            }
            try {
                Set<Class<Repository>> repos = ClassUtil.getClassesImplementing(Repository.class);
                RepositoryFactory.initialize(repos);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not initialize properly ResourceFactory", e);
            }
            ModulesManagerImpl.getInstance().setActive(true);
            bc.registerService(ModulesManager.class.getName(), (Object)ModulesManagerImpl.getInstance(), new Hashtable());
            XMPPServer.start(new String[]{"--property-file", "etc/init.properties"});
            SLF4JBridgeHandler.install();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error starting bundle: ", ex);
            throw ex;
        }
    }

    public void stop(BundleContext bc) throws Exception {
        try {
            ModulesManagerImpl.getInstance().setActive(false);
            XMPPServer.stop();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error stopping bundle: ", ex);
            throw ex;
        }
    }

    public static Bundle getBundle() {
        return bundle;
    }
}

