/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts.filter;

import java.text.ParseException;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.filter.CustomDomainFilter;
import tigase.vhosts.filter.Rule;
import tigase.xmpp.JID;

public class CustomDomainFilterTest {
    String[] rules = new String[]{"4|deny|all", "1|allow|self", "3|allow|jid|pubsub@test.com", "2|allow|jid|admin@test2.com"};

    @BeforeClass
    public static void setUpClass() {
    }

    @Before
    public void setUp() {
    }

    @Test
    public void testParseRules() throws TigaseStringprepException, ParseException {
        System.out.println("parseRules");
        TreeSet<Rule> expResult = new TreeSet<Rule>();
        Rule rule = new Rule(1, true, Rule.RuleType.self, null);
        if (rule != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(2, true, Rule.RuleType.jid, JID.jidInstance((String)"admin@test2.com"))) != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(3, true, Rule.RuleType.jid, JID.jidInstance((String)"pubsub@test.com"))) != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(4, false, Rule.RuleType.all, null)) != null) {
            expResult.add(rule);
        }
        Set result = CustomDomainFilter.parseRules((String[])this.rules);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testParseRulesString() throws TigaseStringprepException, ParseException {
        System.out.println("parseRules");
        String rulseString = "4|deny|all;1|allow|self;3|allow|jid|pubsub@test.com;2|allow|jid|admin@test2.com";
        TreeSet<Rule> expResult = new TreeSet<Rule>();
        Rule rule = new Rule(1, true, Rule.RuleType.self, null);
        if (rule != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(2, true, Rule.RuleType.jid, JID.jidInstance((String)"admin@test2.com"))) != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(3, true, Rule.RuleType.jid, JID.jidInstance((String)"pubsub@test.com"))) != null) {
            expResult.add(rule);
        }
        if ((rule = new Rule(4, false, Rule.RuleType.all, null)) != null) {
            expResult.add(rule);
        }
        Set result = CustomDomainFilter.parseRules((String)rulseString);
        Assert.assertEquals(expResult, (Object)result);
        rulseString = "1|allow|self;2|allow|jid|admin@test2.com;3|allow|jid|pubsub@test.com;4|deny|all;";
        String resultString = new String();
        for (Rule res : result) {
            resultString = resultString + res.toConfigurationString();
        }
        Assert.assertEquals((Object)rulseString, (Object)resultString);
    }

    @Test(expected=ParseException.class)
    public void testParseRulesException() throws TigaseStringprepException, ParseException {
        String[] rules_fail = new String[]{"8|deny|||self,", "|||18|||deny,self::::"};
        Set result = CustomDomainFilter.parseRules((String[])rules_fail);
    }

    @Test
    public void testIsAllowed() throws TigaseStringprepException, ParseException {
        JID jid1_r1 = JID.jidInstance((String)"user1", (String)"domain1", (String)"resource1");
        JID jid1_r2 = JID.jidInstance((String)"user1", (String)"domain1", (String)"resource2");
        JID jid2_r1 = JID.jidInstance((String)"user2", (String)"domain1", (String)"resource1");
        JID jid3_r1 = JID.jidInstance((String)"user3", (String)"domain1", (String)"resource1");
        JID admin = JID.jidInstance((String)"admin", (String)"test2.com");
        JID pubsub = JID.jidInstance((String)"pubsub", (String)"test.com");
        boolean allowed = CustomDomainFilter.isAllowed((JID)jid1_r1, (JID)jid1_r2, (String[])this.rules);
        Assert.assertTrue((String)"should be allowed / self / permitted jid", (boolean)allowed);
        allowed = CustomDomainFilter.isAllowed((JID)jid1_r1, (JID)admin, (String[])this.rules);
        Assert.assertTrue((String)"should be allowed / permitted jid", (boolean)allowed);
        allowed = CustomDomainFilter.isAllowed((JID)jid1_r1, (JID)pubsub, (String[])this.rules);
        Assert.assertTrue((String)"should be allowed / permitted jid", (boolean)allowed);
        allowed = CustomDomainFilter.isAllowed((JID)jid1_r1, (JID)jid2_r1, (String[])this.rules);
        Assert.assertFalse((String)"should be denyed / permitted jid", (boolean)allowed);
        allowed = CustomDomainFilter.isAllowed((JID)jid2_r1, (JID)jid2_r1, (String[])this.rules);
        Assert.assertTrue((String)"should be allowed / self", (boolean)allowed);
        allowed = CustomDomainFilter.isAllowed((JID)jid3_r1, (JID)jid2_r1, (String[])this.rules);
        Assert.assertFalse((String)"should be denied / not permitted jids", (boolean)allowed);
    }
}

