/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SConnectionSelector;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SRandomSelector;
import tigase.server.xmppserver.proc.Dialback;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public class DialbackTest
extends TestCase {
    private Dialback dialback = new Dialback(){

        public boolean skipTLSForHost(String hostname) {
            return true;
        }

        protected boolean wasVerifyRequested(S2SIOService serv, String domain) {
            return true;
        }
    };
    private S2SConnectionHandlerIfc<S2SIOService> handler = null;
    private String remote1 = "remote1.com";
    private String remote2 = "remote2.com";
    private String local = "local.com";

    @Test
    public void testAuthorizationForSingleDomain() throws TigaseStringprepException {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.handler = new S2SConnectionHandlerImpl(results);
        this.dialback.init(this.handler, new HashMap());
        String key = UUID.randomUUID().toString();
        S2SIOService serv = new S2SIOService();
        serv.setSessionId("sess-id-1");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "accept");
        serv.setSessionData(props);
        Packet p = null;
        Element resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote1);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        Packet r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "valid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.valid && this.remote1.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        serv.getCIDs().forEach(cid -> DialbackTest.assertEquals((String)this.remote1, (String)cid.getRemoteHost()));
    }

    @Test
    public void testAuthorizationForSingleDomainFailure() throws TigaseStringprepException {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.handler = new S2SConnectionHandlerImpl(results);
        this.dialback.init(this.handler, new HashMap());
        String key = UUID.randomUUID().toString();
        S2SIOService serv = new S2SIOService();
        serv.setSessionId("sess-id-1");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "accept");
        serv.setSessionData(props);
        Packet p = null;
        Element resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote1);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        Packet r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "invalid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.invalid && this.remote1.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        serv.getCIDs().forEach(cid -> DialbackTest.assertNotSame((Object)this.remote1, (Object)cid.getRemoteHost()));
    }

    @Test
    public void testAuthorizationWithMultiplexing() throws TigaseStringprepException {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.handler = new S2SConnectionHandlerImpl(results);
        this.dialback.init(this.handler, new HashMap());
        String key = UUID.randomUUID().toString();
        S2SIOService serv = new S2SIOService();
        serv.setSessionId("sess-id-1");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "accept");
        serv.setSessionData(props);
        Packet p = null;
        Element resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote1);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        Packet r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "valid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.valid && this.remote1.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        serv.getCIDs().forEach(cid -> DialbackTest.assertEquals((String)this.remote1, (String)cid.getRemoteHost()));
        key = UUID.randomUUID().toString();
        resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote2);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "valid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.valid && this.remote2.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        DialbackTest.assertTrue((boolean)serv.getCIDs().stream().anyMatch(cid -> this.remote1.equals(cid.getRemoteHost())));
        DialbackTest.assertTrue((boolean)serv.getCIDs().stream().anyMatch(cid -> this.remote2.equals(cid.getRemoteHost())));
    }

    @Test
    public void testAuthorizationWithMultiplexingWithFailure() throws TigaseStringprepException {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.handler = new S2SConnectionHandlerImpl(results);
        this.dialback.init(this.handler, new HashMap());
        String key = UUID.randomUUID().toString();
        S2SIOService serv = new S2SIOService();
        serv.setSessionId("sess-id-1");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "accept");
        serv.setSessionData(props);
        Packet p = null;
        Element resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote1);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        Packet r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "valid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.valid && this.remote1.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        serv.getCIDs().forEach(cid -> DialbackTest.assertEquals((String)this.remote1, (String)cid.getRemoteHost()));
        key = UUID.randomUUID().toString();
        resultEl = new Element("db:result");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("from", this.remote2);
        resultEl.setAttribute("to", this.local);
        resultEl.setCData(key);
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        r = (Packet)results.poll();
        resultEl = new Element("db:verify");
        resultEl.setXMLNS("jabber:server:dialback");
        resultEl.setAttribute("id", r.getAttributeStaticStr("id"));
        resultEl.setAttribute("from", r.getAttributeStaticStr("to"));
        resultEl.setAttribute("to", r.getAttributeStaticStr("from"));
        resultEl.setAttribute("type", "invalid");
        p = Packet.packetInstance((Element)resultEl);
        this.dialback.process(p, serv, results);
        p = (Packet)results.poll();
        DialbackTest.assertTrue((p.getType() == StanzaType.invalid && this.remote2.equals(p.getStanzaTo().getDomain()) ? 1 : 0) != 0);
        DialbackTest.assertTrue((boolean)serv.getCIDs().stream().anyMatch(cid -> this.remote1.equals(cid.getRemoteHost())));
        DialbackTest.assertTrue((boolean)serv.getCIDs().stream().allMatch(cid -> !this.remote2.equals(cid.getRemoteHost())));
    }

    private static class S2SConnectionHandlerImpl
    extends S2SConnectionManager {
        private Queue<Packet> results;

        public S2SConnectionHandlerImpl(Queue<Packet> results) {
            this.results = results;
        }

        protected CIDConnections createNewCIDConnections(CID cid) throws NotLocalhostException, LocalhostException {
            CIDConnections conns = new CIDConnections(cid, (S2SConnectionHandlerIfc)this, (S2SConnectionSelector)new S2SRandomSelector(), 5, 5, 5, 5000L){

                public void sendHandshakingOnly(Packet verify_req) {
                    results.offer(verify_req);
                }

                public boolean sendControlPacket(String sessionId, Packet packet) {
                    return results.offer(packet);
                }

                public void sendPacket(Packet packet) {
                    results.offer(packet);
                }
            };
            this.cidConnections.put(cid, conns);
            return conns;
        }

        public boolean isTlsRequired(String domain) {
            return false;
        }
    }
}

