/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.server.Packet;
import tigase.server.xmppclient.StreamManagementIOProcessor;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;

public class StreamManagementIOProcessorTest
extends TestCase {
    private static final String[] DELAY_PATH = new String[]{"message", "delay"};
    private static final String DELAY_XMLNS = "urn:xmpp:delay";

    @Test
    public void testValidateOutQueueOverflowToZero() {
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFF5;
        queue.setCounter(start - 1);
        int packetToAck = start + 5;
        for (int i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                Packet p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p);
                continue;
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        queue.ack(packetToAck);
        int size = queue.waitingForAck();
        StreamManagementIOProcessorTest.assertEquals((int)5, (int)size);
        StreamManagementIOProcessorTest.assertEquals((String)((StreamManagementIOProcessor.OutQueue.Entry)queue.getQueue().peek()).getPacketWithStamp().getElement().getAttributeStaticStr("id"), (String)String.valueOf(packetToAck + 1));
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertTrue((boolean)e.getPacketWithStamp().isXMLNSStaticStr(DELAY_PATH, DELAY_XMLNS)));
    }

    @Test
    public void testValidateOutQueueOverflowOverZero() {
        Packet p;
        int i;
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFFA;
        queue.setCounter(start - 1);
        int packetToAck = start + 3;
        for (i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p);
                continue;
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (i = 0; i < 3; ++i) {
            try {
                p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p);
                continue;
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        queue.ack(packetToAck);
        int size = queue.waitingForAck();
        StreamManagementIOProcessorTest.assertEquals((int)5, (int)size);
        StreamManagementIOProcessorTest.assertEquals((String)((StreamManagementIOProcessor.OutQueue.Entry)queue.getQueue().peek()).getPacketWithStamp().getElement().getAttributeStaticStr("id"), (String)String.valueOf(packetToAck + 1));
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertTrue((boolean)e.getPacketWithStamp().isXMLNSStaticStr(DELAY_PATH, DELAY_XMLNS)));
    }

    @Test
    public void testNoDelayForIq() {
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFF5;
        queue.setCounter(start - 1);
        int packetToAck = start + 5;
        for (int i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                Packet p = Packet.packetInstance((Element)new Element("iq", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p);
                continue;
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertFalse((boolean)e.getPacketWithStamp().isXMLNSStaticStr(new String[]{"iq", "delay"}, DELAY_XMLNS)));
    }

    @Test
    public void testForceDelayForResumption() {
        Packet p;
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        try {
            p = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{DELAY_XMLNS, "2015-07-10T00:00:00.000Z"})}, new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-1"), "from@example.com", "to@example.com"}));
            queue.append(p);
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertEquals((int)1, (int)e.getPacketWithStamp().getElement().findChildren(el -> el.getName() == "delay").size()));
        queue.getQueue().clear();
        queue.setResumptionEnabled(true);
        try {
            p = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{DELAY_XMLNS, "2015-07-10T00:00:00.000Z"})}, new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-1"), "from@example.com", "to@example.com"}));
            queue.append(p);
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertEquals((int)1, (int)e.getPacketWithStamp().getElement().findChildren(el -> el.getName() == "delay").size()));
        queue.getQueue().clear();
        try {
            p = Packet.packetInstance((Element)new Element("iq", new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-2"), "from@example.com", "to@example.com"}));
            queue.append(p);
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(StreamManagementIOProcessorTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertFalse((boolean)e.getPacketWithStamp().isXMLNSStaticStr(new String[]{"iq", "delay"}, DELAY_XMLNS)));
    }
}

