/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import javax.security.sasl.SaslException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import tigase.auth.mechanisms.SaslSCRAMPlus;
import tigase.auth.mechanisms.SaslSCRAMTest;
import tigase.util.Base64;

public class SaslSCRAMPlusTest
extends TestCase {
    private SaslSCRAMPlus create(String salt, String snonce, String password, byte[] bindingData) {
        SaslSCRAMTest.TestCallbackHandler h = new SaslSCRAMTest.TestCallbackHandler();
        h.setBindingData(bindingData);
        h.setPassword(password);
        h.setSalt(salt);
        return new SaslSCRAMPlus(null, h, snonce){};
    }

    @Test
    public void testChannelBindingEncodingEncoding() throws SaslException {
        String CFM = "cD10bHMtdW5pcXVlLCxuPWJtYWxrb3cscj1TanF1Y3NIdmkzQjR0c1lrTkpCS0lJdHM=";
        String SFM = "cj1TanF1Y3NIdmkzQjR0c1lrTkpCS0lJdHNjdUVZWGMvU210dWtTUjIycVoscz1NZzRxWVlUckh6VkUyUUdZLGk9NDA5Ng==";
        String CSM = "Yz1jRDEwYkhNdGRXNXBjWFZsTEN4WHhZRFpldWFPU01qWTE3cG5QZXE2K2FDaUdIODg1dW9PVlFKMm5rQlk4dz09LHI9U2pxdWNzSHZpM0I0dHNZa05KQktJSXRzY3VFWVhjL1NtdHVrU1IyMnFaLHA9NC9ZeHptOUZsV24xT1duaUJVQ08yeC9jMXo4PQ==";
        SaslSCRAMPlus m = this.create("Mg4qYYTrHzVE2QGY", "cuEYXc/SmtukSR22qZ", "123456", Base64.decode((String)"V8WA2XrmjkjI2Ne6Zz3quvmgohh/PObqDlUCdp5AWPM="));
        byte[] req = Base64.decode((String)CFM);
        byte[] rsp = m.evaluateResponse(req);
        System.out.println(new String(rsp));
        System.out.println(new String(Base64.decode((String)SFM)));
        req = Base64.decode((String)CSM);
        rsp = m.evaluateResponse(req);
    }

    @Test
    public void testInvalidBinding() {
        SaslSCRAMPlus m = this.create("AecUfGKyBAbZjjXW", "k5m3fXaEqPQ0zxIjpl", "123456", new byte[]{68, 80, 73});
        try {
            byte[] r = m.evaluateResponse("p=tls-unique,,n=bmalkow,r=mnKBtk4+09BtRQM3AkSsjsE5".getBytes());
            Assert.assertEquals((Object)"r=mnKBtk4+09BtRQM3AkSsjsE5k5m3fXaEqPQ0zxIjpl,s=AecUfGKyBAbZjjXW,i=4096", (Object)new String(r));
            r = m.evaluateResponse("c=cD10bHMtdW5pcXVlLCxEVVBB,r=mnKBtk4+09BtRQM3AkSsjsE5k5m3fXaEqPQ0zxIjpl,p=BatbnZpQ+UolSyWBozXyvS8Yl78=".getBytes());
            SaslSCRAMPlusTest.fail();
        }
        catch (SaslException e) {
            Assert.assertEquals((Object)"Channel bindings does not match", (Object)e.getMessage());
        }
    }

    @Test
    public void testModifiedBinding() {
        SaslSCRAMPlus m = this.create("AecUfGKyBAbZjjXW", "k5m3fXaEqPQ0zxIjpl", "123456", new byte[]{68, 80, 73});
        try {
            byte[] r = m.evaluateResponse("p=tls-unique,,n=bmalkow,r=mnKBtk4+09BtRQM3AkSsjsE5".getBytes());
            Assert.assertEquals((Object)"r=mnKBtk4+09BtRQM3AkSsjsE5k5m3fXaEqPQ0zxIjpl,s=AecUfGKyBAbZjjXW,i=4096", (Object)new String(r));
            r = m.evaluateResponse("c=cD10bHMtdW5pcXVlLCxEUEk=,r=mnKBtk4+09BtRQM3AkSsjsE5k5m3fXaEqPQ0zxIjpl,p=BatbnZpQ+UolSyWBozXyvS8Yl78=".getBytes());
            SaslSCRAMPlusTest.fail();
        }
        catch (SaslException e) {
            Assert.assertEquals((Object)"Password not verified", (Object)e.getMessage());
        }
    }

    @Test
    public void testServerFirstMessageFail_1() {
        SaslSCRAMPlus m = this.create("Ey6OJnGx7JEJAIJp", "5kLrhitKUHVoSOmzdR", "123456", new byte[]{68, 80, 73});
        try {
            byte[] r = m.evaluateResponse("n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes());
            SaslSCRAMPlusTest.fail();
        }
        catch (SaslException e) {
            Assert.assertEquals((Object)"Invalid request for SCRAM-SHA-1-PLUS", (Object)e.getMessage());
        }
    }

    @Test
    public void testServerFirstMessageFail_2() {
        SaslSCRAMPlus m = this.create("Ey6OJnGx7JEJAIJp", "5kLrhitKUHVoSOmzdR", "123456", new byte[]{68, 80, 73});
        try {
            byte[] r = m.evaluateResponse("y,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes());
            SaslSCRAMPlusTest.fail();
        }
        catch (SaslException e) {
            Assert.assertEquals((Object)"Server supports PLUS. Please use 'p'", (Object)e.getMessage());
        }
    }

    @Test
    public void testServerFirstMessageWithBinding() {
        SaslSCRAMPlus m = this.create("Ey6OJnGx7JEJAIJp", "5kLrhitKUHVoSOmzdR", "123456", new byte[]{68, 80, 73});
        try {
            byte[] r = m.evaluateResponse("p=tls-unique,,n=bmalkow,r=SpiXKmhi57DBp5sdE5G3H3ms".getBytes());
            Assert.assertEquals((Object)"r=SpiXKmhi57DBp5sdE5G3H3ms5kLrhitKUHVoSOmzdR,s=Ey6OJnGx7JEJAIJp,i=4096", (Object)new String(r));
            r = m.evaluateResponse("c=cD10bHMtdW5pcXVlLCxEUEk=,r=SpiXKmhi57DBp5sdE5G3H3ms5kLrhitKUHVoSOmzdR,p=+zQvUd4nQqo03thSCcc2K6gueD4=".getBytes());
            Assert.assertEquals((Object)"v=NQ/f8FjeMxUuRK9F88G8tMji4pk=", (Object)new String(r));
        }
        catch (SaslException e) {
            e.printStackTrace();
            SaslSCRAMPlusTest.fail((String)e.getMessage());
        }
        SaslSCRAMPlusTest.assertTrue((boolean)m.isComplete());
        SaslSCRAMPlusTest.assertEquals((String)"user@domain.com", (String)m.getAuthorizationID());
    }
}

