/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.HandleStanzaTypes;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.annotation.StreamFeature;
import tigase.xmpp.impl.annotation.StreamFeatures;

public abstract class AnnotatedXMPPProcessor
extends XMPPProcessor {
    private String[][] ELEMENTS;
    private String[] XMLNSS;
    private Element[] DISCO_FEATURES;
    private Element[] STREAM_FEATURES;
    private Set<StanzaType> STANZA_TYPES;
    private String ID;

    protected AnnotatedXMPPProcessor() {
        Class<?> cls = this.getClass();
        cmpInfo = null;
        Id id = cls.getAnnotation(Id.class);
        if (id != null) {
            this.ID = id.value();
        }
        this.processHandleAnnotation(cls);
        this.processHandleStazaTypesAnnotation(cls);
        this.processStreamFeaturesAnnotation(cls);
        this.processDiscoFeaturesAnnotation(cls);
        cmpInfo = null;
    }

    @Override
    public String id() {
        return this.ID;
    }

    @Override
    public String[][] supElementNamePaths() {
        return this.ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return this.XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return this.DISCO_FEATURES;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return this.STREAM_FEATURES;
    }

    @Override
    public Set<StanzaType> supTypes() {
        return this.STANZA_TYPES;
    }

    private void processHandleAnnotation(Class cls) {
        ArrayList<String[]> elems = new ArrayList<String[]>();
        ArrayList<String> xmlnss = new ArrayList<String>();
        Handles handles = cls.getAnnotation(Handles.class);
        if (handles != null) {
            for (Handle handle : handles.value()) {
                AnnotatedXMPPProcessor.processHandle(handle, elems, xmlnss);
            }
        }
        Handle handle = cls.getAnnotation(Handle.class);
        AnnotatedXMPPProcessor.processHandle(handle, elems, xmlnss);
        if (!elems.isEmpty()) {
            this.ELEMENTS = (String[][])elems.toArray((T[])new String[elems.size()][]);
            this.XMLNSS = xmlnss.toArray(new String[xmlnss.size()]);
        }
    }

    private static void processHandle(Handle handle, List<String[]> elems, List<String> xmlnss) {
        if (handle != null) {
            String[] path = null;
            path = handle.path().length > 0 ? handle.path() : handle.pathStr().split("/");
            for (int i = 0; i < path.length; ++i) {
                path[i] = path[i].intern();
            }
            elems.add(path);
            xmlnss.add(handle.xmlns().intern());
        }
    }

    private void processStreamFeaturesAnnotation(Class cls) {
        StreamFeatures streamFeatures = cls.getAnnotation(StreamFeatures.class);
        if (streamFeatures != null) {
            ArrayList<Element> values = new ArrayList<Element>();
            for (StreamFeature feature : streamFeatures.value()) {
                values.add(new Element(feature.elem(), new String[]{"xmlns"}, new String[]{feature.xmlns()}));
            }
            this.STREAM_FEATURES = values.toArray(new Element[values.size()]);
        }
    }

    private void processDiscoFeaturesAnnotation(Class cls) {
        DiscoFeatures discoFeatures = cls.getAnnotation(DiscoFeatures.class);
        if (discoFeatures != null) {
            ArrayList<Element> values = new ArrayList<Element>();
            for (String feature : discoFeatures.value()) {
                values.add(new Element("feature", new String[]{"var"}, new String[]{feature}));
            }
            this.DISCO_FEATURES = values.toArray(new Element[values.size()]);
        }
    }

    private void processHandleStazaTypesAnnotation(Class cls) {
        HandleStanzaTypes handleStanzaTypes = cls.getAnnotation(HandleStanzaTypes.class);
        if (handleStanzaTypes != null) {
            StanzaType[] types = handleStanzaTypes.value();
            EnumSet<StanzaType> tmp = EnumSet.noneOf(StanzaType.class);
            tmp.addAll(Arrays.asList(types));
            this.STANZA_TYPES = tmp;
        }
    }
}

