/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentIOService;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.StreamOpenHandler;
import tigase.xml.Element;

public class JabberClientStreamOpenHandler
implements StreamOpenHandler {
    private static final Logger log = Logger.getLogger(JabberClientStreamOpenHandler.class.getName());
    public static final String XMLNS = "jabber:client";
    private String[] xmlnss = new String[]{"jabber:client"};

    @Override
    public String[] getXMLNSs() {
        return this.xmlnss;
    }

    @Override
    public String serviceStarted(ComponentIOService serv) {
        switch (serv.connectionType()) {
            case connect: {
                CompRepoItem repoItem = (CompRepoItem)serv.getSessionData().get("repo-item");
                String r_host = (String)serv.getSessionData().get("remote-host");
                serv.getSessionData().put("hostname-key", r_host);
                String data = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' version ='1.0' xml:lang='en' from='" + repoItem.getDomain() + "' to ='" + r_host + "'>";
                return data;
            }
        }
        return null;
    }

    @Override
    public String streamOpened(ComponentIOService serv, Map<String, String> attribs, ComponentProtocolHandler handler) {
        serv.getSessionData().put("xmlns", XMLNS);
        switch (serv.connectionType()) {
            case connect: {
                String id = attribs.get("id");
                if (id != null) {
                    serv.getSessionData().put("sessionID", id);
                }
                return null;
            }
            case accept: {
                String from_hostname = attribs.get("from");
                String to_hostname = attribs.get("to");
                CompRepoItem repoItem = handler.getCompRepoItem(from_hostname);
                serv.getSessionData().put("repo-item", repoItem);
                serv.getSessionData().put("hostname-key", from_hostname);
                String id = UUID.randomUUID().toString();
                serv.getSessionData().put("sessionID", id);
                StringBuilder sb = new StringBuilder();
                sb.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' version ='1.0' xml:lang='en' from='" + to_hostname + "' to='" + from_hostname + "' id='" + id + "'><stream:features>");
                List<Element> features = handler.getStreamFeatures(serv);
                for (Element element : features) {
                    sb.append(element.toString());
                }
                sb.append("</stream:features>");
                return sb.toString();
            }
        }
        return null;
    }
}

