/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.db.xml.XMLRepository;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public abstract class ProcessorTestCase {
    private static Logger log;
    private SessionManagerHandler loginHandler;

    public void setUp() throws Exception {
        this.loginHandler = new SessionManagerHandlerImpl();
    }

    public void tearDown() throws Exception {
        this.loginHandler = null;
    }

    protected XMPPResourceConnection getSession(JID connId, JID userJid) throws NotAuthorizedException, TigaseStringprepException {
        String xmlRepositoryURI = "memory://xmlRepo?autoCreateUser=true";
        XMLRepository xmlRepository = new XMLRepository();
        xmlRepository.initRepository(xmlRepositoryURI, null);
        XMPPResourceConnection conn = new XMPPResourceConnection(connId, (UserRepository)xmlRepository, (AuthRepository)xmlRepository, this.loginHandler);
        VHostItem vhost = new VHostItem();
        vhost.setVHost(userJid.getDomain());
        conn.setDomain(vhost);
        conn.authorizeJID(userJid.getBareJID(), false);
        conn.setResource(userJid.getResource());
        return conn;
    }

    private class SessionManagerHandlerImpl
    implements SessionManagerHandler {
        Map<BareJID, XMPPSession> sessions = new HashMap<BareJID, XMPPSession>();

        public JID getComponentId() {
            return JID.jidInstanceNS((String)"sess-man@localhost");
        }

        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(userId);
            if (session == null) {
                session = new XMPPSession(userId.getLocalpart());
                this.sessions.put(userId, session);
            }
            try {
                session.addResourceConnection(conn);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }

        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(conn);
            if (session != null) {
                session.removeResourceConnection(conn);
                if (session.getActiveResourcesSize() == 0) {
                    this.sessions.remove(userId);
                }
            }
        }

        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return !domain.contains("-ext");
        }

        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }
    }
}

