/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import org.junit.Assert;
import org.junit.Test;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.impl.OfflineMessages;

public class OfflineMessages_StampComparatorTest {
    @Test
    public void test_jabberXDelay() throws TigaseStringprepException {
        Packet p2;
        OfflineMessages.StampComparator comparator = new OfflineMessages.StampComparator();
        Packet p1 = this.createJabberXDelayPacket("20020910T23:08:25");
        Assert.assertTrue((comparator.compare(p1, p2 = this.createJabberXDelayPacket("20020910T22:08:25")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) < 0 ? 1 : 0) != 0);
        p1 = Packet.packetInstance((Element)new Element("message"));
        Assert.assertTrue((comparator.compare(p1, p2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_urnDelay() throws TigaseStringprepException {
        Packet p2;
        OfflineMessages.StampComparator comparator = new OfflineMessages.StampComparator();
        Packet p1 = this.createUrnXmppDelayPacket("2002-09-10T23:08:25Z");
        Assert.assertTrue((comparator.compare(p1, p2 = this.createUrnXmppDelayPacket("2002-09-10T22:08:25Z")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) < 0 ? 1 : 0) != 0);
        p1 = Packet.packetInstance((Element)new Element("message"));
        Assert.assertTrue((comparator.compare(p1, p2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_mixedDelay() throws TigaseStringprepException {
        Packet p2;
        OfflineMessages.StampComparator comparator = new OfflineMessages.StampComparator();
        Packet p1 = this.createJabberXDelayPacket("20020910T23:08:25");
        Assert.assertTrue((comparator.compare(p1, p2 = this.createUrnXmppDelayPacket("2002-09-10T22:08:25Z")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) < 0 ? 1 : 0) != 0);
        p1 = this.createUrnXmppDelayPacket("2002-09-10T23:08:25Z");
        p2 = this.createJabberXDelayPacket("20020910T22:08:25");
        Assert.assertTrue((comparator.compare(p1, p2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(p2, p1) < 0 ? 1 : 0) != 0);
    }

    private Packet createJabberXDelayPacket(String timestamp) throws TigaseStringprepException {
        Element elem = new Element("message", new Element[]{new Element("x", new String[]{"xmlns", "stamp"}, new String[]{"jabber:x:delay", timestamp})}, null, null);
        return Packet.packetInstance((Element)elem);
    }

    private Packet createUrnXmppDelayPacket(String timestamp) throws TigaseStringprepException {
        Element elem = new Element("message", new Element[]{new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", timestamp})}, null, null);
        return Packet.packetInstance((Element)elem);
    }
}

