/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.db.DBInitException;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.JDBCMsgRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.OfflineMessages;
import tigase.xmpp.impl.ProcessorTestCase;

public class OfflineMessagesTest
extends ProcessorTestCase {
    private OfflineMessages offlineProcessor;
    private MsgRepositoryIfcImpl msgRepo;

    @Override
    @Before
    public void setUp() throws Exception {
        this.msgRepo = new MsgRepositoryIfcImpl();
        this.offlineProcessor = new OfflineMessages(){

            protected MsgRepositoryIfc getMsgRepoImpl(NonAuthUserRepository repo, XMPPResourceConnection conn) {
                return OfflineMessagesTest.this.msgRepo;
            }
        };
        this.offlineProcessor.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.offlineProcessor = null;
        this.msgRepo = null;
        super.tearDown();
    }

    @Test
    public void testStorageOfflineMessageForBareJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", userJid.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("body", "Test message"));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"no message stored, while it should be stored", (!this.msgRepo.getStored().isEmpty() ? 1 : 0) != 0);
        this.msgRepo.getStored().clear();
        session1.setPriority(1);
        results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"no message stored, while it should be stored", (!this.msgRepo.getStored().isEmpty() ? 1 : 0) != 0);
        this.msgRepo.getStored().clear();
        session1.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"message stored, while it should not be stored", (boolean)this.msgRepo.getStored().isEmpty());
        this.msgRepo.getStored().clear();
    }

    @Test
    public void testStorageOfflineMessageForFullJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", res2.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("body", "Test message"));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"message stored, while it should not be stored", (boolean)this.msgRepo.getStored().isEmpty());
        this.msgRepo.getStored().clear();
        session1.setPriority(1);
        results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"message stored, while it should not be stored", (boolean)this.msgRepo.getStored().isEmpty());
        this.msgRepo.getStored().clear();
        session1.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.offlineProcessor.postProcess(packet, session1, null, results, null);
        Assert.assertTrue((String)"generated result even than no result should be generated", (boolean)results.isEmpty());
        Assert.assertTrue((String)"message stored, while it should not be stored", (boolean)this.msgRepo.getStored().isEmpty());
        this.msgRepo.getStored().clear();
    }

    @Test
    public void testRestorePacketForOffLineUser() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Assert.assertEquals(Arrays.asList(session1), (Object)session1.getActiveSessions());
        Element packetEl = new Element("iq", new String[]{"type", "from", "to", "time"}, new String[]{"set", "dip1@test.com/res1", userJid.toString(), "1440810935000"});
        packetEl.addChild((XMLNodeIfc)new Element("jingle", new String[]{"action", "sid", "offline", "xmlns"}, new String[]{"session-terminate", UUID.randomUUID().toString(), "true", "urn:xmpp:jingle:1"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        this.msgRepo.storeMessage(packet.getFrom(), packet.getTo(), null, packet.getElement(), null);
        packetEl = new Element("iq", new String[]{"type", "from", "to", "time"}, new String[]{"set", "dip1@test.com/res1", userJid.toString(), "1440810972000"});
        packetEl.addChild((XMLNodeIfc)new Element("jingle", new String[]{"action", "sid", "offline", "xmlns"}, new String[]{"session-terminate", UUID.randomUUID().toString(), "true", "urn:xmpp:jingle:1"}));
        packet = Packet.packetInstance((Element)packetEl);
        this.msgRepo.storeMessage(packet.getFrom(), packet.getTo(), null, packet.getElement(), null);
        Assert.assertTrue((String)"no message stored, while it should be stored", (!this.msgRepo.getStored().isEmpty() ? 1 : 0) != 0);
        Queue restorePacketForOffLineUser = this.offlineProcessor.restorePacketForOffLineUser(session1, (MsgRepositoryIfc)this.msgRepo);
        Assert.assertEquals((String)"number of restored messages differ!", (long)restorePacketForOffLineUser.size(), (long)2L);
        this.msgRepo.getStored().clear();
    }

    @Test
    public void testLoadOfflineMessages() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element presenceEl = new Element("presence", new String[]{"from", "to"}, new String[]{res1.toString(), res2.toString()});
        Packet packet = Packet.packetInstance((Element)presenceEl);
        Assert.assertFalse((boolean)this.offlineProcessor.loadOfflineMessages(packet, session1));
        presenceEl = new Element("presence", new String[]{"from"}, new String[]{res1.toString()});
        packet = Packet.packetInstance((Element)presenceEl);
        Assert.assertTrue((boolean)this.offlineProcessor.loadOfflineMessages(packet, session1));
    }

    @Test
    public void testIsAllowedForOfflineStorage() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "Test message")}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertTrue((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("storeMe1", new String[]{"xmlns"}, new String[]{"custom_xmlns"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertFalse((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        HashMap<String, String[]> settings = new HashMap<String, String[]>();
        settings.put("msg-store-offline-paths", new String[]{"/message/storeMe1[custom_xmlns]", "/message/storeMe2", "-/message/noStore1"});
        this.offlineProcessor.init(settings);
        Assert.assertTrue((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("storeMe2", new String[]{"xmlns"}, new String[]{"custom_xmlns"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertTrue((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("storeMe3", new String[]{"xmlns"}, new String[]{"custom_xmlns"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertFalse((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "Test message 123"), new Element("no-store", new String[]{"xmlns"}, new String[]{"urn:xmpp:hints"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertFalse((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("noStore1"), new Element("body", "body of message")}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertFalse((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "body of message")}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        Assert.assertTrue((boolean)this.offlineProcessor.isAllowedForOfflineStorage(packet));
    }

    private static class MsgRepositoryIfcImpl
    implements MsgRepositoryIfc {
        private final Queue<Packet> stored = new ArrayDeque<Packet>();
        JDBCMsgRepository jdbcMsgRepository = null;

        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
            if (this.jdbcMsgRepository != null) {
                return this.jdbcMsgRepository.loadMessagesToJID(session, delete);
            }
            LinkedList<Element> res = new LinkedList<Element>();
            for (Packet pac : this.stored) {
                res.add(pac.getElement());
            }
            return res;
        }

        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
            if (this.jdbcMsgRepository != null) {
                return this.jdbcMsgRepository.storeMessage(from, to, expired, msg, userRepo);
            }
            return this.stored.offer(Packet.packetInstance((Element)msg, (JID)from, (JID)to));
        }

        public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        }

        public Queue<Packet> getStored() {
            return this.stored;
        }
    }
}

