/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.ProcessorTestCase;

public class MessageTest
extends ProcessorTestCase {
    private Message messageProcessor;

    @Override
    @Before
    public void setUp() throws Exception {
        this.messageProcessor = new Message();
        this.messageProcessor.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.messageProcessor = null;
        super.tearDown();
    }

    @Test
    public void testSilentlyIgnoringMessages() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        Element packetEl = new Element("message", new String[]{"from", "to"}, new String[]{"remote-user@test.com/res1", res1.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.messageProcessor.process(packet, null, null, results, null);
        Assert.assertTrue((String)"no error was generated", (!results.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"generated result is not an error", (boolean)((Packet)results.poll()).getType().equals((Object)StanzaType.error));
        results.clear();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("silently-ignore-message", "true");
        this.messageProcessor.init(settings);
        this.messageProcessor.process(packet, null, null, results, null);
        Assert.assertTrue((String)"result was generated", (boolean)results.isEmpty());
    }

    @Test
    public void testResourceSelectionForMessageDeliveryMethods() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(res1, res1);
        XMPPResourceConnection session2 = this.getSession(res2, res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Assert.assertEquals(Collections.emptyList(), (Object)this.messageProcessor.getConnectionsForMessageDelivery(session1));
        Assert.assertFalse((String)"found XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        session1.setPriority(1);
        Assert.assertFalse((String)"found XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        session1.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        Assert.assertEquals(Arrays.asList(session1), (Object)this.messageProcessor.getConnectionsForMessageDelivery(session2));
        session2.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)this.messageProcessor.getConnectionsForMessageDelivery(session2));
    }

    @Test
    public void testResourceSelectionForMessageDeliveryForBareJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Assert.assertEquals(Collections.emptyList(), (Object)this.messageProcessor.getConnectionsForMessageDelivery(session1));
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", userJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque<Object> results = new ArrayDeque<Packet>();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertTrue((String)"generated result even than no resource had nonnegative priority", (boolean)results.isEmpty());
        session1.setPriority(1);
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertTrue((String)"generated result even than no resource had nonnegative priority", (boolean)results.isEmpty());
        session1.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"not generated result even than 1 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId()), this.collectPacketTo(results));
        session2.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 2 resource had nonnegative priority", (long)2L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId(), session2.getConnectionId()), this.collectPacketTo(results));
    }

    @Test
    public void testResourceSelectionForMessageDeliveryForFullJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Assert.assertEquals(Collections.emptyList(), (Object)this.messageProcessor.getConnectionsForMessageDelivery(session1));
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", res1.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque<Object> results = new ArrayDeque<Packet>();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"not generated result even than no resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId()), this.collectPacketTo(results));
        session1.setPriority(1);
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"not generated result even than no resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId()), this.collectPacketTo(results));
        session1.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"not generated result even than 1 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId()), this.collectPacketTo(results));
        session2.setPresence(new Element("presence"));
        Assert.assertTrue((String)"could not find XMPPResourceConnection for delivery of message", (boolean)this.messageProcessor.hasConnectionForMessageDelivery(session1));
        results = new ArrayDeque();
        this.messageProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 2 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session1.getConnectionId()), this.collectPacketTo(results));
    }

    protected List<JID> collectPacketTo(Queue<Packet> packets) {
        Packet p;
        ArrayList<JID> result = new ArrayList<JID>();
        while ((p = packets.poll()) != null) {
            result.add(p.getPacketTo());
        }
        return result;
    }
}

