/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Arrays;
import junit.framework.TestCase;
import org.junit.Assert;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class VHostItemTest
extends TestCase {
    public void testVHostItem() throws TigaseStringprepException {
        VHostItemTest.assertEquals((Object)new VHostItem("lowercase.com"), (Object)new VHostItem("lowercase.com"));
        VHostItemTest.assertEquals((Object)new VHostItem("CAPITAL.COM"), (Object)new VHostItem("capital.com"));
        VHostItemTest.assertNotSame((Object)new VHostItem("CAPITAL.COM"), (Object)new VHostItem("lowercase.com"));
    }

    public void testVHostDomainPolicy() throws TigaseStringprepException {
        VHostItem vHostItem = new VHostItem();
        vHostItem.initFromPropertyString("domain1:domain-filter=LOCAL:max-users=1000");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.LOCAL, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((vHostItem.getDomainFilterDomains() == null ? 1 : 0) != 0);
        vHostItem = new VHostItem();
        vHostItem.initFromPropertyString("domain1:domain-filter=LIST=domain1;domain2;domain3:max-users=1000");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.LIST, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain1"));
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain3"));
        VHostItemTest.assertFalse((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain5"));
        vHostItem = new VHostItem();
        Element el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "ALL", "domain1;domain2;domain3"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.ALL, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((vHostItem.getDomainFilterDomains() == null ? 1 : 0) != 0);
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=ALL"));
        vHostItem = new VHostItem();
        el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "BLACKLIST", "domain1;domain2;domain3"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.BLACKLIST, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain1"));
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain3"));
        VHostItemTest.assertFalse((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain5"));
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=BLACKLIST"));
        vHostItem = new VHostItem();
        el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "CUSTOM", "4,deny,all;1,allow,self;3,allow,jid,pubsub@test.com;2,allow,jid,admin@test2.com"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.CUSTOM, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=CUSTOM=4,deny,all;1,allow,self;3,allow,jid,pubsub@test.com;2,allow,jid,admin@test2.com"));
        vHostItem = new VHostItem();
        vHostItem.initFromPropertyString("domain1:domain-filter=CUSTOM=4|deny|all;1|allow|self;3|allow|jid|pubsub@test.com;2|allow|jid|admin@test2.com");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.CUSTOM, (Object)vHostItem.getDomainFilter());
        String toPropertyString = vHostItem.toPropertyString();
        System.out.println("to property string: " + toPropertyString);
        VHostItemTest.assertTrue((String)"different", (boolean)toPropertyString.contains("domain-filter=CUSTOM=4|deny|all;1|allow|self;3|allow|jid|pubsub@test.com;2|allow|jid|admin@test2.com"));
    }

    public void testInitFromPropertyString() throws TigaseStringprepException {
        JID jid = JID.jidInstanceNS((String)"comp1@example.com");
        JID notTrusted = JID.jidInstanceNS((String)"not-trusted@example.com");
        VHostItem item = new VHostItem();
        item.toString();
        Assert.assertNull((Object)item.getTrustedJIDs());
        Assert.assertFalse((boolean)item.isTrustedJID(jid));
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString()}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItem();
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com,comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItem();
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com;comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItem();
        item.toString();
        item.initFromPropertyString("example.com:trusted-jids=example.com");
        item.toString();
        Assert.assertArrayEquals((Object[])new String[]{"example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertTrue((boolean)item.isTrustedJID(notTrusted));
        System.setProperty("trusted", "comp3@example.com,comp4@example.com");
        VHostItem.initGlobalTrustedJids();
        item = new VHostItem();
        item.toString();
        Assert.assertArrayEquals((Object[])new String[]{"comp3@example.com", "comp4@example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com")));
        Assert.assertTrue((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com").copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com;comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        Assert.assertFalse((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com")));
    }
}

