/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.NonAuthUserRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.disteventbus.EventBus;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.EventHandler;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.util.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;

@Id(value="presence-offline")
@Handles(value={@Handle(path={"presence"}, xmlns="jabber:client"), @Handle(path={"iq", "query"}, xmlns="jabber:iq:roster")})
public class PresenceOffline
extends PresenceAbstract
implements XMPPStopListenerIfc {
    public static final String PRESENCE_REPO_CLASS_PROP_KEY = "presence-repo-class";
    public static final String PRESENCE_REPO_URI_PROP_KEY = "presence-repo-uri";
    public static final String CACHE_SIZE_PROP_KEY = "cache-size";
    private final int cacheSizeDef = 1000;
    private static final Logger log = Logger.getLogger(PresenceOffline.class.getCanonicalName());
    protected static final String ID = "presence-offline";
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final EnumSet<StanzaType> PRESENCE_SUB_CHANGE_TYPES = EnumSet.of(StanzaType.subscribed, StanzaType.unsubscribe, StanzaType.unsubscribed);
    private final String presenceSessionEventName = "start-stop";
    private UserRepository userRepository = null;
    private LRUConcurrentCache<BareJID, Element> presenceCache = null;
    private LRUConcurrentCache<BareJID, Map<BareJID, RosterElement>> rosterCache = null;
    private static final String LAST_OFFLINE_PRESENCE_KEY = "last-offline-presence";
    private static final String DELAY_STAMP_KEY = "delay-stamp";
    private static final String EVENTBUS_PRESENCE_SESSION_XMLNS = "tigase:user:presence-session";
    private final EventBus eventBus = EventBusFactory.getInstance();
    private final UserPresenceSessionEventHandler userPresenceSessionEventHandler = new UserPresenceSessionEventHandler();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    boolean delayStamp = true;

    public PresenceOffline() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        PresenceAbstract.initSettings(settings);
        String tmp = (String)settings.get(DELAY_STAMP_KEY);
        this.delayStamp = tmp != null ? Boolean.parseBoolean(tmp) : this.delayStamp;
        log.log(Level.CONFIG, "Adding offline presence delay stamp to: {0}", this.delayStamp);
        this.presenceCache = new LRUConcurrentCache(10000);
        this.rosterCache = new LRUConcurrentCache(10000);
        String repo_uri = (String)settings.get(PRESENCE_REPO_URI_PROP_KEY);
        String repo_cls = (String)settings.get(PRESENCE_REPO_CLASS_PROP_KEY);
        if (repo_uri == null && (repo_uri = System.getProperty(PRESENCE_REPO_URI_PROP_KEY)) == null) {
            repo_uri = System.getProperty("user-db-uri");
        }
        if (repo_cls == null) {
            repo_cls = System.getProperty(PRESENCE_REPO_CLASS_PROP_KEY);
        }
        if (repo_uri != null) {
            HashMap<String, String> db_props = new HashMap<String, String>(4);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                db_props.put(entry.getKey(), entry.getValue().toString());
            }
            try {
                this.userRepository = RepositoryFactory.getUserRepository(repo_cls, repo_uri, db_props);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | DBInitException ex) {
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
        int cacheSize = 1000;
        String cacheSizeStr = (String)settings.get(CACHE_SIZE_PROP_KEY);
        if (cacheSizeStr != null) {
            try {
                cacheSize = Integer.parseInt(cacheSizeStr);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Using default cache value: " + cacheSize, e);
            }
        }
        this.presenceCache = new LRUConcurrentCache(cacheSize);
        this.rosterCache = new LRUConcurrentCache(cacheSize);
        this.eventBus.addHandler("start-stop", EVENTBUS_PRESENCE_SESSION_XMLNS, this.userPresenceSessionEventHandler);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if ("presence".equals(packet.getElemName())) {
            if (session == null && packet.getType() == StanzaType.probe && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && !packet.getStanzaFrom().equals(packet.getStanzaTo())) {
                BareJID stanzaFrom;
                BareJID stanzaTo = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
                BareJID bareJID = stanzaFrom = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing presence probe {0} to offline user: {1}", new Object[]{packet, packet.getStanzaTo()});
                }
                if (stanzaTo != null && stanzaFrom != null && this.isSubscriptionValid(stanzaTo, stanzaFrom)) {
                    Element presence = this.presenceCache.get(stanzaTo);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Retrieved presence from cache: {0}", presence);
                    }
                    if (presence == null) {
                        presence = this.loadPresenceFromRepo(stanzaTo);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Retrieved presence from respository: {0}", presence);
                        }
                    }
                    if (presence != null) {
                        try {
                            Packet p = Packet.packetInstance(presence.clone());
                            p.initVars(p.getStanzaFrom(), packet.getStanzaFrom());
                            results.offer(p);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.WARNING, "Error creating packet instance from presence: " + presence, ex);
                        }
                    }
                }
            } else if (session != null && packet.getStanzaFrom() != null) {
                if (PRESENCE_SUB_CHANGE_TYPES.contains((Object)packet.getType())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Presence sub change - sending event to cleare cache {0}", packet.getElement());
                    }
                    this.sendEvent("roster", packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null, packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null);
                } else if (session.isUserId(packet.getStanzaFrom().getBareJID()) && (packet.getType() == null || packet.getType() == StanzaType.available)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Presence session: {0} started - sending event and removing data from repository, packet: ", new Object[]{session, packet});
                    }
                    this.sendEvent("presence", session.getJID().getBareJID());
                    try {
                        this.userRepository.removeData(packet.getStanzaFrom().getBareJID(), LAST_OFFLINE_PRESENCE_KEY);
                    }
                    catch (TigaseDBException ex) {
                        log.log(Level.WARNING, "Error removing data from repository while starting new presence session", ex);
                    }
                }
            }
        } else if (packet.getType() == StanzaType.set && packet.getElement().getXMLNSStaticStr(Iq.IQ_QUERY_PATH) == "jabber:iq:roster") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Roster change - updated roster cache, packet: {0}", packet);
            }
            if (packet.getStanzaFrom() != null) {
                BareJID user = packet.getStanzaFrom().getBareJID();
                this.sendEvent("roster", user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || !session.isAuthorized()) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            Element lastPresence;
            this.sendEvent("presence", session.getjid().getBareJID());
            Element element = lastPresence = session.getPresence() != null ? session.getPresence().clone() : null;
            if (lastPresence != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session: {0} stopped, storing to repository last presence: {1}", new Object[]{session, lastPresence});
                }
                if (this.delayStamp) {
                    String stamp = null;
                    SimpleDateFormat simpleDateFormat = this.formatter;
                    synchronized (simpleDateFormat) {
                        stamp = this.formatter.format(new Date());
                    }
                    if (stamp != null) {
                        Element x = new Element("delay", new String[]{"stamp", "xmlns"}, new String[]{stamp, "urn:xmpp:delay"});
                        lastPresence.addChild(x);
                    }
                }
                if (!StanzaType.unavailable.toString().equals(lastPresence.getAttributeStaticStr("type"))) {
                    lastPresence.setAttribute("type", StanzaType.unavailable.toString());
                }
                try {
                    this.userRepository.setData(session.getjid().getBareJID(), LAST_OFFLINE_PRESENCE_KEY, lastPresence.toString());
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Error storing last offline presence to repository: " + lastPresence, ex);
                }
            }
        }
    }

    protected boolean isNotOnlySession(XMPPResourceConnection session) {
        if (TigaseRuntime.getTigaseRuntime().hasCompleteJidsInfo() && session != null) {
            JID[] connectionIdsForJid;
            JID userJID = session.getjid();
            if (TigaseRuntime.getTigaseRuntime().isJidOnline(userJID) && (connectionIdsForJid = TigaseRuntime.getTigaseRuntime().getConnectionIdsForJid(userJID)) != null && connectionIdsForJid.length > 0 && (connectionIdsForJid.length != 1 || !connectionIdsForJid[0].equals(userJID))) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "There are other user {0} sessions still active: {1}", new Object[]{session.getjid(), Arrays.asList(connectionIdsForJid)});
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isSubscriptionValid(BareJID owner, BareJID contact) {
        RosterAbstract.SubscriptionType buddy_subscr = null;
        Map<BareJID, RosterElement> roster = null;
        boolean result = false;
        roster = this.rosterCache.get(owner);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Checking user {0} subscription of {1}, present in cache: {2}", new Object[]{owner, contact, roster != null});
        }
        if (roster == null) {
            String rosterString = null;
            try {
                rosterString = this.userRepository.getData(owner, "roster");
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Problem reading roster from DB: ", ex);
            }
            if (rosterString != null) {
                roster = new ConcurrentHashMap<BareJID, RosterElement>(100, 0.25f, 1);
                RosterFlat.parseRosterUtil(rosterString, roster, null);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Loaded roster from DB: {0}", roster);
                }
            }
        }
        if (roster != null) {
            RosterElement rosterElement = roster.get(contact);
            buddy_subscr = rosterElement.getSubscription();
            if (buddy_subscr == null) {
                buddy_subscr = RosterAbstract.SubscriptionType.none;
            }
            result = this.roster_util.isSubscribedFrom(buddy_subscr);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "isSubscriptionValid, owner: {0}, contact: {1}, result: {2}", new Object[]{owner, contact, result});
        }
        return result;
    }

    protected Element loadPresenceFromRepo(BareJID stanzaTo) {
        Element presence = null;
        try {
            String presString = this.userRepository.getData(stanzaTo, LAST_OFFLINE_PRESENCE_KEY);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            Queue<Element> parsedElements = null;
            if (presString != null) {
                char[] data = presString.toCharArray();
                this.parser.parse(domHandler, data, 0, data.length);
                parsedElements = domHandler.getParsedElements();
            }
            if (parsedElements != null && parsedElements.size() > 0) {
                presence = (Element)parsedElements.poll();
                this.presenceCache.put(stanzaTo, presence);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Loaded presence: {0} and stored it in cache", presence);
                }
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Loading presence from repository failed!", ex);
        }
        return presence;
    }

    private void sendEvent(String action, BareJID ... user) {
        if (user != null && user.length > 0) {
            Element event = new Element("start-stop", new String[]{"xmlns"}, new String[]{EVENTBUS_PRESENCE_SESSION_XMLNS});
            for (BareJID bareJID : user) {
                if (bareJID == null) continue;
                Element jidElement = new Element("jid", bareJID.toString());
                jidElement.addAttribute("action", action);
                event.addChild(jidElement);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending event: " + event);
            }
            this.eventBus.fire(event);
        }
    }

    private class LRUConcurrentCache<K, V> {
        private final Map<K, V> cache;

        public LRUConcurrentCache(final int maxEntries) {
            this.cache = new LinkedHashMap<K, V>(maxEntries, 0.75f, true){
                private static final long serialVersionUID = -1236481390177598762L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > maxEntries;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            Map<K, V> map = this.cache;
            synchronized (map) {
                this.cache.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            Map<K, V> map = this.cache;
            synchronized (map) {
                return this.cache.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V remove(K key) {
            Map<K, V> map = this.cache;
            synchronized (map) {
                return this.cache.remove(key);
            }
        }

        public int size() {
            return this.cache.size();
        }

        public String toString() {
            return "LRUConcurrentCache{cache=" + this.cache + '}';
        }
    }

    private class UserPresenceSessionEventHandler
    implements EventHandler {
        private final String[] JID_PATH = new String[]{"start-stop"};

        private UserPresenceSessionEventHandler() {
        }

        @Override
        public void onEvent(String name, String xmlns, Element event) {
            if (!"start-stop".equals(name) || !PresenceOffline.EVENTBUS_PRESENCE_SESSION_XMLNS.equals(xmlns)) {
                return;
            }
            List<Element> jidElements = event.getChildrenStaticStr(this.JID_PATH);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Procesing userPresence event: {0} with following jids: {1}", new Object[]{event, jidElements});
            }
            if (jidElements != null && !jidElements.isEmpty()) {
                for (Element jidElement : jidElements) {
                    String jidStr = jidElement != null ? jidElement.getCData() : null;
                    if (jidStr == null || jidElement == null) continue;
                    BareJID jid = BareJID.bareJIDInstanceNS(jidStr);
                    String actionStr = jidElement.getAttributeStaticStr("action");
                    if (actionStr == null) continue;
                    switch (actionStr) {
                        case "presence": {
                            PresenceOffline.this.presenceCache.remove(jid);
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "Clearing presence cache: {0}, remaining items: {1}", new Object[]{jidStr, PresenceOffline.this.presenceCache.size()});
                            break;
                        }
                        case "roster": {
                            PresenceOffline.this.rosterCache.remove(jid);
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "Clearing roster cache: {0}, remaining items: {1}", new Object[]{jidStr, PresenceOffline.this.rosterCache.size()});
                        }
                    }
                }
            }
        }
    }
}

