/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.amp.MsgRepository;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.OfflineMessages;

public class FlexibleOfflineMessageRetrieval
extends XMPPProcessorAbstract
implements XMPPProcessorIfc {
    public static final String FLEXIBLE_OFFLINE_XMLNS = "http://jabber.org/protocol/offline";
    private static final Logger log = Logger.getLogger(FlexibleOfflineMessageRetrieval.class.getName());
    private static final String OFFLINE_ELEMENT_NAME = "offline";
    private static final String ITEM_ACTION_ATTRIBUTE = "action";
    public static final String ITEM_ELEMENT_NAME = "item";
    public static final String NODE_ATTRIBUTE_NAME = "node";
    private static final String PURGE_ELEMENT_NAME = "purge";
    private static final String FETCH_ELEMENT_NAME = "fetch";
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/offline"};
    private static final String[] IQ_OFFLINE = new String[]{"iq", "offline"};
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH, IQ_OFFLINE};
    private static final String ID = "http://jabber.org/protocol/offline";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/offline"})};
    public static final String[] MESSAGE_EVENT_PATH = new String[]{"message", "event"};
    public static final String[] MESSAGE_HEADER_PATH = new String[]{"message", "header"};
    private static final Element identity = new Element("identity", new String[]{"category", "type"}, new String[]{"automation", "message-list"});
    private static final Element feature = new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/offline"});
    private static final String form_type = "FORM_TYPE";
    private static final String NUMBER_OF_ = "number_of_";
    private MsgRepository msg_repo = null;
    private final OfflineMessages offlineProcessor = new OfflineMessages();
    private final MsgRepository.OfflineMessagesProcessor offlineMessagesStamper = new MsgStamper();

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        if (packet.isServiceDisco()) {
            String node;
            if (packet.getStanzaTo() == null && "http://jabber.org/protocol/offline".equals(node = packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, NODE_ATTRIBUTE_NAME))) {
                return Authorization.AUTHORIZED;
            }
            return null;
        }
        return super.canHandle(packet, conn);
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        String msg_repo_uri = (String)settings.get("amp-repo-uri");
        String msg_repo_cls = (String)settings.get("amp-repo-class");
        if (msg_repo_uri == null && (msg_repo_uri = System.getProperty("amp-repo-uri")) == null) {
            msg_repo_uri = System.getProperty("user-db-uri");
        }
        if (msg_repo_cls == null) {
            msg_repo_cls = System.getProperty("amp-repo-class");
        }
        if (msg_repo_uri != null) {
            HashMap<String, String> db_props = new HashMap<String, String>(4);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                db_props.put(entry.getKey(), entry.getValue().toString());
            }
            try {
                this.msg_repo = (MsgRepository)MsgRepository.getInstance(msg_repo_cls, msg_repo_uri);
                this.msg_repo.initRepository(msg_repo_uri, db_props);
            }
            catch (TigaseDBException ex) {
                this.msg_repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
    }

    @Override
    public String id() {
        return "http://jabber.org/protocol/offline";
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        Element query = packet.getElement().findChildStaticStr(Iq.IQ_QUERY_PATH);
        Element offlineElement = packet.getElement().findChildStaticStr(IQ_OFFLINE);
        if (null != query) {
            query = query.clone();
            String queryXmlns = query.getXMLNS();
            String node = query.getAttributeStaticStr(NODE_ATTRIBUTE_NAME);
            if (node != null && node.equals("http://jabber.org/protocol/offline")) {
                session.putCommonSessionData("http://jabber.org/protocol/offline", "http://jabber.org/protocol/offline");
            }
            if (node != null && queryXmlns != null) {
                switch (queryXmlns) {
                    case "http://jabber.org/protocol/disco#info": {
                        this.addDiscoInfo(session, query);
                        break;
                    }
                    case "http://jabber.org/protocol/disco#items": {
                        this.addDiscoItems(session, query);
                    }
                }
                results.offer(packet.okResult(query, 0));
            }
        } else if (null != offlineElement) {
            List<Element> offlineElementChildren = offlineElement.getChildren();
            LinkedList<Element> itemChildren = new LinkedList<Element>();
            boolean fetch = false;
            boolean purge = false;
            for (Element child : offlineElementChildren) {
                String name = child.getName();
                switch (name) {
                    case "item": {
                        itemChildren.add(child);
                        break;
                    }
                    case "purge": {
                        purge = true;
                        break;
                    }
                    case "fetch": {
                        fetch = true;
                    }
                }
            }
            if (itemChildren.isEmpty() && (purge || fetch)) {
                try {
                    if (fetch && !purge) {
                        Queue<Packet> restorePacketForOffLineUser = this.restorePacketForOffLineUser(null, session, this.msg_repo);
                        results.addAll(restorePacketForOffLineUser);
                    } else if (purge && !fetch) {
                        this.msg_repo.deleteMessagesToJID(null, session);
                    }
                }
                catch (UserNotFoundException | NotAuthorizedException ex) {
                    log.log(Level.WARNING, "Problem retrieving messages from repository: ", ex);
                }
                results.offer(packet.okResult(query, 0));
            } else if (offlineElementChildren.size() == itemChildren.size()) {
                LinkedList<String> itemsView = new LinkedList<String>();
                LinkedList<String> itemsRemove = new LinkedList<String>();
                for (Element item : itemChildren) {
                    String actionString = item.getAttributeStaticStr(ITEM_ACTION_ATTRIBUTE);
                    ACTION action = ACTION.valueOf(actionString.toLowerCase());
                    switch (action) {
                        case view: {
                            itemsView.add(item.getAttributeStaticStr(NODE_ATTRIBUTE_NAME));
                            break;
                        }
                        case remove: {
                            itemsRemove.add(item.getAttributeStaticStr(NODE_ATTRIBUTE_NAME));
                        }
                    }
                }
                try {
                    Packet err;
                    if (!itemsView.isEmpty() && itemsRemove.isEmpty()) {
                        Queue<Packet> restorePacketForOffLineUser = this.restorePacketForOffLineUser(itemsView, session, this.msg_repo);
                        if (restorePacketForOffLineUser != null & !restorePacketForOffLineUser.isEmpty()) {
                            results.addAll(restorePacketForOffLineUser);
                            results.offer(packet.okResult(query, 0));
                        } else {
                            err = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Requested item was not found", true);
                            results.offer(err);
                        }
                    } else if (itemsView.isEmpty() && !itemsRemove.isEmpty()) {
                        int deleteMessagesToJID = this.msg_repo.deleteMessagesToJID(itemsRemove, session);
                        if (deleteMessagesToJID == 0) {
                            err = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Requested item was not found", true);
                            results.offer(err);
                        } else {
                            results.offer(packet.okResult(query, 0));
                        }
                    } else {
                        Packet err2 = Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "All query items should have same action", true);
                        results.offer(err2);
                    }
                }
                catch (UserNotFoundException | NotAuthorizedException ex) {
                    log.log(Level.WARNING, "Problem retrieving messages from repository: ", ex);
                }
            }
        }
    }

    private void addDiscoInfo(XMPPResourceConnection session, Element query) {
        try {
            Map<Enum, Long> messagesCount = this.msg_repo.getMessagesCount(session.getJID());
            if (messagesCount != null && !messagesCount.isEmpty()) {
                query.addChild(identity);
                query.addChild(feature);
                DataForm.addDataForm(query, Command.DataType.result);
                DataForm.addHiddenField(query, form_type, "http://jabber.org/protocol/offline");
                for (Map.Entry<Enum, Long> entrySet : messagesCount.entrySet()) {
                    DataForm.addFieldValue(query, NUMBER_OF_ + entrySet.getKey(), entrySet.getValue().toString());
                }
            }
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.WARNING, "Problem retrieving messages from repository: ", ex);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    private void addDiscoItems(XMPPResourceConnection session, Element query) {
        try {
            List<Element> messagesList = this.msg_repo.getMessagesList(session.getJID());
            if (null != messagesList && !messagesList.isEmpty()) {
                query.addChildren(messagesList);
            }
        }
        catch (UserNotFoundException | NotAuthorizedException ex) {
            log.log(Level.WARNING, "Problem retrieving messages from repository: ", ex);
        }
    }

    public Queue<Packet> restorePacketForOffLineUser(List<String> db_ids, XMPPResourceConnection conn, MsgRepository repo) throws UserNotFoundException, NotAuthorizedException {
        Queue<Element> elems = repo.loadMessagesToJID(db_ids, conn, false, this.offlineMessagesStamper);
        if (elems != null) {
            LinkedList<Packet> pacs = new LinkedList<Packet>();
            Element elem = null;
            while ((elem = elems.poll()) != null) {
                try {
                    Packet packetInstance = Packet.packetInstance(elem);
                    if (packetInstance.getElemName() == "iq") {
                        packetInstance.initVars(packetInstance.getStanzaFrom(), conn.getJID());
                    } else {
                        packetInstance.setPacketTo(conn.getConnectionId());
                    }
                    pacs.offer(packetInstance);
                }
                catch (TigaseStringprepException | NoConnectionIdException ex) {
                    log.warning("Packet addressing problem, stringprep failed: " + elem);
                }
            }
            try {
                Collections.sort(pacs, new OfflineMessages.StampComparator());
            }
            catch (NullPointerException e) {
                try {
                    log.warning("Can not sort off line messages: " + pacs + ",\n" + e);
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "Can not print log message.", exc);
                }
            }
            return pacs;
        }
        return null;
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private static class MsgStamper
    implements MsgRepository.OfflineMessagesProcessor {
        public static Element offlineElementIns = new Element("offline", new Element[]{new Element("item")}, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/offline"});

        private MsgStamper() {
        }

        @Override
        public void stamp(Element msg, String msgID) {
            Element clone = offlineElementIns.clone();
            Element item = clone.getChild(FlexibleOfflineMessageRetrieval.ITEM_ELEMENT_NAME);
            item.setAttribute(FlexibleOfflineMessageRetrieval.NODE_ATTRIBUTE_NAME, msgID);
            msg.addChild(clone);
        }
    }

    private static enum ACTION {
        view,
        remove;

    }
}

