/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsProvider;
import tigase.util.DNSResolverFactory;

public class CounterDataLogger
implements StatisticsArchivizerIfc {
    public static final String BOSH_CONNS_COL = "bosh_conns";
    public static final String C2S_CONNS_COL = "c2s_conns";
    public static final String C2S_PACKETS_COL = "c2s_packets";
    public static final String CPU_USAGE_COL = "cpu_usage";
    public static final String DB_URL_PROP_KEY = "db-url";
    public static final String EXT_PACKETS_COL = "ext_packets";
    public static final String HOSTNAME_COL = "hostname";
    public static final String IQS_COL = "iqs";
    public static final String MEM_USAGE_COL = "mem_usage";
    public static final String MESSAGES_COL = "messages";
    public static final String MUC_PACKETS_COL = "muc_packets";
    public static final String PRESENCES_COL = "presences";
    public static final String PUBSUB_PACKETS_COL = "pubsub_packets";
    public static final String S2S_CONNS_COL = "s2s_conns";
    public static final String S2S_PACKETS_COL = "s2s_packets";
    public static final String SM_PACKETS_COL = "sm_packets";
    public static final String STATS_TABLE = "tig_stats_log";
    public static final String UPTIME_COL = "uptime";
    public static final String VHOSTS_COL = "vhosts";
    private static final Logger log = Logger.getLogger(CounterDataLogger.class.getName());
    protected static String defaultHostname;
    public static final String REGISTERED_COL = "registered";
    private static final String CREATE_STATS_TABLE = "create table tig_stats_log (  lid serial, ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP, hostname varchar(2049) NOT NULL, cpu_usage double precision not null default 0, mem_usage double precision not null default 0, uptime bigint not null default 0, vhosts int  not null default 0, sm_packets bigint  not null default 0, muc_packets bigint  not null default 0, pubsub_packets bigint  not null default 0, c2s_packets bigint  not null default 0, s2s_packets bigint  not null default 0, ext_packets bigint  not null default 0, presences bigint  not null default 0, messages bigint  not null default 0, iqs bigint  not null default 0, registered bigint  not null default 0, c2s_conns int  not null default 0, s2s_conns int  not null default 0, bosh_conns int  not null default 0, primary key(ts,hostname(255)))";
    private static final String DERBY_CREATE_STATS_TABLE = "create table tig_stats_log (  lid bigint generated by default as identity not null, ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP, hostname varchar(2049) NOT NULL, cpu_usage double precision not null default 0, mem_usage double precision not null default 0, uptime bigint not null default 0, vhosts int  not null default 0, sm_packets bigint  not null default 0, muc_packets bigint  not null default 0, pubsub_packets bigint  not null default 0, c2s_packets bigint  not null default 0, s2s_packets bigint  not null default 0, ext_packets bigint  not null default 0, presences bigint  not null default 0, messages bigint  not null default 0, iqs bigint  not null default 0, registered bigint  not null default 0, c2s_conns int  not null default 0, s2s_conns int  not null default 0, bosh_conns int  not null default 0, primary key(ts,hostname))";
    private static final String SQLSERVER_CREATE_STATS_TABLE = "create table tig_stats_log (  lid [bigint] IDENTITY(1,1), ts [datetime] DEFAULT  getdate(), hostname [nvarchar](2049) NOT NULL, cpu_usage double precision not null default 0, mem_usage double precision not null default 0, uptime bigint not null default 0, vhosts int  not null default 0, sm_packets bigint  not null default 0, muc_packets bigint  not null default 0, pubsub_packets bigint  not null default 0, c2s_packets bigint  not null default 0, s2s_packets bigint  not null default 0, ext_packets bigint  not null default 0, presences bigint  not null default 0, messages bigint  not null default 0, iqs bigint  not null default 0, registered bigint  not null default 0, c2s_conns int  not null default 0, s2s_conns int  not null default 0, bosh_conns int  not null default 0, primary key(ts,hostname))";
    private static final String STATS_INSERT_QUERY = "insert into tig_stats_log(cpu_usage, mem_usage, uptime, vhosts, sm_packets, muc_packets, pubsub_packets, c2s_packets, s2s_packets, ext_packets, presences, messages, iqs, registered, c2s_conns, s2s_conns, bosh_conns, hostname) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private DataRepository data_repo = null;
    private long last_c2s_packets = 0L;
    private long last_ext_packets = 0L;
    private long last_iqs = 0L;
    private long last_messages = 0L;
    private long last_muc_packets = 0L;
    private long last_presences = 0L;
    private long last_pubsub_packets = 0L;
    private long last_s2s_packets = 0L;
    private long last_sm_packets = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatsLogEntry(float cpu_usage, float mem_usage, long uptime, int vhosts, long sm_packets, long muc_packets, long pubsub_packets, long c2s_packets, long s2s_packets, long ext_packets, long presences, long messages, long iqs, long registered, int c2s_conns, int s2s_conns, int bosh_conns) {
        try {
            PreparedStatement insert_stats;
            PreparedStatement preparedStatement = insert_stats = this.data_repo.getPreparedStatement(null, STATS_INSERT_QUERY);
            synchronized (preparedStatement) {
                insert_stats.setFloat(1, cpu_usage >= 0.0f ? cpu_usage : 0.0f);
                insert_stats.setFloat(2, mem_usage);
                insert_stats.setLong(3, uptime);
                insert_stats.setInt(4, vhosts);
                insert_stats.setLong(5, sm_packets);
                insert_stats.setLong(6, muc_packets);
                insert_stats.setLong(7, pubsub_packets);
                insert_stats.setLong(8, c2s_packets);
                insert_stats.setLong(9, s2s_packets);
                insert_stats.setLong(10, ext_packets);
                insert_stats.setLong(11, presences);
                insert_stats.setLong(12, messages);
                insert_stats.setLong(13, iqs);
                insert_stats.setLong(14, registered);
                insert_stats.setInt(15, c2s_conns);
                insert_stats.setInt(16, s2s_conns);
                insert_stats.setInt(17, bosh_conns);
                insert_stats.setString(18, defaultHostname);
                insert_stats.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    @Override
    public void execute(StatisticsProvider sp) {
        long c2s_packets = sp.getCompPackets("c2s");
        long ext_packets = sp.getCompPackets("ext");
        long iqs = sp.getCompIqs("sess-man");
        long messages = sp.getCompMessages("sess-man");
        long muc_packets = sp.getCompPackets("muc");
        long presences = sp.getCompPresences("sess-man");
        long pubsub_packets = sp.getCompPackets("pubsub");
        long s2s_packets = sp.getCompPackets("s2s");
        long sm_packets = sp.getSMPacketsNumber();
        this.addStatsLogEntry(sp.getCPUUsage(), sp.getHeapMemUsage(), sp.getUptime(), sp.getStats("vhost-man", "Number of VHosts", 0), sm_packets - this.last_sm_packets, muc_packets - this.last_muc_packets, pubsub_packets - this.last_pubsub_packets, c2s_packets - this.last_c2s_packets, s2s_packets - this.last_s2s_packets, ext_packets - this.last_ext_packets, presences - this.last_presences, messages - this.last_messages, iqs - this.last_iqs, sp.getRegistered(), sp.getCompConnections("c2s"), sp.getCompConnections("s2s"), sp.getCompConnections("bosh"));
        this.last_c2s_packets = c2s_packets;
        this.last_ext_packets = ext_packets;
        this.last_iqs = iqs;
        this.last_messages = messages;
        this.last_muc_packets = muc_packets;
        this.last_presences = presences;
        this.last_pubsub_packets = pubsub_packets;
        this.last_s2s_packets = s2s_packets;
        this.last_sm_packets = sm_packets;
    }

    @Override
    public void init(Map<String, Object> archivizerConf) {
        defaultHostname = DNSResolverFactory.getInstance().getDefaultHost();
        try {
            String resource = (String)archivizerConf.get(DB_URL_PROP_KEY);
            if (resource == null) {
                resource = System.getProperty("user-db-uri");
            }
            this.initRepository(resource, null);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot initialize connection to database: ", ex);
        }
    }

    public void initRepository(String conn_str, Map<String, String> map) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, DBInitException {
        log.log(Level.INFO, "Initializing dbAccess for db connection url: {0}", conn_str);
        this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
        this.checkDB();
        this.data_repo.initPreparedStatement(STATS_INSERT_QUERY, STATS_INSERT_QUERY);
    }

    @Override
    public void release() {
    }

    private void checkDB() throws SQLException {
        DataRepository.dbTypes databaseType = this.data_repo.getDatabaseType();
        switch (databaseType) {
            case derby: {
                this.data_repo.checkTable(STATS_TABLE, DERBY_CREATE_STATS_TABLE);
                break;
            }
            case jtds: 
            case sqlserver: {
                this.data_repo.checkTable(STATS_TABLE, SQLSERVER_CREATE_STATS_TABLE);
                break;
            }
            default: {
                this.data_repo.checkTable(STATS_TABLE, CREATE_STATS_TABLE);
            }
        }
    }
}

