/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.BeanUtils;
import tigase.kernel.KernelException;
import tigase.kernel.Registrar;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.BeanFactory;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.BeanConfigurator;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.BeanConfigBuilder;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.RegistrarKernel;

public class Kernel {
    private final Map<BeanConfig, Object> beanInstances = new HashMap<BeanConfig, Object>();
    BeanConfigBuilder currentlyUsedConfigBuilder;
    private final DependencyManager dependencyManager = new DependencyManager();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private String name;
    private Kernel parent;

    public Kernel() {
        this("<unknown>");
    }

    public Kernel(String name) {
        this.name = name;
        BeanConfig bc = this.dependencyManager.createBeanConfig(this, "kernel", Kernel.class);
        this.dependencyManager.register(bc);
        this.registerBean("kernel").asInstance(this).exec();
        this.putBeanInstance(bc, this);
    }

    private Object createNewInstance(BeanConfig beanConfig) {
        try {
            if (beanConfig.getFactory() != null) {
                BeanFactory factory = (BeanFactory)beanConfig.getKernel().getInstance(beanConfig.getFactory());
                return factory.createInstance();
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("[" + this.getName() + "] Creating instance of bean " + beanConfig.getBeanName());
            }
            Class<?> clz = beanConfig.getClazz();
            return clz.newInstance();
        }
        catch (Exception e) {
            throw new KernelException("Can't create instance of bean '" + beanConfig.getBeanName() + "'", e);
        }
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public <T> T getInstance(BeanConfig beanConfig) {
        if (beanConfig instanceof DelegatedBeanConfig) {
            BeanConfig b = ((DelegatedBeanConfig)beanConfig).original;
            return (T)beanConfig.getKernel().beanInstances.get(b);
        }
        return (T)beanConfig.getKernel().beanInstances.get(beanConfig);
    }

    public <T> T getInstance(Class<T> beanClass) {
        return this.getInstance(beanClass, true);
    }

    protected <T> T getInstance(Class<T> beanClass, boolean allowNonExportable) {
        List<BeanConfig> bcs = this.dependencyManager.getBeanConfigs(beanClass, allowNonExportable);
        if (bcs.size() > 1) {
            throw new KernelException("Too many beans implemented class " + beanClass);
        }
        if (bcs.isEmpty() && this.parent != null && this.parent != this) {
            return this.parent.getInstance(beanClass, false);
        }
        if (bcs.isEmpty()) {
            throw new KernelException("Can't find bean implementing " + beanClass);
        }
        BeanConfig bc = bcs.get(0);
        if (bc.getState() != BeanConfig.State.initialized) {
            try {
                this.initBean(bc, new HashSet<BeanConfig>(), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KernelException(e);
            }
        }
        T result = bc.getKernel().getInstance(bc);
        return result;
    }

    public <T> T getInstance(String beanName) {
        BeanConfig bc = this.dependencyManager.getBeanConfig(beanName);
        if (bc == null && this.parent != null && this.parent.getDependencyManager().isBeanClassRegistered(beanName)) {
            return this.parent.getInstance(beanName);
        }
        if (bc == null) {
            throw new KernelException("Unknown bean '" + beanName + "'.");
        }
        if (bc.getState() != BeanConfig.State.initialized) {
            try {
                bc.getKernel().initBean(bc, new HashSet<BeanConfig>(), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KernelException(e);
            }
        }
        T result = bc.getKernel().getInstance(bc);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getNamesOf(Class<?> beanType) {
        ArrayList<String> result = new ArrayList<String>();
        List<BeanConfig> bcs = this.dependencyManager.getBeanConfigs(beanType);
        for (BeanConfig beanConfig : bcs) {
            result.add(beanConfig.getBeanName());
        }
        return Collections.unmodifiableCollection(result);
    }

    public Kernel getParent() {
        return this.parent;
    }

    public void initAll() {
        try {
            for (BeanConfig bc : this.dependencyManager.getBeanConfigs()) {
                if (bc.getState() == BeanConfig.State.initialized) continue;
                this.initBean(bc, new HashSet<BeanConfig>(), 0);
            }
        }
        catch (Exception e) {
            throw new KernelException("Can't initialize all beans", e);
        }
    }

    protected void initBean(BeanConfig tmpBC, Set<BeanConfig> createdBeansConfig, int deep) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        BeanConfigurator beanConfigurator;
        Object bean;
        BeanConfig beanConfig;
        BeanConfig beanConfig2 = beanConfig = tmpBC instanceof DelegatedBeanConfig ? ((DelegatedBeanConfig)tmpBC).original : tmpBC;
        if (beanConfig.getState() == BeanConfig.State.initialized) {
            return;
        }
        if (beanConfig.getState() == BeanConfig.State.registered) {
            beanConfig.setState(BeanConfig.State.instanceCreated);
            if (beanConfig.getFactory() != null && beanConfig.getFactory().getState() != BeanConfig.State.initialized) {
                this.initBean(beanConfig.getFactory(), new HashSet<BeanConfig>(), 0);
            }
            bean = this.createNewInstance(beanConfig);
            beanConfig.getKernel().putBeanInstance(beanConfig, bean);
            createdBeansConfig.add(beanConfig);
        } else {
            bean = beanConfig.getKernel().getInstance(beanConfig);
        }
        for (Dependency dep : beanConfig.getFieldDependencies().values()) {
            this.injectDependencies(bean, dep, createdBeansConfig, deep);
        }
        try {
            beanConfigurator = this.isBeanClassRegistered("defaultBeanConfigurator") && !beanConfig.getBeanName().equals("defaultBeanConfigurator") ? (BeanConfigurator)this.getInstance("defaultBeanConfigurator") : null;
        }
        catch (KernelException e) {
            beanConfigurator = null;
        }
        if (beanConfigurator != null) {
            beanConfigurator.configure(beanConfig, bean);
        }
        if (deep == 0) {
            for (BeanConfig bc : createdBeansConfig) {
                Object bi = bc.getKernel().getInstance(bc);
                bc.setState(BeanConfig.State.initialized);
                if (!(bi instanceof Initializable)) continue;
                ((Initializable)bi).initialize();
            }
            if (Registrar.class.isAssignableFrom(beanConfig.getClazz())) {
                RegistrarKernel k = new RegistrarKernel();
                k.setName(beanConfig.getBeanName());
                this.registerBean(beanConfig.getBeanName() + "#KERNEL").asInstance(k).exec();
                ((Registrar)bean).register(k);
            }
        }
    }

    private void inject(Object[] data, Dependency dependency, Object toBean) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object valueToSet;
        if (!dependency.isNullAllowed() && data == null) {
            throw new KernelException("Can't inject <null> to field " + dependency.getField());
        }
        if (data == null) {
            valueToSet = null;
        } else if (Collection.class.isAssignableFrom(dependency.getField().getType())) {
            AbstractCollection o = !dependency.getField().getType().isInterface() ? (HashSet<Object>)dependency.getField().getType().newInstance() : (dependency.getField().getType().isAssignableFrom(Set.class) ? new HashSet<Object>() : new ArrayList());
            o.addAll(Arrays.asList(data));
            valueToSet = o;
        } else {
            Object o;
            if (data != null && dependency.getField().getType().equals(data.getClass())) {
                o = data;
            } else {
                int l = Array.getLength(data);
                if (l > 1) {
                    throw new KernelException("Can't put many objects to single field " + dependency.getField());
                }
                o = l == 0 ? null : Array.get(data, 0);
            }
            valueToSet = o;
        }
        BeanUtils.setValue(toBean, dependency.getField(), valueToSet);
    }

    private void injectDependencies(Object bean, Dependency dep, Set<BeanConfig> createdBeansConfig, int deep) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Object[] d;
        BeanConfig[] dependentBeansConfigs = this.dependencyManager.getBeanConfig(dep);
        ArrayList dataToInject = new ArrayList();
        for (BeanConfig b : dependentBeansConfigs) {
            if (b == null) {
                dataToInject.add(null);
                continue;
            }
            if (!b.getKernel().beanInstances.containsKey(b)) {
                this.initBean(b, createdBeansConfig, deep + 1);
            }
            Object beanToInject = b.getKernel().getInstance(b);
            dataToInject.add(beanToInject);
        }
        if (dataToInject.isEmpty()) {
            d = new Object[]{};
        } else if (dep.getType() != null) {
            Object[] z = (Object[])Array.newInstance(dep.getType(), 1);
            d = dataToInject.toArray(z);
        } else {
            d = dataToInject.toArray();
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("[" + this.getName() + "] Injecting " + Arrays.toString(d) + " to " + dep.getBeanConfig() + "#" + dep);
        }
        this.inject(d, dep, bean);
    }

    void injectIfRequired(BeanConfig beanConfig) {
        try {
            Collection<Dependency> dps = this.dependencyManager.getDependenciesTo(beanConfig);
            for (Dependency dep : dps) {
                BeanConfig depbc = dep.getBeanConfig();
                if (depbc.getState() != BeanConfig.State.initialized) continue;
                if (beanConfig.getState() != BeanConfig.State.initialized) {
                    this.initBean(beanConfig, new HashSet<BeanConfig>(), 0);
                }
                Object bean = depbc.getKernel().getInstance(depbc);
                this.injectDependencies(bean, dep, new HashSet<BeanConfig>(), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KernelException("Can't inject bean " + beanConfig + " to dependend beans.", e);
        }
    }

    public boolean isBeanClassRegistered(String beanName) {
        boolean x = this.dependencyManager.isBeanClassRegistered(beanName);
        if (!x && this.parent != null) {
            x = this.parent.isBeanClassRegistered(beanName);
        }
        return x;
    }

    public void ln(String exportingBeanName, Kernel destinationKernel, String destinationName) {
        BeanConfig sbc = this.dependencyManager.getBeanConfig(exportingBeanName);
        DelegatedBeanConfig dbc = new DelegatedBeanConfig(destinationName, sbc);
        destinationKernel.dependencyManager.register(dbc);
    }

    void putBeanInstance(BeanConfig beanConfig, Object beanInstance) {
        this.beanInstances.put(beanConfig, beanInstance);
        if (beanInstance instanceof Kernel && beanInstance != this) {
            ((Kernel)beanInstance).setParent(this);
        }
        beanConfig.setState(BeanConfig.State.initialized);
    }

    public BeanConfigBuilder registerBean(Class<?> beanClass) {
        BeanConfigBuilder builder;
        if (this.currentlyUsedConfigBuilder != null) {
            throw new KernelException("Registration of bean '" + this.currentlyUsedConfigBuilder.getBeanName() + "' is not finished yet!");
        }
        Bean annotation = beanClass.getAnnotation(Bean.class);
        if (annotation == null || annotation.name() == null || annotation.name().isEmpty()) {
            throw new KernelException("Name of bean is not defined.");
        }
        this.currentlyUsedConfigBuilder = builder = new BeanConfigBuilder(this, this.dependencyManager, annotation.name());
        builder.asClass(beanClass);
        return builder;
    }

    public BeanConfigBuilder registerBean(String beanName) {
        BeanConfigBuilder builder;
        if (this.currentlyUsedConfigBuilder != null) {
            throw new KernelException("Registration of bean '" + this.currentlyUsedConfigBuilder.getBeanName() + "' is not finished yet!");
        }
        this.currentlyUsedConfigBuilder = builder = new BeanConfigBuilder(this, this.dependencyManager, beanName);
        return builder;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setParent(Kernel parent) {
        this.dependencyManager.setParent(parent.getDependencyManager());
        this.parent = parent;
    }

    public void startSubKernels() {
        for (BeanConfig bc : this.dependencyManager.getBeanConfigs(Registrar.class)) {
            Registrar r = (Registrar)this.getInstance(bc.getBeanName());
            Kernel k = (Kernel)this.getInstance(bc.getBeanName() + "#KERNEL");
            r.start(k);
            k.startSubKernels();
        }
    }

    public void unregister(String beanName) {
        BeanConfig unregisteredBeanConfig;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("[" + this.getName() + "] Unregistering bean " + beanName);
        }
        if ((unregisteredBeanConfig = this.dependencyManager.getBeanConfig(beanName)).getKernel() != this) {
            unregisteredBeanConfig.getKernel().unregister(beanName);
            return;
        }
        this.unregisterInt(beanName);
        try {
            for (BeanConfig bc : this.dependencyManager.getBeanConfigs()) {
                if (bc.getState() != BeanConfig.State.initialized) continue;
                Object ob = bc.getKernel().getInstance(bc);
                for (Dependency d : bc.getFieldDependencies().values()) {
                    if (!DependencyManager.match(d, unregisteredBeanConfig)) continue;
                    BeanConfig[] cbcs = this.dependencyManager.getBeanConfig(d);
                    if (cbcs.length == 1) {
                        this.inject(null, d, ob);
                        continue;
                    }
                    if (cbcs.length <= 1) continue;
                    this.injectDependencies(ob, d, new HashSet<BeanConfig>(), 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KernelException("Can't unregister bean", e);
        }
        finally {
            this.dependencyManager.unregister(beanName);
        }
    }

    void unregisterInt(String beanName) {
        if (this.dependencyManager.isBeanClassRegistered(beanName)) {
            BeanConfig oldBeanConfig;
            Object i;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("[" + this.getName() + "] Found registred bean " + beanName + ". Unregistering...");
            }
            if ((i = oldBeanConfig.getKernel().beanInstances.remove(oldBeanConfig = this.dependencyManager.unregister(beanName))) != null && i instanceof UnregisterAware) {
                try {
                    ((UnregisterAware)i).beforeUnregister();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.log(Level.WARNING, "Problem during unregistering bean", e);
                }
            }
        }
    }

    static class DelegatedBeanConfig
    extends BeanConfig {
        private final BeanConfig original;

        DelegatedBeanConfig(String localName, BeanConfig src) {
            super(localName, src.getClazz());
            this.original = src;
        }

        @Override
        public Class<?> getClazz() {
            return this.original.getClazz();
        }

        @Override
        public BeanConfig getFactory() {
            return this.original.getFactory();
        }

        @Override
        public Map<Field, Dependency> getFieldDependencies() {
            return this.original.getFieldDependencies();
        }

        @Override
        public Kernel getKernel() {
            return this.original.getKernel();
        }

        public BeanConfig getOriginal() {
            return this.original;
        }

        @Override
        public BeanConfig.State getState() {
            return this.original.getState();
        }

        @Override
        public boolean isExportable() {
            return this.original.isExportable();
        }

        @Override
        public String toString() {
            return this.original.toString();
        }
    }
}

