/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import tigase.form.Field;
import tigase.form.Form;
import tigase.util.Base64;
import tigase.xmpp.JID;

public class SignatureCalculator {
    private static final String ALGORITHM = "SHA1";
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String SUPPORTED_TYPE = "urn:xmpp:xdata:signature:oauth1";
    private final Comparator<Field> fieldComparator = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getVar().compareToIgnoreCase(o2.getVar());
        }
    };
    private String oauthConsumerKey;
    private String oauthConsumerSecret;
    private String oauthSignatureMethod = "HMAC-SHA1";
    private String oauthToken;
    private String oauthTokenSecret;
    private String oauthVersion = "1.0";
    private Random random = new SecureRandom();

    protected static String escape(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static byte[] hmac(SecretKey key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        return mac.doFinal(data);
    }

    public SignatureCalculator() {
    }

    public SignatureCalculator(String oauthConsumerKey, String oauthConsumerSecret) {
        this.oauthToken = this.randomString();
        this.oauthTokenSecret = this.randomString();
        this.oauthConsumerKey = oauthConsumerKey;
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public SignatureCalculator(String oauthToken, String oauthTokenSecret, String oauthConsumerKey, String oauthConsumerSecret) {
        this.oauthToken = oauthToken;
        this.oauthTokenSecret = oauthTokenSecret;
        this.oauthConsumerKey = oauthConsumerKey;
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public void addEmptyFields(Form form) {
        form.addField(Field.fieldHidden("FORM_TYPE", SUPPORTED_TYPE));
        form.addField(Field.fieldHidden("oauth_version", this.oauthVersion));
        form.addField(Field.fieldHidden("oauth_signature_method", this.oauthSignatureMethod));
        form.addField(Field.fieldHidden("oauth_token", this.oauthToken));
        form.addField(Field.fieldHidden("oauth_token_secret", this.oauthTokenSecret));
        form.addField(Field.fieldHidden("oauth_nonce", null));
        form.addField(Field.fieldHidden("oauth_timestamp", null));
        form.addField(Field.fieldHidden("oauth_consumer_key", null));
        form.addField(Field.fieldHidden("oauth_signature", null));
    }

    public String calculateSignature(JID to, Form form) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKey key = this.key((SignatureCalculator.escape(this.oauthConsumerSecret) + "&" + SignatureCalculator.escape(this.oauthTokenSecret)).getBytes());
        String pStr = this.pStr(form.getAllFields());
        String bStr = SignatureCalculator.escape(form.getType()) + "&" + SignatureCalculator.escape(to == null ? "" : to.toString()) + "&" + SignatureCalculator.escape(pStr);
        String sig = SignatureCalculator.escape(Base64.encode(SignatureCalculator.hmac(key, bStr.getBytes())));
        return sig;
    }

    public String getOauthConsumerKey() {
        return this.oauthConsumerKey;
    }

    public String getOauthConsumerSecret() {
        return this.oauthConsumerSecret;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public String getOauthTokenSecret() {
        return this.oauthTokenSecret;
    }

    protected byte[] h(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(ALGORITHM);
        return digest.digest(data);
    }

    public boolean isMethodSupported(String fOauthSignatureMethod) {
        return fOauthSignatureMethod.equals(this.oauthSignatureMethod);
    }

    protected SecretKey key(byte[] key) {
        return new SecretKeySpec(key, "HmacSHA1");
    }

    private String pStr(List<Field> fields) {
        ArrayList<Field> tmp = new ArrayList<Field>(fields);
        Collections.sort(tmp, this.fieldComparator);
        StringBuilder sb = new StringBuilder();
        Iterator<Field> it = tmp.iterator();
        while (it.hasNext()) {
            Field f = it.next();
            if ("oauth_signature".equals(f.getVar()) || "oauth_token_secret".equals(f.getVar())) continue;
            sb.append(SignatureCalculator.escape(f.getVar())).append("=").append(SignatureCalculator.escape(f.getValue()));
            if (!it.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    protected String randomString() {
        int length = 20;
        int x = ALPHABET.length();
        char[] buffer = new char[20];
        for (int i = 0; i < 20; ++i) {
            int r = this.random.nextInt(x);
            buffer[i] = ALPHABET.charAt(r);
        }
        return new String(buffer);
    }

    public void setOauthConsumerKey(String oauthConsumerKey) {
        this.oauthConsumerKey = oauthConsumerKey;
    }

    public void setOauthConsumerSecret(String oauthConsumerSecret) {
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public void setOauthTokenSecret(String oauthTokenSecret) {
        this.oauthTokenSecret = oauthTokenSecret;
    }

    public void sign(JID to, Form form) throws InvalidKeyException, NoSuchAlgorithmException {
        String nonce = this.randomString();
        long timestamp = System.currentTimeMillis() / 1000L;
        this.sign(to, nonce, timestamp, form);
    }

    public void sign(JID to, String nonce, long timestamp, Form form) throws InvalidKeyException, NoSuchAlgorithmException {
        form.addField(Field.fieldHidden("FORM_TYPE", SUPPORTED_TYPE));
        form.addField(Field.fieldHidden("oauth_version", this.oauthVersion));
        form.addField(Field.fieldHidden("oauth_signature_method", this.oauthSignatureMethod));
        form.addField(Field.fieldHidden("oauth_token", this.oauthToken));
        form.addField(Field.fieldHidden("oauth_token_secret", this.oauthTokenSecret));
        form.addField(Field.fieldHidden("oauth_nonce", nonce));
        form.addField(Field.fieldHidden("oauth_timestamp", String.valueOf(timestamp)));
        form.addField(Field.fieldHidden("oauth_consumer_key", this.oauthConsumerKey));
        String sig = this.calculateSignature(to, form);
        form.addField(Field.fieldHidden("oauth_signature", sig));
    }
}

