/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.script.ScriptEngineManager;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.component.AbstractComponent;
import tigase.component.AbstractContext;
import tigase.component.modules.Module;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.ConfigurationException;
import tigase.disteventbus.EventBusFactory;
import tigase.disteventbus.component.AddListenerScriptCommand;
import tigase.disteventbus.component.EventBusContext;
import tigase.disteventbus.component.EventPublisherModule;
import tigase.disteventbus.component.EventReceiverModule;
import tigase.disteventbus.component.ListenerScript;
import tigase.disteventbus.component.ListenerScriptRegistrar;
import tigase.disteventbus.component.RemoveListenerScriptCommand;
import tigase.disteventbus.component.SubscribeModule;
import tigase.disteventbus.component.UnsubscribeModule;
import tigase.disteventbus.component.stores.Affiliation;
import tigase.disteventbus.component.stores.AffiliationStore;
import tigase.disteventbus.component.stores.SubscriptionStore;
import tigase.disteventbus.impl.LocalEventBus;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xmpp.JID;

public class EventBusComponent
extends AbstractComponent<EventBusContext>
implements ClusteredComponentIfc {
    public static final String COMPONENT_EVENTS_XMLNS = "tigase:eventbus";
    private static final String THREADS_KEY = "threads";
    private static long counter = 0L;
    private final AffiliationStore affiliationStore = new AffiliationStore();
    private final Map<String, ListenerScript> listenersScripts = new ConcurrentHashMap<String, ListenerScript>();
    private final SubscriptionStore subscriptionStore = new SubscriptionStore();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ListenerScriptRegistrar scriptsRegistrar;

    @Override
    protected EventBusContext createContext() {
        return new EventBusContextImpl(this);
    }

    @Override
    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    @Override
    protected Map<String, Class<? extends Module>> getDefaultModulesList() {
        HashMap<String, Class<? extends Module>> result = new HashMap<String, Class<? extends Module>>();
        result.put("subscribe", SubscribeModule.class);
        result.put("unsubscribe", UnsubscribeModule.class);
        result.put("receiver", EventReceiverModule.class);
        result.put("publisher", EventPublisherModule.class);
        result.put("urn:xmpp:ping", XmppPingModule.class);
        result.put("jabber:iq:version", JabberVersionModule.class);
        result.put("commands", AdHocCommandModule.class);
        result.put("disco", DiscoveryModule.class);
        return result;
    }

    @Override
    public String getDiscoCategory() {
        return "component";
    }

    @Override
    public String getDiscoCategoryType() {
        return "generic";
    }

    @Override
    public String getDiscoDescription() {
        return "Distributed EventBus";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return false;
    }

    @Override
    public boolean isSubdomain() {
        return false;
    }

    @Override
    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Cluster node " + jid + " added to Affiliation Store");
        }
        ((EventBusContext)this.context).getAffiliationStore().putAffiliation(jid, Affiliation.owner);
        Object module = this.modulesManager.getModule("subscribe");
        if (module != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeConnected(jid);
        }
    }

    @Override
    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        Object module = this.modulesManager.getModule("subscribe");
        if (module != null && module instanceof SubscribeModule) {
            ((SubscribeModule)module).clusterNodeDisconnected(jid);
        }
        ((EventBusContext)this.context).getAffiliationStore().removeAffiliation(jid);
    }

    @Override
    public void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.scriptsRegistrar = new ListenerScriptRegistrar(this.listenersScripts, (EventBusContext)this.context, this.scriptEngineManager);
        AdHocCommandModule adHocCommandModule = (AdHocCommandModule)this.getModuleProvider().getModule("commands");
        if (adHocCommandModule != null) {
            adHocCommandModule.register(new AddListenerScriptCommand(this.scriptEngineManager, this.scriptsRegistrar));
            adHocCommandModule.register(new RemoveListenerScriptCommand(this.listenersScripts, this.scriptsRegistrar));
        }
        if (props.containsKey("allowed-subscribers")) {
            String[] x;
            String t = (String)props.get("allowed-subscribers");
            for (String string : x = t.split(",")) {
                ((EventBusContext)this.context).getAffiliationStore().putAffiliation(JID.jidInstanceNS(string), Affiliation.member);
            }
        }
        if (props.containsKey(THREADS_KEY)) {
            Integer threads = (Integer)props.get(THREADS_KEY);
            ((EventBusContext)this.context).getEventBusInstance().setThreadPool(threads);
        }
        this.scriptsRegistrar.load();
    }

    private class EventBusContextImpl
    extends AbstractContext
    implements EventBusContext {
        private final LocalEventBus eventBusInstance;

        public EventBusContextImpl(AbstractComponent<?> component) {
            super(component);
            this.eventBusInstance = (LocalEventBus)EventBusFactory.getInstance();
        }

        @Override
        public AffiliationStore getAffiliationStore() {
            return EventBusComponent.this.affiliationStore;
        }

        @Override
        public Collection<JID> getConnectedNodes() {
            return Collections.unmodifiableCollection(EventBusComponent.this.getNodesConnected());
        }

        @Override
        public LocalEventBus getEventBusInstance() {
            return this.eventBusInstance;
        }

        @Override
        public SubscriptionStore getSubscriptionStore() {
            return EventBusComponent.this.subscriptionStore;
        }
    }
}

