/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.db.comp.RepositoryItem;

public abstract class ConfigRepository<Item extends RepositoryItem>
implements ComponentRepository<Item> {
    private static final Logger log = Logger.getLogger(ConfigRepository.class.getName());
    protected Map<String, Item> items;
    protected int itemsHash = 0;
    private Timer autoLoadTimer = null;
    private RepositoryChangeListenerIfc<Item> repoChangeList = null;

    @Override
    public void setAutoloadTimer(long delay) {
        long interval = delay * 1000L;
        if (this.autoLoadTimer != null) {
            this.autoLoadTimer.cancel();
            this.autoLoadTimer = null;
        }
        if (interval > 0L) {
            this.autoLoadTimer = new Timer(this.getConfigKey(), true);
            this.autoLoadTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        ConfigRepository.this.reload();
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "exception during reload of config repository items", ex);
                    }
                }
            }, 5000L, interval);
        }
    }

    @Override
    public void addRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding new repository listener: {0}", repoChangeListener);
        }
        this.repoChangeList = repoChangeListener;
    }

    @Override
    public void removeRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        this.repoChangeList = null;
    }

    public String toString() {
        return this.items.toString();
    }

    public abstract String getConfigKey();

    public abstract String[] getDefaultPropetyItems();

    public abstract String getPropertyKey();

    @Override
    public void addItem(Item item) {
        this.addItemNoStore(item);
        this.store();
    }

    @Override
    public void addItemNoStore(Item item) {
        RepositoryItem old = (RepositoryItem)this.items.put(item.getKey(), item);
        if (this.repoChangeList != null) {
            if (old == null) {
                log.log(Level.INFO, "Calling itemAdded for: {0}", item);
                this.repoChangeList.itemAdded(item);
            } else if (this.itemChanged(old, item)) {
                log.log(Level.INFO, "Calling itemUpadted for: {0}", item);
                this.repoChangeList.itemUpdated(item);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Not calling itemUpadted for: {0}, item unchanged.", item);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No repoChangeListener for: {0}", item);
        }
    }

    protected void initItemsMap() {
        if (null == this.items) {
            this.items = new ConcurrentSkipListMap<String, Item>(String.CASE_INSENSITIVE_ORDER);
        }
    }

    public boolean itemChanged(Item oldItem, Item newItem) {
        return true;
    }

    @Override
    public Collection<Item> allItems() {
        return this.items.values();
    }

    @Override
    public boolean contains(String key) {
        return this.items.keySet().contains(key);
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        this.initItemsMap();
        String[] items_arr = this.getDefaultPropetyItems();
        if (params.get(this.getPropertyKey()) != null) {
            items_arr = ((String)params.get(this.getPropertyKey())).split(",");
            for (int i = 0; i < items_arr.length; ++i) {
                items_arr[i] = items_arr[i].trim();
            }
        }
        defs.put(this.getConfigKey(), items_arr);
    }

    @Override
    public Item getItem(String key) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting item: {0} of items: {1}", new Object[]{key, this.items.keySet()});
        }
        return (Item)((RepositoryItem)this.items.get(key));
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.values().iterator();
    }

    @Override
    public void reload() {
    }

    @Override
    public void removeItem(String key) {
        RepositoryItem item = (RepositoryItem)this.items.remove(key);
        if (item != null) {
            this.store();
            if (this.repoChangeList != null) {
                this.repoChangeList.itemRemoved(item);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Removing item: {0}", item);
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.initItemsMap();
        String[] items_arr = (String[])properties.get(this.getConfigKey());
        if (items_arr != null && items_arr.length > 0) {
            this.items.clear();
            for (String it : items_arr) {
                log.log(Level.CONFIG, "Loading config item: {0}", it);
                Object item = this.getItemInstance();
                item.initFromPropertyString(it);
                this.addItem(item);
                log.log(Level.CONFIG, "Loaded config item: {0}", item);
            }
        } else {
            log.warning("Items list is not set in the configuration file!!");
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public void store() {
    }

    @Override
    public String validateItem(Item item) {
        return null;
    }
}

