/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileReader;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import tigase.xml.CData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;

public class Element
implements XMLNodeIfc<Element> {
    protected XMLIdentityHashMap<String, String> attributes = null;
    protected LinkedList<XMLNodeIfc> children = null;
    protected String defxmlns = null;
    protected String name = null;
    protected String xmlns = null;

    public Element(Element element) {
        Element src = element.clone();
        this.attributes = src.attributes;
        this.name = src.name;
        this.defxmlns = src.defxmlns;
        this.xmlns = src.xmlns;
        this.children = src.children;
    }

    public Element(String argName) {
        this.setName(argName);
    }

    public Element(String argName, String argCData) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
    }

    public Element(String argName, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, Element[] children, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
        this.addChildren(Arrays.asList(children));
    }

    public Element(String argName, String argCData, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String argCData, StringBuilder[] att_names, StringBuilder[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give file name as parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[1];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler dom = new DomBuilderHandler();
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(dom, buff, 0, result);
        }
        file.close();
        Queue<Element> elems = dom.getParsedElements();
        for (Element elem : elems) {
            elem.clone();
            System.out.println(elem.toString());
        }
    }

    public void addAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Map<String, String> attrs) {
        if (this.attributes == null) {
            this.attributes = new XMLIdentityHashMap(attrs.size());
        }
        XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes;
        synchronized (xMLIdentityHashMap) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                this.attributes.put(entry.getKey().intern(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(XMLNodeIfc child) {
        if (child == null) {
            throw new NullPointerException("Element child can not be null.");
        }
        if (this.children == null) {
            this.children = new LinkedList();
        }
        LinkedList<XMLNodeIfc> linkedList = this.children;
        synchronized (linkedList) {
            this.children.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(List<Element> children) {
        if (children == null) {
            return;
        }
        if (this.children == null) {
            this.children = new LinkedList();
        }
        LinkedList<XMLNodeIfc> linkedList = this.children;
        synchronized (linkedList) {
            for (XMLNodeIfc xMLNodeIfc : children) {
                this.children.add((XMLNodeIfc)xMLNodeIfc.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String childrenToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null) continue;
                    result.append(child.toString());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String childrenToStringPretty() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null) continue;
                    result.append(child.toStringPretty());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String childrenToStringSecure() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null) continue;
                    result.append(child.toStringSecure());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    @Override
    public Element clone() {
        Element result = null;
        try {
            result = (Element)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.attributes = this.attributes != null ? (XMLIdentityHashMap)this.attributes.clone() : null;
        if (this.children != null) {
            result.setChildren(this.children);
        } else {
            result.children = null;
        }
        return result;
    }

    @Override
    public int compareTo(Element elem) {
        return this.toStringNoChildren().compareTo(elem.toStringNoChildren());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            return this.toStringNoChildren().equals(elem.toStringNoChildren());
        }
        return false;
    }

    public Element findChildStaticStr(String[] elementPath) {
        String str;
        if (elementPath[0] != this.getName()) {
            return null;
        }
        Element child = this;
        for (int i = 1; i < elementPath.length && child != null; child = child.getChildStaticStr(str), ++i) {
            str = elementPath[i];
        }
        return child;
    }

    public Element findChild(String[] elemPath) {
        String str;
        if (elemPath[0].isEmpty()) {
            elemPath = Arrays.copyOfRange(elemPath, 1, elemPath.length);
        }
        if (!elemPath[0].equals(this.getName())) {
            return null;
        }
        Element child = this;
        for (int i = 1; i < elemPath.length && child != null; child = child.getChild(str), ++i) {
            str = elemPath[i];
        }
        return child;
    }

    @Deprecated
    public Element findChild(String elementPath) {
        return this.findChild(elementPath.split("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getAttribute(String attName) {
        if (this.attributes != null) {
            XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes;
            synchronized (xMLIdentityHashMap) {
                return (String)this.attributes.get(attName.intern());
            }
        }
        return null;
    }

    @Deprecated
    public String getChildAttribute(String childName, String attName) {
        String result = null;
        Element child = this.getChild(childName);
        if (child != null) {
            result = child.getAttribute(attName);
        }
        return result;
    }

    public String getChildAttributeStaticStr(String childName, String attName) {
        String result = null;
        Element child = this.getChild(childName);
        if (child != null) {
            result = child.getAttributeStaticStr(attName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeStaticStr(String attName) {
        if (this.attributes != null) {
            XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes;
            synchronized (xMLIdentityHashMap) {
                return (String)this.attributes.get(attName);
            }
        }
        return null;
    }

    @Deprecated
    public String getAttribute(String elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    @Deprecated
    public String getAttribute(String[] elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    public String getAttributeStaticStr(String[] elementPath, String att_name) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getAttributeStaticStr(att_name) : null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes != null ? new LinkedHashMap<String, String>(this.attributes) : null;
    }

    @Deprecated
    public String getCData(String elementPath) {
        return this.getChildCData(elementPath);
    }

    public String getCData(String[] elementPath) {
        return this.getChildCData(elementPath);
    }

    public String getCDataStaticStr(String[] elementPath) {
        return this.getChildCDataStaticStr(elementPath);
    }

    public String getCData() {
        return this.cdataToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name) {
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc el : this.children) {
                    Element elem;
                    if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name)) continue;
                    return elem;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChildStaticStr(String name) {
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc el : this.children) {
                    Element elem;
                    if (!(el instanceof Element) || (elem = (Element)el).getName() != name) continue;
                    return elem;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getChild(String name, String child_xmlns) {
        if (child_xmlns == null) {
            return this.getChild(name);
        }
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc el : this.children) {
                    Element elem;
                    if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name) || elem.getXMLNS() != child_xmlns && !child_xmlns.equals(elem.getXMLNS())) continue;
                    return elem;
                }
            }
        }
        return null;
    }

    @Deprecated
    public String getChildCData(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getChildCData(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getChildCDataStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getCData() : null;
    }

    public List<Element> getChildren() {
        if (this.children != null) {
            LinkedList<Element> result = new LinkedList<Element>();
            for (XMLNodeIfc node : this.children) {
                if (!(node instanceof Element)) continue;
                result.add((Element)node);
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public List<Element> getChildren(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public List<Element> getChildren(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public List<Element> getChildrenStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getXMLNS() {
        if (this.xmlns == null) {
            this.xmlns = this.getAttributeStaticStr("xmlns");
            this.xmlns = this.xmlns != null ? this.xmlns.intern() : null;
        }
        return this.xmlns != null ? this.xmlns : this.defxmlns;
    }

    @Deprecated
    public String getXMLNS(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getXMLNS(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getXMLNSStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public int hashCode() {
        return this.toStringNoChildren().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String key) {
        if (this.attributes != null) {
            XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes;
            synchronized (xMLIdentityHashMap) {
                this.attributes.remove(key.intern());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Element child) {
        boolean res = false;
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                res = this.children.remove(child);
            }
        }
        return res;
    }

    public void setAttributeStaticStr(String[] elementPath, String att_name, String att_value) {
        Element child = this.findChildStaticStr(elementPath);
        if (child != null) {
            child.setAttribute(att_name, att_value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new XMLIdentityHashMap(5);
        }
        XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes;
        synchronized (xMLIdentityHashMap) {
            String k = key.intern();
            String v = value;
            if (k == "xmlns") {
                v = this.xmlns = value.intern();
            }
            this.attributes.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, String> newAttributes) {
        XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes = new XMLIdentityHashMap(newAttributes.size());
        synchronized (xMLIdentityHashMap) {
            for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(StringBuilder[] names, StringBuilder[] values) {
        XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes = new XMLIdentityHashMap(names.length);
        synchronized (xMLIdentityHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.setAttribute(names[i].toString(), values[i].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String[] names, String[] values) {
        XMLIdentityHashMap<String, String> xMLIdentityHashMap = this.attributes = new XMLIdentityHashMap(names.length);
        synchronized (xMLIdentityHashMap) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                this.setAttribute(names[i], values[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCData(String argCData) {
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null || !(child instanceof CData)) continue;
                    ((CData)child).setCdata(argCData);
                    return;
                }
            }
        }
        this.addChild(new CData(argCData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<XMLNodeIfc> children) {
        LinkedList<XMLNodeIfc> linkedList = this.children = new LinkedList();
        synchronized (linkedList) {
            for (XMLNodeIfc child : children) {
                this.children.add((XMLNodeIfc)child.clone());
            }
        }
    }

    public void setDefXMLNS(String ns) {
        this.defxmlns = ns.intern();
    }

    public void setName(String argName) {
        this.name = argName.intern();
    }

    public void setXMLNS(String ns) {
        this.xmlns = ns.intern();
        this.setAttribute("xmlns", this.xmlns);
    }

    public String toString() {
        String childrenStr;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((childrenStr = this.childrenToString()) != null && childrenStr.length() > 0) {
            result.append(">");
            result.append(childrenStr);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    @Override
    public String toStringPretty() {
        String childrenStr;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((childrenStr = this.childrenToStringPretty()) != null && childrenStr.length() > 0) {
            result.append(">");
            result.append("\n");
            result.append(childrenStr);
            result.append("</").append(this.name).append(">");
            result.append("\n");
        } else {
            result.append("/>");
            result.append("\n");
        }
        return result.toString();
    }

    public String toStringNoChildren() {
        String cdata;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((cdata = this.cdataToString()) != null) {
            result.append(">");
            if (cdata != null) {
                result.append(cdata);
            }
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    @Override
    public String toStringSecure() {
        String childrenStr;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((childrenStr = this.childrenToStringSecure()) != null && childrenStr.length() > 0) {
            result.append(">");
            result.append(childrenStr);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cdataToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            LinkedList<XMLNodeIfc> linkedList = this.children;
            synchronized (linkedList) {
                for (XMLNodeIfc child : this.children) {
                    if (child == null || !(child instanceof CData)) continue;
                    result.append(child.toString());
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    protected class XMLIdentityHashMap<K, V>
    extends IdentityHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        private XMLIdentityHashMap(int size) {
            super(size);
        }

        @Override
        public V put(K key, V value) {
            if (key == null || value == null) {
                throw new NullPointerException("Neither attribute key or value can be set to null. Attribute: " + key + ", value: " + value);
            }
            return super.put(key, value);
        }
    }
}

