/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import tigase.disteventbus.LocalEventBus;

public class EventsNameMap<M> {
    private static final String NULL_NAME = new String(new byte[]{0});
    private final Map<String, Map<String, Collection<M>>> dataMap = this.createMainDataMap();

    protected Collection<M> createDataList() {
        return new HashSet();
    }

    protected Map<String, Map<String, Collection<M>>> createMainDataMap() {
        return new ConcurrentHashMap<String, Map<String, Collection<M>>>();
    }

    protected Map<String, Collection<M>> createNamesDataMap() {
        return new ConcurrentHashMap<String, Collection<M>>();
    }

    public void delete(M data) {
        Iterator<Map.Entry<String, Map<String, Collection<M>>>> namesIt = this.dataMap.entrySet().iterator();
        while (namesIt.hasNext()) {
            Map<String, Collection<M>> datas = namesIt.next().getValue();
            Iterator<Map.Entry<String, Collection<M>>> dataIt = datas.entrySet().iterator();
            while (dataIt.hasNext()) {
                Collection<M> d = dataIt.next().getValue();
                d.remove(data);
            }
        }
    }

    public void delete(String name, String xmlns, M data) {
        String eventName = name == null ? NULL_NAME : name;
        Map<String, Collection<M>> namesData = this.dataMap.get(xmlns);
        if (namesData == null) {
            return;
        }
        Collection<M> dataCollection = namesData.get(eventName);
        if (dataCollection == null) {
            return;
        }
        dataCollection.remove(data);
        if (dataCollection.isEmpty()) {
            namesData.remove(eventName);
        }
        if (namesData.isEmpty()) {
            this.dataMap.remove(xmlns);
        }
    }

    public Collection<M> get(String name, String xmlns) {
        String eventName = name == null ? NULL_NAME : name;
        Map<String, Collection<M>> namesData = this.dataMap.get(xmlns);
        if (namesData == null) {
            return Collections.emptyList();
        }
        Collection<M> dataList = namesData.get(eventName);
        if (dataList == null) {
            return Collections.emptyList();
        }
        return dataList;
    }

    public Set<LocalEventBus.EventName> getAllListenedEvents() {
        HashSet<LocalEventBus.EventName> result = new HashSet<LocalEventBus.EventName>();
        for (Map.Entry<String, Map<String, Collection<M>>> e : this.dataMap.entrySet()) {
            String xmlns = e.getKey();
            for (String n : e.getValue().keySet()) {
                result.add(new LocalEventBus.EventName(n == NULL_NAME ? null : n, xmlns));
            }
        }
        return result;
    }

    public boolean hasData(String name, String xmlns) {
        String eventName = name == null ? NULL_NAME : name;
        Map<String, Collection<M>> namesData = this.dataMap.get(xmlns);
        if (namesData == null || namesData.isEmpty()) {
            return false;
        }
        Collection<M> dataList = namesData.get(eventName);
        return dataList != null && !dataList.isEmpty();
    }

    public void put(String name, String xmlns, M data) {
        Collection<M> dataList;
        String eventName = name == null ? NULL_NAME : name;
        Map<String, Collection<M>> namesData = this.dataMap.get(xmlns);
        if (namesData == null) {
            namesData = this.createNamesDataMap();
            this.dataMap.put(xmlns, namesData);
        }
        if ((dataList = namesData.get(eventName)) == null) {
            dataList = this.createDataList();
            namesData.put(eventName, dataList);
        }
        dataList.add(data);
    }
}

