/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqPrivate
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    private static Logger log = Logger.getLogger(JabberIqPrivate.class.getName());
    private static final String XMLNS = "jabber:iq:private";
    private static final String PRIVATE_KEY = "jabber:iq:private";
    private static final String ID = "jabber:iq:private";
    private static final String[] XMLNSS = new String[]{"jabber:iq:private"};
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:private"})};

    @Override
    public String id() {
        return "jabber:iq:private";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            log.info("Session null, dropping packet: " + packet.toString());
            return;
        }
        try {
            if (packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
                results.offer(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "You are not authorized to access this private storage.", true));
                return;
            }
            if (packet.getFrom().equals(session.getConnectionId())) {
                List<Element> elems = packet.getElemChildrenStaticStr(Iq.IQ_QUERY_PATH);
                if (elems != null && elems.size() > 0) {
                    Element elem = elems.get(0);
                    StanzaType type = packet.getType();
                    switch (type) {
                        case get: {
                            String priv = session.getData("jabber:iq:private", elem.getName() + elem.getXMLNS(), null);
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Loaded private data for key: " + elem.getName() + ": " + priv);
                            }
                            if (priv != null) {
                                results.offer(this.parseXMLData(priv, packet));
                                break;
                            }
                            results.offer(packet.okResult((String)null, 2));
                            break;
                        }
                        case set: {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Saving private data: " + elem.toString());
                            }
                            session.setData("jabber:iq:private", elem.getName() + elem.getXMLNS(), elem.toString());
                            results.offer(packet.okResult((String)null, 0));
                            break;
                        }
                        case result: {
                            break;
                        }
                        default: {
                            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                            break;
                        }
                    }
                } else {
                    results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Missing query child element", true));
                }
            } else {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to access this private storage.", true));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received privacy request but user session is not authorized yet: " + packet.toString());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.warning("Database proble, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse(domHandler, data.toCharArray(), 0, data.length());
        Queue<Element> elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 1);
        Element query = result.getElement().findChildStaticStr(Iq.IQ_QUERY_PATH);
        for (Element el : elems) {
            query.addChild(el);
        }
        return result;
    }
}

