/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.ReceiverTaskIfc;
import tigase.server.sreceiver.RosterItem;
import tigase.server.sreceiver.StanzaReceiver;
import tigase.server.sreceiver.TaskCommandIfc;
import tigase.server.sreceiver.TaskCommons;
import tigase.stats.StatRecord;
import tigase.util.TigaseStringprepException;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class TaskInstanceCommand
implements TaskCommandIfc {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.TaskInstanceCommand");
    protected static final String ACTION_FIELD = "action-field";
    protected static final String USER_ACTION_FIELD = "user-action-field";
    protected static final String CONFIRM = "confirm-field";
    protected static final String PENDING_MODERATIONS_FIELD = "Pending moderations";
    protected static final String SUBSCRIBERS_FIELD = "Subscribers";
    protected static final String ROSTER_ACTION_FIELD = "roster-action-field";

    @Override
    public String getDescription() {
        return "Manage task exiting instance";
    }

    @Override
    public String getNodeName() {
        return "*";
    }

    @Override
    public void processCommand(Packet packet, Packet result, StanzaReceiver receiv) {
        String task_name = packet.getStanzaTo().toString();
        ReceiverTaskIfc task = receiv.getTaskInstances().get(task_name);
        if (task == null && (task_name = Command.getFieldValue(packet, "Task name")) != null) {
            task = receiv.getTask(task_name);
        }
        if (task != null) {
            task_name = task.getJID().toString();
            if (!receiv.isAdmin(packet.getStanzaFrom()) && !task.isAdmin(packet.getStanzaFrom())) {
                Command.addFieldValue(result, "Info", "You are not administrator of: " + task_name + " task.", "fixed");
                Command.addFieldValue(result, "Info", "You can not execute task commands.", "fixed");
                return;
            }
            Command.addFieldValue(result, "Task name", task_name, "hidden");
            String action_str = Command.getFieldValue(packet, ACTION_FIELD);
            if (action_str == null) {
                this.taskMainScreen(result, task);
                return;
            }
            Command.addFieldValue(result, ACTION_FIELD, action_str, "hidden");
            ACTION action = ACTION.valueOf(action_str);
            switch (action) {
                case TASK_CONFIGURATION: {
                    this.editConfiguration(packet, result, receiv);
                    break;
                }
                case USER_MANAGEMENT: {
                    try {
                        this.manageUsers(packet, result, receiv);
                    }
                    catch (TigaseStringprepException ex) {
                        Logger.getLogger(TaskInstanceCommand.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case REMOVE_TASK: {
                    this.removeTask(packet, result, receiv);
                    break;
                }
            }
        } else {
            Command.setStatus(result, Command.Status.executing);
            Command.addAction(result, Command.Action.next);
            Command.addFieldValue(result, "Task name", "", "text-single", "Enter task JID or Name");
        }
    }

    private void editConfiguration(Packet packet, Packet result, StanzaReceiver receiv) {
        String confirm = Command.getFieldValue(packet, CONFIRM);
        String task_name = Command.getFieldValue(packet, "Task name");
        ReceiverTaskIfc task = receiv.getTaskInstances().get(task_name);
        if (confirm == null) {
            Command.addFieldValue(result, CONFIRM, "true", "hidden");
            Command.setStatus(result, Command.Status.executing);
            Command.addAction(result, Command.Action.complete);
            TaskCommons.propertyItems2Command(task.getParams(), result);
        } else {
            Command.addFieldValue(result, "Info", "Changed parameters for " + task_name + ":", "fixed");
            Map<String, PropertyItem> old_params = task.getParams();
            LinkedHashMap<String, Object> new_params = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, PropertyItem> entry : old_params.entrySet()) {
                if (entry.getValue().isMultiValue()) {
                    String[] values = Command.getFieldValues(packet, XMLUtils.escape(entry.getKey()));
                    new_params.put(entry.getKey(), values);
                    continue;
                }
                String value = Command.getFieldValue(packet, XMLUtils.escape(entry.getKey()));
                if (value == null) {
                    value = "";
                }
                if ((value = XMLUtils.unescape(value)).equals(entry.getValue().toString())) continue;
                new_params.put(entry.getKey(), value);
                Command.addFieldValue(result, "Info", entry.getValue().getDisplay_name() + ": " + value, "fixed");
            }
            try {
                task.setParams(new_params);
                receiv.saveTaskToRepository(task);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem with saving task to repository: " + task.getJID(), e);
                Command.addFieldValue(result, "Info", "Problem saving task to repository, look in log file for details.", "fixed");
            }
        }
    }

    private void manageUsers(Packet packet, Packet result, StanzaReceiver receiv) throws TigaseStringprepException {
        String task_name = Command.getFieldValue(packet, "Task name");
        ReceiverTaskIfc task = receiv.getTaskInstances().get(task_name);
        String user_action = Command.getFieldValue(packet, USER_ACTION_FIELD);
        if (user_action == null) {
            Command.setStatus(result, Command.Status.executing);
            Command.addAction(result, Command.Action.complete);
            Command.addAction(result, Command.Action.next);
            Command.addFieldValue(result, "Info", "Select action and user:", "fixed");
            String[] actions = USER_ACTION.strValues();
            LinkedList<String> moderated = new LinkedList<String>();
            for (RosterItem ri : task.getRoster().values()) {
                if (ri.isModerationAccepted()) continue;
                moderated.add(ri.getJid().toString());
            }
            if (moderated.size() > 0) {
                Command.addFieldValue(result, USER_ACTION_FIELD, actions[0], "Select action", actions, actions);
                String[] moder = moderated.toArray(new String[0]);
                Command.addFieldValue(result, PENDING_MODERATIONS_FIELD, moder[0], PENDING_MODERATIONS_FIELD, moder, moder, "list-multi");
            } else {
                Command.addFieldValue(result, USER_ACTION_FIELD, actions[2], "Select action", actions, actions);
                Command.addFieldValue(result, "Info", "No pending moderations.", "fixed");
            }
            String[] all_subscr = new String[task.getRoster().values().size()];
            int idx = 0;
            for (RosterItem ri : task.getRoster().values()) {
                all_subscr[idx++] = ri.getJid().toString();
            }
            Command.addFieldValue(result, SUBSCRIBERS_FIELD, all_subscr[0], SUBSCRIBERS_FIELD, all_subscr, all_subscr);
        } else {
            Command.addFieldValue(result, USER_ACTION_FIELD, user_action, "hidden");
            String[] jids = Command.getFieldValues(packet, PENDING_MODERATIONS_FIELD);
            block0 : switch (USER_ACTION.valueOf(user_action)) {
                case APROVE_PENDING_MODERATIONS: {
                    if (jids != null) {
                        Map<JID, RosterItem> roster = task.getRoster();
                        for (String jid : jids) {
                            RosterItem ri = roster.get(JID.jidInstanceNS(jid));
                            if (ri != null) {
                                task.setRosterItemModerationAccepted(ri, true);
                                receiv.addOutPacket(TaskCommons.getMessage(ri.getJid(), task.getJID(), StanzaType.headline, "Your subscription has been approved."));
                                continue;
                            }
                            log.warning("Missing jid: " + jid + " in task: " + task_name + " roster.");
                        }
                        Command.addFieldValue(result, "Info", "Subscriptions have been approved.", "fixed");
                        break;
                    }
                    Command.addFieldValue(result, "Info", "No subscriptions to approve.", "fixed");
                    break;
                }
                case REJECT_PENDING_MODERATIONS: {
                    if (jids != null) {
                        JID[] jjids = new JID[jids.length];
                        int idx = 0;
                        for (String jid : jids) {
                            jjids[idx] = JID.jidInstanceNS(jid);
                            receiv.addOutPacket(TaskCommons.getMessage(task.getJID(), jjids[idx++], StanzaType.headline, "Your subscription has been rejected."));
                        }
                        receiv.removeTaskSubscribers(task, jjids);
                        Command.addFieldValue(result, "Info", "Subscriptions have been rejected.", "fixed");
                        break;
                    }
                    Command.addFieldValue(result, "Info", "No subscriptions to reject.", "fixed");
                    break;
                }
                case SELECT_USER: {
                    JID jid = JID.jidInstance(Command.getFieldValue(packet, SUBSCRIBERS_FIELD));
                    RosterItem ri = task.getRoster().get(jid);
                    if (ri != null) {
                        String roster_action = Command.getFieldValue(packet, ROSTER_ACTION_FIELD);
                        if (roster_action == null) {
                            Command.setStatus(result, Command.Status.executing);
                            Command.addAction(result, Command.Action.complete);
                            Command.addFieldValue(result, "Info", "Update subscription data for: " + jid, "fixed");
                            Command.addFieldValue(result, SUBSCRIBERS_FIELD, jid.toString(), "hidden");
                            String[] actions = ROSTER_ACTION.strValues();
                            Command.addFieldValue(result, ROSTER_ACTION_FIELD, actions[0], "Select action", actions, actions);
                            String[] bool_arr = new String[]{"true", "false"};
                            Command.addFieldValue(result, "subscribed-ri", Boolean.valueOf(ri.isSubscribed()).toString(), "Subscribed", bool_arr, bool_arr);
                            Command.addFieldValue(result, "moderation-ri", Boolean.valueOf(ri.isModerationAccepted()).toString(), "Moderation approved", bool_arr, bool_arr);
                            Command.addFieldValue(result, "owner-ri", Boolean.valueOf(ri.isOwner()).toString(), "Owner", bool_arr, bool_arr);
                            Command.addFieldValue(result, "admin-ri", Boolean.valueOf(ri.isAdmin()).toString(), "Admin", bool_arr, bool_arr);
                            break;
                        }
                        Command.addFieldValue(result, ROSTER_ACTION_FIELD, roster_action, "hidden");
                        switch (ROSTER_ACTION.valueOf(roster_action)) {
                            case UPDATE_DATA: {
                                ri.setSubscribed(TaskCommons.parseBool(Command.getFieldValue(packet, "subscribed-ri")));
                                ri.setModerationAccepted(TaskCommons.parseBool(Command.getFieldValue(packet, "moderation-ri")));
                                ri.setOwner(TaskCommons.parseBool(Command.getFieldValue(packet, "owner-ri")));
                                ri.setAdmin(TaskCommons.parseBool(Command.getFieldValue(packet, "admin-ri")));
                                task.setRosterItemModerationAccepted(ri, ri.isModerationAccepted());
                                Command.addFieldValue(result, "Info", "Subscription data for user " + jid + " have been updated.", "fixed");
                                break block0;
                            }
                            case REMOVE_USER: {
                                receiv.removeTaskSubscribers(task, jid);
                                Command.addFieldValue(result, "Info", "Subscription for user " + jid + " has been removed.", "fixed");
                                break block0;
                            }
                        }
                        break;
                    }
                    Command.addFieldValue(result, "Info", "There was a problem accesing user subscription data.", "fixed");
                    break;
                }
            }
        }
    }

    private void removeTask(Packet packet, Packet result, StanzaReceiver receiv) {
        String confirm = Command.getFieldValue(packet, CONFIRM);
        String task_name = Command.getFieldValue(packet, "Task name");
        if (confirm == null) {
            Command.addFieldValue(result, CONFIRM, "true", "hidden");
            Command.setStatus(result, Command.Status.executing);
            Command.addAction(result, Command.Action.complete);
            Command.addFieldValue(result, "Info", "Are you sure you want to remove task: " + task_name + " and all it's data?", "fixed");
            Command.addFieldValue(result, "Info", "Note! There is no undo for task deletion function", "fixed");
            return;
        }
        receiv.removeTaskInstance(receiv.getTask(task_name));
        Command.addFieldValue(result, "Info", "Task " + task_name + " has been removed.", "fixed");
    }

    private void taskMainScreen(Packet result, ReceiverTaskIfc task) {
        Command.setStatus(result, Command.Status.executing);
        Command.addAction(result, Command.Action.next);
        List<StatRecord> stats = task.getStats();
        if (stats != null) {
            for (StatRecord rec : stats) {
                Command.addFieldValue(result, "Info", rec.getDescription() + ": " + rec.getValue(), "fixed");
            }
        }
        String[] actions = ACTION.strValues();
        Command.addFieldValue(result, ACTION_FIELD, actions[0], "Select action", actions, actions);
    }

    public static enum USER_ACTION {
        APROVE_PENDING_MODERATIONS,
        REJECT_PENDING_MODERATIONS,
        SELECT_USER;


        public static String[] strValues() {
            String[] possible_values = new String[USER_ACTION.values().length];
            int i = 0;
            for (USER_ACTION val : USER_ACTION.values()) {
                possible_values[i++] = val.toString();
            }
            return possible_values;
        }
    }

    public static enum ROSTER_ACTION {
        UPDATE_DATA,
        REMOVE_USER;


        public static String[] strValues() {
            String[] possible_values = new String[ROSTER_ACTION.values().length];
            int i = 0;
            for (ROSTER_ACTION val : ROSTER_ACTION.values()) {
                possible_values[i++] = val.toString();
            }
            return possible_values;
        }
    }

    public static enum ACTION {
        TASK_CONFIGURATION,
        USER_MANAGEMENT,
        REMOVE_TASK;


        public static String[] strValues() {
            String[] possible_values = new String[ACTION.values().length];
            int i = 0;
            for (ACTION val : ACTION.values()) {
                possible_values[i++] = val.toString();
            }
            return possible_values;
        }
    }
}

