/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import tigase.osgi.Activator;
import tigase.util.ClassComparator;
import tigase.util.ObjectComparator;

public class ClassUtil {
    private static final String[] SKIP_CONTAINS = new String[]{".ui.", ".swing", ".awt", ".sql.", ".xml.", ".terracotta."};
    private static final String[] SKIP_STARTS = new String[]{"com.mysql", "tigase.pubsub.Utils", "org.apache.derby", "org.apache.xml", "org.postgresql", "com.sun", "groovy", "org.codehaus.groovy", "org.netbeans", "org.python", "com.google.gwt", "xtigase.http.client.BasePanel", "org.osgi"};

    public static String getClassNameFromFileName(String fileName) {
        String class_name = null;
        if (fileName.endsWith(".class")) {
            int off = fileName.charAt(0) == '/' ? 1 : 0;
            String tmp_class_name = fileName.substring(off, fileName.length() - 6).replace('\\', '.');
            class_name = tmp_class_name.replace('/', '.');
        }
        return class_name;
    }

    public static void walkInDirForFiles(File base_dir, String path, Set<String> set) {
        File tmp_file = new File(base_dir, path);
        if (tmp_file.isDirectory()) {
            String[] files;
            for (String file : files = tmp_file.list()) {
                ClassUtil.walkInDirForFiles(base_dir, new File(path, file).toString(), set);
            }
        } else {
            if (path.toString().contains("Plugin")) {
                System.out.println("File: " + path.toString());
            }
            set.add(path);
        }
    }

    public static Set<String> getFileListDeep(File path) {
        TreeSet<String> set = new TreeSet<String>();
        if (path.isDirectory()) {
            String[] files;
            for (String file : files = path.list()) {
                ClassUtil.walkInDirForFiles(path, file, set);
            }
        } else {
            set.add(path.toString());
        }
        return set;
    }

    public static Set<String> getClassNamesFromDir(File dir) {
        Set<String> tmp_set = ClassUtil.getFileListDeep(dir);
        TreeSet<String> result = new TreeSet<String>();
        for (String elem : tmp_set) {
            String class_name = ClassUtil.getClassNameFromFileName(elem);
            if (class_name == null) continue;
            result.add(class_name);
            if (!class_name.contains("Plugin")) continue;
            System.out.println("class name: " + class_name);
        }
        return result;
    }

    public static Set<String> getClassNamesFromJar(File jarFile) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jar_entries = jar.entries();
        while (jar_entries.hasMoreElements()) {
            JarEntry jar_entry = jar_entries.nextElement();
            String class_name = ClassUtil.getClassNameFromFileName(jar_entry.getName());
            if (class_name == null) continue;
            result.add(class_name);
        }
        return result;
    }

    public static Set<String> getClassNamesFromWar(File jarFile) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jar_entries = jar.entries();
        while (jar_entries.hasMoreElements()) {
            String class_name;
            JarEntry jar_entry = jar_entries.nextElement();
            String name = jar_entry.getName();
            if (!name.startsWith("WEB-INF/classes/") || (class_name = ClassUtil.getClassNameFromFileName(name = name.substring(16))) == null) continue;
            result.add(class_name);
        }
        return result;
    }

    public static Set<Class> getClassesFromNames(ClassLoader loader, Set<String> names) throws ClassNotFoundException {
        TreeSet<Class> classes = new TreeSet<Class>(new ClassComparator());
        for (String name : names) {
            try {
                String test_str;
                int n;
                boolean skip_class = false;
                String[] stringArray = SKIP_CONTAINS;
                int n2 = stringArray.length;
                for (n = 0; n < n2 && !(skip_class = name.contains(test_str = stringArray[n])); ++n) {
                }
                if (!skip_class) {
                    stringArray = SKIP_STARTS;
                    n2 = stringArray.length;
                    for (n = 0; n < n2 && !(skip_class = name.startsWith(test_str = stringArray[n])); ++n) {
                    }
                }
                if (skip_class) continue;
                Class<?> cls = loader.loadClass(name);
                classes.add(cls);
            }
            catch (NoClassDefFoundError e) {
                System.out.println("Class not found name: " + name);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("Class unsatisfied name: " + name);
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                System.out.println("Class name: " + name);
                e.printStackTrace();
                if (cause == null) continue;
                cause.printStackTrace();
            }
        }
        return classes;
    }

    public static Set<Class> getClassesFromClassPath() throws IOException, ClassNotFoundException {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        String classpath = System.getProperty("java.class.path");
        System.out.println("classpath: " + classpath);
        ClassLoader loader = ClassUtil.class.getClassLoader();
        StringTokenizer stok = new StringTokenizer(classpath, File.pathSeparator, false);
        while (stok.hasMoreTokens()) {
            Set<String> class_names;
            String path = stok.nextToken();
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                System.out.println("directory: " + path);
                class_names = ClassUtil.getClassNamesFromDir(file);
                classes_set.addAll(ClassUtil.getClassesFromNames(loader, class_names));
            }
            if (!file.isFile()) continue;
            class_names = ClassUtil.getClassNamesFromJar(file);
            classes_set.addAll(ClassUtil.getClassesFromNames(loader, class_names));
        }
        return classes_set;
    }

    public static <T extends Class> Set<T> getClassesImplementing(Collection<Class> classes, T cls) {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        for (Class c : classes) {
            int mod;
            if (c.getName().contains("Plugin")) {
                System.out.println(c.getName() + " " + cls.isAssignableFrom(c));
            }
            if (!cls.isAssignableFrom(c) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
            classes_set.add(c);
        }
        return classes_set;
    }

    public static <T extends Class> Set<T> getClassesImplementing(T cls) throws IOException, ClassNotFoundException {
        return ClassUtil.getClassesImplementing(Activator.getBundle(), cls);
    }

    public static <T> Set<T> getImplementations(Class<T> obj) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TreeSet<Object> result = new TreeSet<Object>(new ObjectComparator());
        for (Class<T> cls : ClassUtil.getClassesImplementing(obj)) {
            result.add(cls.newInstance());
        }
        return result;
    }

    public static <T extends Class> Set<T> getClassesImplementing(ClassLoader loader, File f, T cls) throws IOException, ClassNotFoundException {
        Set<String> class_names = f.getName().endsWith(".war") ? ClassUtil.getClassNamesFromWar(f) : ClassUtil.getClassNamesFromJar(f);
        Set<Class> classes = ClassUtil.getClassesFromNames(loader, class_names);
        return ClassUtil.getClassesImplementing(classes, cls);
    }

    public static <T extends Class> Set<T> getClassesImplementing(Bundle bundle, T cls) throws IOException, ClassNotFoundException {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        Enumeration e = bundle.findEntries("/", "*.class", true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL clsUrl = (URL)e.nextElement();
                String clsName = ClassUtil.getClassNameFromFileName(clsUrl.getPath());
                boolean skip_class = false;
                for (String prefix : SKIP_STARTS) {
                    if (!clsName.startsWith(prefix)) continue;
                    skip_class = true;
                    break;
                }
                if (skip_class) continue;
                for (String part : SKIP_CONTAINS) {
                    if (!clsName.contains(part)) continue;
                    skip_class = true;
                    break;
                }
                if (skip_class) continue;
                try {
                    int mod;
                    Class c = bundle.loadClass(clsName);
                    if (!cls.isAssignableFrom(c) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
                    classes_set.add(c);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(ClassUtil.class.getCanonicalName()).warning("Could not find class = " + clsName);
                }
            }
        }
        return classes_set;
    }

    public static <T extends Class, S extends Class> Set<S> getClassesAnnotated(ClassLoader loader, File f, T cls) throws IOException, ClassNotFoundException {
        Set<String> class_names = f.getName().endsWith(".war") ? ClassUtil.getClassNamesFromWar(f) : ClassUtil.getClassNamesFromJar(f);
        Set<Class> classes = ClassUtil.getClassesFromNames(loader, class_names);
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        for (Class c : classes) {
            int mod;
            Annotation[] annots = c.getAnnotations();
            if (!c.isAnnotationPresent(cls) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
            classes_set.add(c);
        }
        return classes_set;
    }

    public static <T extends Class, S extends Class> Set<S> getClassesAnnotated(Bundle bundle, T cls) throws IOException, ClassNotFoundException {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        Enumeration e = bundle.findEntries("/", "*.class", true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL clsUrl = (URL)e.nextElement();
                String clsName = ClassUtil.getClassNameFromFileName(clsUrl.getPath());
                boolean skip_class = false;
                for (String prefix : SKIP_STARTS) {
                    if (!clsName.startsWith(prefix)) continue;
                    skip_class = true;
                    break;
                }
                if (skip_class) continue;
                for (String part : SKIP_CONTAINS) {
                    if (!clsName.contains(part)) continue;
                    skip_class = true;
                    break;
                }
                if (skip_class) continue;
                try {
                    int mod;
                    Class c = bundle.loadClass(clsName);
                    Annotation[] annots = c.getAnnotations();
                    if (!c.isAnnotationPresent(cls) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
                    classes_set.add(c);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(ClassUtil.class.getCanonicalName()).warning("Could not find class = " + clsName);
                }
            }
        }
        return classes_set;
    }
}

