/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.xmpp.BareJID;

public class AuthRepositoryPool
implements AuthRepository {
    private static final Logger log = Logger.getLogger(AuthRepositoryPool.class.getName());
    private LinkedBlockingQueue<AuthRepository> repoPool = new LinkedBlockingQueue();

    public void addRepo(AuthRepository repo) {
        this.repoPool.offer(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.addUser(user, password);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.digestAuth(user, digest, id, alg);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    @Override
    public String getResourceUri() {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getResourceUri();
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount();
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount(domain);
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return -1L;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.logout(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean otherAuth(Map<String, Object> authProps) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.otherAuth(authProps);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.plainAuth(user, password);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.queryAuth(authProps);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeUser(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    public AuthRepository takeRepo() {
        try {
            return this.repoPool.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain user auth repository from the pool", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.updatePassword(user, password);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getPassword(user);
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }
}

