/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.comp.UserRepoRepository;
import tigase.util.DNSEntry;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostRepoDefaults;
import tigase.xmpp.BareJID;

public class VHostJDBCRepository
extends UserRepoRepository<VHostItem> {
    public static final String DNS_DEF_IP_PROP_KEY = "dns-def-ip";
    public static String DNS_DEF_IP_PROP_VAL = null;
    public static final String DNS_SRV_DEF_ADDR_PROP_KEY = "dns-srv-def-addr";
    public static String DNS_SRV_DEF_ADDR_PROP_VAL = null;
    public static final String DOMAINS_PER_USER_LIMIT_PROP_KEY = "domains-per-user-limit";
    public static final int DOMAINS_PER_USER_LIMIT_PROP_VAL = 25;
    private static final Logger log = Logger.getLogger(VHostJDBCRepository.class.getName());
    private String def_ip_address = null;
    private String def_srv_address = null;
    private int max_domains_per_user = 25;

    @Override
    public void destroy() {
    }

    @Override
    public String getConfigKey() {
        return VHostRepoDefaults.getConfigKey();
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return VHostRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        DNS_SRV_DEF_ADDR_PROP_VAL = DNSResolver.getDefaultHostname();
        try {
            DNS_DEF_IP_PROP_VAL = DNSResolver.getHostIP(DNSResolver.getDefaultHostname());
        }
        catch (Exception e) {
            DNS_DEF_IP_PROP_VAL = DNSResolver.getDefaultHostname();
        }
        defs.put(DNS_SRV_DEF_ADDR_PROP_KEY, DNS_SRV_DEF_ADDR_PROP_VAL);
        defs.put(DNS_DEF_IP_PROP_KEY, DNS_DEF_IP_PROP_VAL);
        defs.put(DOMAINS_PER_USER_LIMIT_PROP_KEY, 25);
    }

    @Override
    public VHostItem getItemInstance() {
        return VHostRepoDefaults.getItemInstance();
    }

    @Override
    public String getItemsListPKey() {
        return VHostRepoDefaults.getItemsListPKey();
    }

    @Override
    public String getPropertyKey() {
        return VHostRepoDefaults.getPropertyKey();
    }

    @Override
    public BareJID getRepoUser() {
        return VHostRepoDefaults.getRepoUser();
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.def_srv_address = (String)properties.get(DNS_SRV_DEF_ADDR_PROP_KEY);
        if (this.def_srv_address != null && !this.def_srv_address.endsWith(".")) {
            this.def_srv_address = this.def_srv_address + ".";
        }
        this.def_ip_address = (String)properties.get(DNS_DEF_IP_PROP_KEY);
        this.max_domains_per_user = (Integer)properties.get(DOMAINS_PER_USER_LIMIT_PROP_KEY);
        this.setAutoloadTimer(60L);
    }

    @Override
    public String validateItem(VHostItem item) {
        if (item.getVhost() == null || item.getVhost().getDomain() == null || item.getVhost().getDomain().isEmpty()) {
            return "Domain name not specified";
        }
        int vhost_count = 0;
        for (VHostItem it : this.allItems()) {
            if (!it.isOwner(item.getOwner())) continue;
            ++vhost_count;
        }
        if (vhost_count >= this.max_domains_per_user) {
            return "Maximum number of domains exceeded for the user! Current number is: " + vhost_count;
        }
        if (item.getS2sSecret() == null) {
            return "S2S Secret is required";
        }
        if (System.getProperty("vhost-disable-dns-check") != null) {
            return null;
        }
        try {
            DNSEntry[] entries = DNSResolver.getHostSRV_Entries(item.getKey());
            if (entries != null) {
                for (DNSEntry dNSEntry : entries) {
                    log.finest("Validating DNS SRV settings ('" + dNSEntry + "') for the given hostname: " + item.getKey() + " (defaults: " + this.def_ip_address + ", " + this.def_srv_address);
                    if (!Arrays.asList(dNSEntry.getIps()).contains(this.def_ip_address) && !this.def_srv_address.equals(dNSEntry.getDnsResultHost())) continue;
                    return null;
                }
                return "Incorrect DNS SRV settings" + Arrays.asList(entries);
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        try {
            String[] ipAddress = DNSResolver.getHostIPs(item.getKey());
            if (ipAddress != null) {
                if (Arrays.asList(ipAddress).contains(this.def_ip_address)) {
                    return null;
                }
                return "Incorrect IP address: '" + Arrays.asList(ipAddress) + "' found in DNS for the given host: " + item.getKey();
            }
            return "No DNS settings found for given host: " + item.getKey();
        }
        catch (UnknownHostException ex1) {
            return "There is no DNS settings for given host: " + item.getKey();
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        VHostJDBCRepository repo = new VHostJDBCRepository();
        repo.getDefaults(props, params);
        props.put(DNS_SRV_DEF_ADDR_PROP_KEY, "tigase.me");
        props.put(DOMAINS_PER_USER_LIMIT_PROP_KEY, 50);
        repo.setProperties(props);
        VHostItem domain = null;
        try {
            domain = new VHostItem("tigase.im");
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(VHostJDBCRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("repo.validateItem( domain ) :: " + repo.validateItem(domain));
    }
}

